/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.LogSaverResultForwarder;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.TimeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ShardMainResultForwarder
extends ResultForwarder
implements ILogSaverListener {
    private final int mInitCount;
    private int mShardsRemaining;
    private long mTotalElapsed = 0L;
    private boolean mStartReported = false;
    private long mFirstShardEndTime = 0L;
    private IInvocationContext mOriginalContext;
    private List<IInvocationContext> mShardContextList;
    private int mShardIndex = 0;
    private Map<String, Long> mInvocationMetrics = new HashMap<String, Long>();

    public ShardMainResultForwarder(List<ITestInvocationListener> listeners, int expectedShards) {
        super(listeners);
        this.mShardsRemaining = expectedShards;
        this.mInitCount = expectedShards;
        this.mShardContextList = new ArrayList<IInvocationContext>();
    }

    @Override
    public List<ITestInvocationListener> getListeners() {
        return super.getListeners();
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        if (!this.mStartReported) {
            this.mOriginalContext = context;
            super.invocationStarted(context);
            this.mStartReported = true;
        } else {
            Integer shardIndex = null;
            if (context.getConfigurationDescriptor() != null) {
                shardIndex = context.getConfigurationDescriptor().getShardIndex();
            }
            int index = this.mShardIndex;
            if (shardIndex != null) {
                index = shardIndex;
            }
            this.mOriginalContext.addSerialsFromShard(index, context.getSerials());
            this.mShardContextList.add(context);
            ++this.mShardIndex;
        }
    }

    @Override
    public void invocationFailed(Throwable cause) {
        super.invocationFailed(cause);
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        super.invocationFailed(failure);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        this.invocationEnded(elapsedTime, null);
    }

    public void invocationEnded(long elapsedTime, IInvocationContext context) {
        this.mTotalElapsed += elapsedTime;
        if (this.mInitCount == this.mShardsRemaining) {
            this.mFirstShardEndTime = System.currentTimeMillis();
        }
        --this.mShardsRemaining;
        if (context == null) {
            this.copyShardBuildInfoToMain(this.mOriginalContext, this.mShardContextList, true);
        } else {
            this.copyShardBuildInfoToMain(this.mOriginalContext, Arrays.asList(context), this.mShardsRemaining <= 0);
        }
        if (this.mShardsRemaining <= 0) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "There was %s between the first and last shard ended.", TimeUtil.formatElapsedTime(System.currentTimeMillis() - this.mFirstShardEndTime));
            super.invocationEnded(this.mTotalElapsed);
        }
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        for (ITestInvocationListener listener : this.getListeners()) {
            try {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).testLogSaved(dataName, dataType, dataStream, logFile);
            }
            catch (Exception e) {
                LogUtil.CLog.e("Exception while invoking %s#testLogSaved", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    public void testLogForward(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        for (ITestInvocationListener listener : this.getListeners()) {
            if (listener instanceof LogSaverResultForwarder) {
                ((LogSaverResultForwarder)listener).testLogForward(dataName, dataType, dataStream);
                continue;
            }
            try {
                listener.testLog(dataName, dataType, dataStream);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("RuntimeException while invoking %s#testLog", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        for (ITestInvocationListener listener : this.getListeners()) {
            try {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(dataName, logFile);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Failed to provide the log association");
                LogUtil.CLog.e(e);
            }
        }
    }

    private void copyShardBuildInfoToMain(IInvocationContext main, List<IInvocationContext> shardContexts, boolean lastContext) {
        for (IInvocationContext shard : shardContexts) {
            for (String deviceName : shard.getDeviceConfigNames()) {
                IBuildInfo iBuildInfo = shard.getBuildInfo(deviceName);
                IBuildInfo mainBuild = main.getBuildInfo(deviceName);
                if (mainBuild != null) {
                    for (Map.Entry<String, String> entry : iBuildInfo.getBuildAttributes().entrySet()) {
                        mainBuild.addBuildAttribute(entry.getKey(), entry.getValue());
                    }
                    for (String vKey : iBuildInfo.getVersionedFileKeys()) {
                        if (mainBuild.getVersionedFile(vKey) != null) continue;
                        VersionedFile shardFile = iBuildInfo.getVersionedFile(vKey);
                        mainBuild.setFile(vKey, shardFile.getFile(), shardFile.getVersion());
                    }
                    continue;
                }
                LogUtil.CLog.e("Found a device '%s' in shard configuration but not in parent configuration.", deviceName);
            }
            MultiMap<String, String> attributes = shard.getAttributes();
            for (InvocationMetricLogger.InvocationGroupMetricKey invocationGroupMetricKey : InvocationMetricLogger.InvocationGroupMetricKey.values()) {
                HashSet<String> attKeys = new HashSet<String>(attributes.keySet());
                for (String attKey : attKeys) {
                    List<String> values2;
                    if (!attKey.startsWith(invocationGroupMetricKey.toString() + ":") || (values2 = attributes.get(attKey)) == null) continue;
                    attributes.remove(attKey);
                    for (String val : values2) {
                        if (invocationGroupMetricKey.shouldAdd()) {
                            long baseValue = 0L;
                            if (this.mInvocationMetrics.get(attKey) != null) {
                                baseValue = this.mInvocationMetrics.get(attKey);
                            }
                            try {
                                long newVal = baseValue + Long.parseLong(val);
                                this.mInvocationMetrics.put(attKey, newVal);
                            }
                            catch (NumberFormatException e) {
                                LogUtil.CLog.e(e);
                            }
                            continue;
                        }
                        main.addInvocationAttribute(attKey, val);
                    }
                }
            }
            for (Enum enum_ : InvocationMetricLogger.InvocationMetricKey.values()) {
                List<String> values3;
                if (!attributes.containsKey(((InvocationMetricLogger.InvocationMetricKey)enum_).toString()) || (values3 = attributes.get(((InvocationMetricLogger.InvocationMetricKey)enum_).toString())) == null) continue;
                attributes.remove(((InvocationMetricLogger.InvocationMetricKey)enum_).toString());
                for (String val : values3) {
                    if (((InvocationMetricLogger.InvocationMetricKey)enum_).shouldAdd()) {
                        long baseValue = 0L;
                        if (this.mInvocationMetrics.get(((InvocationMetricLogger.InvocationMetricKey)enum_).toString()) != null) {
                            baseValue = this.mInvocationMetrics.get(((InvocationMetricLogger.InvocationMetricKey)enum_).toString());
                        }
                        try {
                            long newVal = baseValue + Long.parseLong(val);
                            this.mInvocationMetrics.put(((InvocationMetricLogger.InvocationMetricKey)enum_).toString(), newVal);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    main.addInvocationAttribute(((InvocationMetricLogger.InvocationMetricKey)enum_).toString(), val);
                }
            }
            if (!lastContext) continue;
            for (Map.Entry entry : this.mInvocationMetrics.entrySet()) {
                main.addInvocationAttribute((String)entry.getKey(), Long.toString((Long)entry.getValue()));
            }
            this.mInvocationMetrics.clear();
        }
    }
}

