/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.ExecutionProperties;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

public class TestInformation {
    private final IInvocationContext mContext;
    private final ExecutionProperties mProperties;
    private final ExecutionFiles mExecutionFiles;
    private final File mDependenciesFolder;
    private int mPrimaryDeviceIndex = 0;
    private boolean mTestTimedOut = false;

    private TestInformation(Builder builder) {
        this.mContext = builder.mContext;
        this.mProperties = builder.mProperties;
        this.mDependenciesFolder = builder.mDependenciesFolder;
        this.mExecutionFiles = builder.mExecutionFiles;
    }

    private TestInformation(TestInformation invocationInfo, IInvocationContext moduleContext, boolean copyExecFile) {
        this.mContext = moduleContext;
        this.mProperties = new ExecutionProperties();
        this.mProperties.putAll(invocationInfo.mProperties.getAll());
        this.mDependenciesFolder = invocationInfo.mDependenciesFolder;
        if (copyExecFile) {
            this.mExecutionFiles = new ExecutionFiles();
            this.mExecutionFiles.putAll(invocationInfo.executionFiles());
        } else {
            this.mExecutionFiles = invocationInfo.mExecutionFiles;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static TestInformation createModuleTestInfo(TestInformation invocationInfo, IInvocationContext moduleContext) {
        return new TestInformation(invocationInfo, moduleContext, false);
    }

    public static TestInformation createCopyTestInfo(TestInformation invocationInfo, IInvocationContext context) {
        return new TestInformation(invocationInfo, context, true);
    }

    public IInvocationContext getContext() {
        return this.mContext;
    }

    public ITestDevice getDevice() {
        return this.mContext.getDevices().get(this.mPrimaryDeviceIndex);
    }

    public List<ITestDevice> getDevices() {
        return this.mContext.getDevices();
    }

    public IBuildInfo getBuildInfo() {
        return this.mContext.getBuildInfos().get(this.mPrimaryDeviceIndex);
    }

    public final void setActiveDeviceIndex(int index) {
        this.mPrimaryDeviceIndex = index;
    }

    public ExecutionProperties properties() {
        return this.mProperties;
    }

    public ExecutionFiles executionFiles() {
        return this.mExecutionFiles;
    }

    public File dependenciesFolder() {
        return this.mDependenciesFolder;
    }

    public boolean isTestTimedOut() {
        return this.mTestTimedOut;
    }

    public void notifyTimeout() {
        this.mTestTimedOut = true;
    }

    public File getDependencyFile(String fileName, boolean targetFirst) throws FileNotFoundException {
        File dependency = null;
        dependency = this.getFromEnv(fileName, targetFirst);
        if (dependency != null && dependency.isFile()) {
            return dependency;
        }
        dependency = this.getFromTestsDir(fileName);
        if (dependency != null && dependency.isFile()) {
            return dependency;
        }
        dependency = this.getFile(fileName);
        if (dependency != null && dependency.isFile()) {
            return dependency;
        }
        dependency = this.getFromDependencyFolder(fileName);
        if (dependency != null && dependency.isFile()) {
            return dependency;
        }
        throw new FileNotFoundException(String.format("Could not find an artifact file associated with %s", fileName));
    }

    private File getFromEnv(String fileName, boolean targetFirst) {
        File file2;
        File testsDir;
        ExecutionFiles.FilesKey hostOrTarget = ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY;
        if (targetFirst) {
            hostOrTarget = ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY;
        }
        if ((testsDir = this.mExecutionFiles.get(hostOrTarget)) != null && testsDir.exists() && (file2 = FileUtil.findFile(testsDir, fileName)) != null) {
            return file2;
        }
        return null;
    }

    private File getFromTestsDir(String fileName) {
        File testsDir = this.mExecutionFiles.get(ExecutionFiles.FilesKey.TESTS_DIRECTORY);
        if (testsDir != null && testsDir.exists()) {
            File file2 = FileUtil.findFile(testsDir, fileName);
            if (file2 == null) {
                file2 = this.getBuildInfo().stageRemoteFile(fileName, testsDir);
                if (file2 != null) {
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.STAGE_UNDEFINED_DEPENDENCY, fileName);
                }
            } else if (file2.isDirectory()) {
                LogUtil.CLog.d("Found %s as a directory, searching further.", fileName);
                file2 = FileUtil.findFile(file2, fileName);
            }
            return file2;
        }
        return null;
    }

    private File getFile(String fileName) {
        return this.mExecutionFiles.get(fileName);
    }

    private File getFromDependencyFolder(String fileName) {
        File file2;
        File testsDir = this.mDependenciesFolder;
        if (testsDir != null && testsDir.exists() && (file2 = FileUtil.findFile(testsDir, fileName)) != null) {
            return file2;
        }
        return null;
    }

    public static class Builder {
        private IInvocationContext mContext;
        private ExecutionProperties mProperties = new ExecutionProperties();
        private File mDependenciesFolder;
        private ExecutionFiles mExecutionFiles = new ExecutionFiles();

        private Builder() {
        }

        public TestInformation build() {
            return new TestInformation(this);
        }

        public Builder setInvocationContext(IInvocationContext context) {
            this.mContext = context;
            return this;
        }

        public Builder setDependenciesFolder(File dependenciesFolder) {
            this.mDependenciesFolder = dependenciesFolder;
            return this;
        }
    }
}

