/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.CommandLineBuildInfoBuilder;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.clearcut.ClearcutClient;
import com.android.tradefed.command.CommandRunner;
import com.android.tradefed.command.CommandScheduler;
import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.filter.OptionFetcher;
import com.android.tradefed.config.proxy.AutomatedReporters;
import com.android.tradefed.config.remote.ExtendedFile;
import com.android.tradefed.dependencies.ExternalDependency;
import com.android.tradefed.dependencies.IExternalDependency;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.TcpDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.cloud.ManagedRemoteDevice;
import com.android.tradefed.device.cloud.NestedRemoteDevice;
import com.android.tradefed.device.cloud.RemoteAndroidVirtualDevice;
import com.android.tradefed.device.internal.DeviceReleaseReporter;
import com.android.tradefed.error.HarnessException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.ConditionFailureMonitor;
import com.android.tradefed.invoker.DelegatedInvocationExecution;
import com.android.tradefed.invoker.DeviceUnavailableMonitor;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.IInvocationExecution;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.InvocationExecution;
import com.android.tradefed.invoker.RemoteInvocationExecution;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.logger.TfObjectTracker;
import com.android.tradefed.invoker.sandbox.ParentSandboxInvocationExecution;
import com.android.tradefed.invoker.sandbox.SandboxedInvocationExecution;
import com.android.tradefed.invoker.shard.LastShardDetector;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.BaseLeveledLogOutput;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.log.StdoutLogger;
import com.android.tradefed.postprocessor.IPostProcessor;
import com.android.tradefed.result.ActionInProgress;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.EventsLoggerListener;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogSaverResultForwarder;
import com.android.tradefed.result.ReportPassedTests;
import com.android.tradefed.result.ResultAndLogForwarder;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.retry.ResultAggregator;
import com.android.tradefed.retry.RetryStrategy;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IDisableable;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.PrettyPrintDelimiter;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunInterruptedException;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.TimeUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TestInvocation
implements ITestInvocation {
    public static final String COMMAND_ARGS_KEY = "command_line_args";
    private static final String BATTERY_ATTRIBUTE_FORMAT_KEY = "%s-battery-%s";
    public static final String TRADEFED_LOG_NAME = "host_log";
    public static final String TRADEFED_END_HOST_LOG = "end_host_log";
    public static final String TRADEFED_INVOC_COMPLETE_HOST_LOG = "invoc_complete_host_log";
    private static final String TRADEFED_DELEGATED_LOG_NAME = "delegated_parent_log";
    public static final String TRADEFED_CONFIG_NAME = "tradefed-expanded-config";
    static final String BEFORE_SHARDING_SUFFIX = "_before_sharding";
    static final String DEVICE_LOG_NAME_PREFIX = "device_logcat_";
    static final String EMULATOR_LOG_NAME_PREFIX = "emulator_log_";
    static final String BUILD_ERROR_BUGREPORT_NAME = "build_error_bugreport";
    static final String DEVICE_UNRESPONSIVE_BUGREPORT_NAME = "device_unresponsive_bugreport";
    static final String INVOCATION_ENDED_BUGREPORT_NAME = "invocation_ended_bugreport";
    static final String TARGET_SETUP_ERROR_BUGREPORT_NAME = "target_setup_error_bugreport";
    static final String BATT_TAG = "[battery level]";
    static final String RECOVERY_LOG_DEVICE_PATH = "/tmp/recovery.log";
    public static final String INVOCATION_EXTERNAL_DEPENDENCIES = "invocation-external-dependencies";
    public static final long AVAILABILITY_CHECK_TIMEOUT = 180000L;
    private String mStatus = "(not invoked)";
    private String mStopCause = null;
    private ErrorIdentifier mStopErrorId = null;
    private Long mStopRequestTime = null;
    private Long mSoftStopRequestTime = null;
    private boolean mShutdownBeforeTest = false;
    private boolean mTestStarted = false;
    private boolean mTestDone = false;
    private boolean mForcedStopRequestedAfterTest = false;
    private boolean mIsRemoteInvocation = false;
    private boolean mInvocationFailed = false;
    private boolean mDelegatedInvocation = false;
    private List<ICommandScheduler.IScheduledInvocationListener> mSchedulerListeners = new ArrayList<ICommandScheduler.IScheduledInvocationListener>();
    private DeviceUnavailableMonitor mUnavailableMonitor = new DeviceUnavailableMonitor();
    private ConditionFailureMonitor mConditionalFailureMonitor = new ConditionFailureMonitor();
    private CommandRunner.ExitCode mExitCode = CommandRunner.ExitCode.NO_ERROR;
    private Throwable mExitStack = null;
    private EventsLoggerListener mEventsLogger = null;
    private ClearcutClient mClient = null;
    private List<ExtendedFile> mParallelDynamicDownloads = new ArrayList<ExtendedFile>();

    private void logStartInvocation(IInvocationContext context, IConfiguration config) {
        String shardSuffix = "";
        if (config.getCommandOptions().getShardIndex() != null) {
            shardSuffix = String.format(" (shard %d of %d)", config.getCommandOptions().getShardIndex() + 1, config.getCommandOptions().getShardCount());
        }
        StringBuilder buildInfos = new StringBuilder();
        StringBuilder msg = new StringBuilder("Starting invocation for '");
        msg.append(context.getTestTag());
        msg.append("' with ");
        for (Map.Entry<ITestDevice, IBuildInfo> entry : context.getDeviceBuildMap().entrySet()) {
            msg.append("'[ ");
            msg.append(entry.getValue().toString());
            buildInfos.append(entry.getValue().toString());
            msg.append(" on device '");
            msg.append(entry.getKey().getSerialNumber());
            msg.append("'] ");
        }
        msg.append(shardSuffix);
        LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, msg.toString());
        this.mStatus = String.format("running %s on build(s) '%s'", context.getTestTag(), buildInfos.toString()) + shardSuffix;
    }

    /*
     * Exception decompiling
     */
    private void performInvocation(IConfiguration config, TestInformation testInfo, IInvocationExecution invocationPath, ITestInvocationListener listener, boolean devicePreSetupDone) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [158[CATCHBLOCK]], but top level block is 48[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndRun(IConfiguration config, TestInformation testInfo, IInvocationExecution invocationPath, ITestInvocationListener listener) throws Throwable {
        long startTimeNano = System.nanoTime();
        try {
            this.getRunUtil().allowInterrupt(true);
            this.logDeviceBatteryLevel(testInfo.getContext(), "initial -> setup");
            CurrentInvocation.setActionInProgress(ActionInProgress.SETUP);
            invocationPath.doSetup(testInfo, config, listener);
            if (this.mSoftStopRequestTime != null || this.mStopRequestTime != null) {
                throw new RunInterruptedException("Notified of shut down. Will not run tests", InfraErrorIdentifier.TRADEFED_SKIPPED_TESTS_DURING_SHUTDOWN);
            }
            this.logDeviceBatteryLevel(testInfo.getContext(), "setup -> test");
            this.mTestStarted = true;
            CurrentInvocation.setActionInProgress(ActionInProgress.TEST);
            invocationPath.runTests(testInfo, config, listener);
        }
        finally {
            if (this.mClient != null) {
                this.mClient.notifyTestRunFinished(startTimeNano);
            }
        }
        this.logDeviceBatteryLevel(testInfo.getContext(), "after test");
        CurrentInvocation.setActionInProgress(ActionInProgress.UNSET);
    }

    private void startInvocation(IConfiguration config, IInvocationContext context, ITestInvocationListener listener, RunMode mode, boolean parentShard) {
        this.logStartInvocation(context, config);
        listener.invocationStarted(context);
        this.logExpandedConfiguration(config, listener, mode, parentShard);
    }

    private void startInvocation(IConfiguration config, IInvocationContext context, ITestInvocationListener listener) {
        this.startInvocation(config, context, listener, null, false);
    }

    private void reportFailure(FailureDescription failure, ITestInvocationListener listener) {
        if (this.mInvocationFailed) {
            LogUtil.CLog.e("An invocation failure was already reported, ignoring %s", failure);
            return;
        }
        listener.invocationFailed(failure);
        this.mInvocationFailed = true;
    }

    public static FailureDescription createFailureFromException(Throwable exception, TestRecordProto.FailureStatus defaultStatus) {
        String message2;
        ErrorIdentifier id = null;
        if (exception instanceof IHarnessException) {
            id = ((IHarnessException)((Object)exception)).getErrorId();
        }
        if ((message2 = exception.getMessage()) == null) {
            message2 = "No error message";
        }
        FailureDescription failure = CurrentInvocation.createFailure(message2, id).setCause(exception);
        if (id == null) {
            failure.setFailureStatus(defaultStatus);
        }
        return failure;
    }

    private void reportHostLog(ITestInvocationListener listener, IConfiguration config) {
        String name = TRADEFED_LOG_NAME;
        if (this.mDelegatedInvocation) {
            name = TRADEFED_DELEGATED_LOG_NAME;
        }
        this.reportHostLog(listener, config, name);
    }

    private void reportHostLog(ITestInvocationListener listener, IConfiguration config, String name) {
        ILeveledLogOutput logger = config.getLogOutput();
        try (InputStreamSource globalLogSource = logger.getLog();){
            if (globalLogSource != null) {
                if (config.getCommandOptions().getHostLogSuffix() != null) {
                    name = name + config.getCommandOptions().getHostLogSuffix();
                }
                listener.testLog(name, LogDataType.HOST_LOG, globalLogSource);
            } else if (!(logger instanceof StdoutLogger)) {
                LogUtil.CLog.i("Skip logging %s to a file with logger '%s'", name, logger);
            }
        }
        this.getLogRegistry().unregisterLogger();
        logger.closeLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeBugreport(ITestDevice device, ITestInvocationListener listener, ICommandOptions options, String bugreportName) {
        if (device == null) {
            return;
        }
        if (device.getIDevice() instanceof StubDevice) {
            return;
        }
        if (!TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) {
            LogUtil.CLog.d("Skipping bugreportz on %s. Device is offline.", device.getSerialNumber());
            return;
        }
        ITestDevice.RecoveryMode recovery = device.getRecoveryMode();
        try {
            device.setRecoveryMode(ITestDevice.RecoveryMode.NONE);
            if (!options.isConditionalBugreportDisabled() && !this.mConditionalFailureMonitor.hasFailures()) {
                device.logAnrs(listener);
            } else {
                boolean res = device.logBugreport(String.format("%s_%s", bugreportName, device.getSerialNumber()), listener);
                if (!res) {
                    LogUtil.CLog.w("Error when collecting bugreport for device '%s'", device.getSerialNumber());
                }
            }
        }
        catch (DeviceNotAvailableException | RuntimeException e) {
            LogUtil.CLog.e("Harness Exception while collecting bugreport");
            LogUtil.CLog.e(e);
        }
        finally {
            device.setRecoveryMode(recovery);
        }
    }

    ILogRegistry getLogRegistry() {
        return LogRegistry.getLogRegistry();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public String toString() {
        return this.mStatus;
    }

    @VisibleForTesting
    void logDeviceBatteryLevel(IInvocationContext context, String event) {
        if (SystemUtil.isLocalMode()) {
            LogUtil.CLog.d("Skipping battery level log for local invocation on event: %s.", event);
            return;
        }
        for (ITestDevice testDevice : context.getDevices()) {
            if (testDevice == null || testDevice.getIDevice() instanceof StubDevice || testDevice instanceof RemoteAndroidVirtualDevice || testDevice instanceof NestedRemoteDevice) continue;
            try (CloseableTraceScope ignored = new CloseableTraceScope("log_battery");){
                Integer batteryLevel = testDevice.getBattery();
                if (batteryLevel == null) {
                    LogUtil.CLog.v("Failed to get battery level for %s", testDevice.getSerialNumber());
                    continue;
                }
                LogUtil.CLog.v("%s - %s - %d%%", BATT_TAG, event, batteryLevel);
                context.getBuildInfo(testDevice).addBuildAttribute(String.format(BATTERY_ATTRIBUTE_FORMAT_KEY, testDevice.getSerialNumber(), event), batteryLevel.toString());
            }
        }
    }

    private void logExpandedConfiguration(IConfiguration config, ITestLogger listener, RunMode mode, boolean parentShard) {
        boolean isShard;
        boolean bl = isShard = config.getConfigurationDescription().getShardIndex() != null;
        if (isShard && !parentShard) {
            LogUtil.CLog.d("Skipping expanded config log for shard.");
            return;
        }
        try (StringWriter configXmlWriter = new StringWriter();
             PrintWriter wrapperWriter = new PrintWriter(configXmlWriter);){
            config.dumpXml(wrapperWriter, new ArrayList<String>(), true, false);
            wrapperWriter.flush();
            byte[] configXmlByteArray = configXmlWriter.toString().getBytes("UTF-8");
            try (ByteArrayInputStreamSource source = new ByteArrayInputStreamSource(configXmlByteArray);){
                String prefix = "";
                if (mode != null) {
                    switch (mode) {
                        case PARENT_SANDBOX: {
                            prefix = "parent-sandbox-";
                            break;
                        }
                        case SANDBOX: {
                            prefix = "child-sandbox-";
                            break;
                        }
                        case DELEGATED_INVOCATION: {
                            prefix = "parent-delegate-";
                            break;
                        }
                        default: {
                            prefix = "";
                        }
                    }
                }
                String configOutputName = String.format("%s%s", prefix, TRADEFED_CONFIG_NAME);
                listener.testLog(configOutputName, LogDataType.HARNESS_CONFIG, source);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    private boolean invokeFetchBuild(TestInformation testInfo, IConfiguration config, IRescheduler rescheduler, ITestInvocationListener listener, IInvocationExecution invocationPath) throws Exception {
        CurrentInvocation.setActionInProgress(ActionInProgress.FETCHING_ARTIFACTS);
        Exception buildException = null;
        boolean res = false;
        try {
            res = invocationPath.fetchBuild(testInfo, config, rescheduler, listener);
            if (res) {
                try (CloseableTraceScope ignored = new CloseableTraceScope("wait_for_dynamic_download");){
                    for (ExtendedFile file2 : this.mParallelDynamicDownloads) {
                        file2.waitForDownload();
                    }
                }
                CurrentInvocation.setActionInProgress(ActionInProgress.UNSET);
                return true;
            }
            this.mStatus = "(no build to test)";
            buildException = new BuildRetrievalError("No build found to test.", (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        catch (BuildRetrievalError | DeviceNotAvailableException | RuntimeException e) {
            buildException = e;
        }
        for (ExtendedFile file3 : this.mParallelDynamicDownloads) {
            file3.cancelDownload();
        }
        this.setExitCode(CommandRunner.ExitCode.NO_BUILD, buildException);
        if (testInfo.getContext().getBuildInfos().isEmpty()) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.BACKFILL_BUILD_INFO, "true");
            IBuildInfo info = TestInvocation.backFillBuildInfoForReporting(config.getCommandLine());
            testInfo.getContext().addDeviceBuildInfo(testInfo.getContext().getDeviceConfigNames().get(0), info);
        }
        this.startInvocation(config, testInfo.getContext(), listener);
        this.reportFailure(TestInvocation.createFailureFromException(buildException, TestRecordProto.FailureStatus.INFRA_FAILURE), listener);
        for (ITestDevice device : testInfo.getContext().getDevices()) {
            invocationPath.reportLogs(device, listener, Stage.ERROR);
        }
        this.reportHostLog(listener, config);
        this.reportInvocationEnded(config, testInfo.getContext(), listener, 0L);
        LogUtil.CLog.e(buildException);
        throw buildException;
    }

    private boolean invokeRemoteDynamic(IInvocationContext context, IConfiguration config, ITestInvocationListener listener, IInvocationExecution invocationPath, RunMode mode) throws BuildRetrievalError, ConfigurationException {
        DynamicRemoteFileResolver resolver = new DynamicRemoteFileResolver(true);
        try {
            if (RunMode.REMOTE_INVOCATION.equals((Object)mode)) {
                return true;
            }
            CurrentInvocation.setActionInProgress(ActionInProgress.FETCHING_ARTIFACTS);
            resolver.setDevice(context.getDevices().get(0));
            resolver.addExtraArgs(config.getCommandOptions().getDynamicDownloadArgs());
            config.resolveDynamicOptions(resolver);
            this.mParallelDynamicDownloads.addAll(resolver.getParallelDownloads());
            CurrentInvocation.setActionInProgress(ActionInProgress.UNSET);
            return true;
        }
        catch (BuildRetrievalError | ConfigurationException | RuntimeException e) {
            for (ExtendedFile file2 : resolver.getParallelDownloads()) {
                file2.cancelDownload();
            }
            IBuildInfo info = TestInvocation.backFillBuildInfoForReporting(config.getCommandLine());
            this.mStatus = "(failed dynamic download)";
            this.setExitCode(CommandRunner.ExitCode.NO_BUILD, e);
            context.addDeviceBuildInfo(context.getDeviceConfigNames().get(0), info);
            this.startInvocation(config, context, listener);
            this.reportFailure(TestInvocation.createFailureFromException(e, TestRecordProto.FailureStatus.INFRA_FAILURE), listener);
            for (ITestDevice device : context.getDevices()) {
                invocationPath.reportLogs(device, listener, Stage.ERROR);
            }
            this.reportHostLog(listener, config);
            this.reportInvocationEnded(config, context, listener, 0L);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(IInvocationContext context, IConfiguration config, IRescheduler rescheduler, ITestInvocationListener ... extraListeners) throws DeviceNotAvailableException, Throwable {
        RunMode mode = RunMode.REGULAR;
        LogSaverResultForwarder listener = null;
        TestInformation info = null;
        ResultAggregator aggregator = null;
        CleanUpInvocationFiles cleanUpThread = null;
        try (CloseableTraceScope ignore = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.invocation_warm_up.name());){
            ArrayList<ITestInvocationListener> resultReporters;
            boolean disableReporter;
            boolean isCurrentlySubprocess;
            if (!config.getInopOptions().isEmpty()) {
                context.addInvocationAttribute("inop-options", Joiner.on(",").join(config.getInopOptions()));
            }
            if (config.getConfigurationDescription().getAllMetaData().getUniqueMap().containsKey("SERVER_REFERENCE")) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SERVER_REFERENCE, config.getConfigurationDescription().getAllMetaData().getUniqueMap().get("SERVER_REFERENCE"));
            }
            if (!(isCurrentlySubprocess = TestInvocation.isSubprocess(config))) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.INVOCATION_START, System.currentTimeMillis());
            } else {
                LogUtil.CLog.d("Fetching options from parent.");
                try (ITestInvocationListener[] fetchOptions = new OptionFetcher();){
                    fetchOptions.fetchParentOptions(config);
                }
            }
            this.applyAutomatedReporters(config);
            if (config.getCommandOptions().delegatedEarlyDeviceRelease() && System.getenv("DELEGATED_MODE") != null) {
                this.mSchedulerListeners.add(new DeviceReleaseReporter());
            }
            for (ITestInvocationListener extra : extraListeners) {
                if (!(extra instanceof ICommandScheduler.IScheduledInvocationListener)) continue;
                this.mSchedulerListeners.add((ICommandScheduler.IScheduledInvocationListener)extra);
            }
            Object sharedInfoObject = config.getConfigurationObject("shared_test_information");
            TestInformation sharedTestInfo = null;
            if (sharedInfoObject != null) {
                sharedTestInfo = (TestInformation)sharedInfoObject;
                info = TestInformation.createModuleTestInfo(sharedTestInfo, context);
            }
            if (info == null) {
                File mWorkFolder = FileUtil.createTempDir("tf-workfolder");
                info = TestInformation.newBuilder().setInvocationContext(context).setDependenciesFolder(mWorkFolder).build();
            }
            config.setConfigurationObject("TEST_INFORMATION", info);
            CurrentInvocation.addInvocationInfo(CurrentInvocation.InvocationInfo.WORK_FOLDER, info.dependenciesFolder());
            cleanUpThread = new CleanUpInvocationFiles(info, config);
            Runtime.getRuntime().addShutdownHook(cleanUpThread);
            this.registerExecutionFiles(info.executionFiles());
            List<ITestInvocationListener> allListeners = new ArrayList<ITestInvocationListener>();
            ReportPassedTests reportPass = null;
            if (config.getConfigurationObject("DELEGATE") == null && config.getCommandOptions().reportPassedTests() && !TestInvocation.isSubprocess(config)) {
                reportPass = new ReportPassedTests();
                reportPass.setConfiguration(config);
                allListeners.add(reportPass);
            }
            if (disableReporter = (resultReporters = new ArrayList<ITestInvocationListener>(config.getTestInvocationListeners())).removeIf(l -> l instanceof IDisableable && ((IDisableable)((Object)l)).isDisabled())) {
                LogUtil.CLog.d("Some reporters are disabled and won't be used.");
            }
            allListeners.addAll(resultReporters);
            allListeners.addAll(Arrays.asList(extraListeners));
            allListeners.add(this.mUnavailableMonitor);
            allListeners.add(this.mConditionalFailureMonitor);
            IRetryDecision decision = config.getRetryDecision();
            decision.setInvocationContext(context);
            if (decision instanceof ITestInformationReceiver) {
                ((ITestInformationReceiver)((Object)decision)).setTestInformation(info);
            }
            if (!config.getCommandOptions().getInvocationData().containsKey("subprocess")) {
                if (decision.isAutoRetryEnabled() && decision.getMaxRetryCount() > 1 && !RetryStrategy.NO_RETRY.equals((Object)decision.getRetryStrategy())) {
                    LogUtil.CLog.d("Auto-retry enabled, using the ResultAggregator to handle multiple retries.");
                    aggregator = new ResultAggregator(allListeners, decision.getRetryStrategy());
                    aggregator.setUpdatedReporting(decision.useUpdatedReporting());
                    allListeners = Arrays.asList(aggregator);
                } else {
                    this.mEventsLogger = new EventsLoggerListener("all-events");
                    allListeners.add(this.mEventsLogger);
                }
            }
            if (!config.getPostProcessors().isEmpty()) {
                ITestInvocationListener forwarder = new ResultAndLogForwarder(allListeners);
                for (IPostProcessor iPostProcessor : config.getPostProcessors()) {
                    if (iPostProcessor.isDisabled()) {
                        LogUtil.CLog.d("%s has been disabled. skipping.", iPostProcessor);
                        continue;
                    }
                    forwarder = iPostProcessor.init(forwarder);
                }
                listener = new LogSaverResultForwarder(config.getLogSaver(), Arrays.asList(forwarder));
            } else {
                listener = new LogSaverResultForwarder(config.getLogSaver(), allListeners);
            }
            if (reportPass != null) {
                reportPass.setLogger(listener);
            }
            if (config.getConfigurationDescription().shouldUseSandbox()) {
                mode = RunMode.SANDBOX;
            }
            if (config.getCommandOptions().shouldUseSandboxing()) {
                mode = RunMode.PARENT_SANDBOX;
            }
            if (context.getDevices().get(0) instanceof ManagedRemoteDevice) {
                mode = RunMode.REMOTE_INVOCATION;
            }
            if (config.getConfigurationObject("DELEGATE") != null) {
                this.mDelegatedInvocation = true;
                mode = RunMode.DELEGATED_INVOCATION;
            }
        }
        IInvocationExecution invocationPath = this.createInvocationExec(mode);
        this.updateInvocationContext(context, config);
        CurrentInvocation.setInvocationContext(context);
        boolean sharding = false;
        try {
            ILeveledLogOutput leveledLogOutput = config.getLogOutput();
            leveledLogOutput.init();
            if (leveledLogOutput instanceof BaseLeveledLogOutput) {
                ((BaseLeveledLogOutput)leveledLogOutput).initFilters(config);
            }
            this.getLogRegistry().registerLogger(leveledLogOutput);
            config.getSkipManager().setup(config, context);
            this.mStatus = "resolving dynamic options";
            long startDynamic = System.currentTimeMillis();
            boolean resolverSuccess = false;
            try (CloseableTraceScope ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.dynamic_download.name());){
                resolverSuccess = this.invokeRemoteDynamic(context, config, listener, invocationPath, mode);
            }
            finally {
                if (!TestInvocation.isSubprocess(config)) {
                    InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.DYNAMIC_FILE_RESOLVER_PAIR, startDynamic, System.currentTimeMillis());
                }
            }
            if (!resolverSuccess) {
                return;
            }
            this.mStatus = "fetching build";
            String cmdLineArgs = config.getCommandLine();
            if (cmdLineArgs != null) {
                LogUtil.CLog.i("Invocation was started with cmd: %s", cmdLineArgs);
            }
            long start = System.currentTimeMillis();
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FETCH_BUILD_START, start);
            boolean providerSuccess = false;
            try (CloseableTraceScope ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.fetch_artifact.name());){
                providerSuccess = this.invokeFetchBuild(info, config, rescheduler, listener, invocationPath);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FETCH_BUILD_END, end);
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.FETCH_BUILD_PAIR, start, end);
                long fetchBuildDuration = end - start;
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FETCH_BUILD, fetchBuildDuration);
                LogUtil.CLog.d("Fetch build duration: %s", TimeUtil.formatElapsedTime(fetchBuildDuration));
                throw throwable;
            }
            long end = System.currentTimeMillis();
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FETCH_BUILD_END, end);
            InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.FETCH_BUILD_PAIR, start, end);
            long fetchBuildDuration = end - start;
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FETCH_BUILD, fetchBuildDuration);
            LogUtil.CLog.d("Fetch build duration: %s", TimeUtil.formatElapsedTime(fetchBuildDuration));
            if (!providerSuccess) {
                return;
            }
            if (config.getSkipManager().shouldSkipInvocation()) {
                LogUtil.CLog.d("Skipping invocation early.");
                this.startInvocation(config, info.getContext(), listener);
                long timestamp = System.currentTimeMillis();
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_SETUP_PAIR, timestamp, timestamp);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP, 0L);
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP_PAIR, timestamp, timestamp);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP_START, timestamp);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP_END, timestamp);
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_PAIR, timestamp, timestamp);
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEARDOWN_PAIR, timestamp, timestamp);
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_TEARDOWN_PAIR, timestamp, timestamp);
                this.reportHostLog(listener, config);
                this.reportInvocationEnded(config, info.getContext(), listener, 0L);
                return;
            }
            try (CloseableTraceScope ignore = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.start_logcat.name());){
                for (String deviceName : context.getDeviceConfigNames()) {
                    context.getDevice(deviceName).clearLastConnectedWifiNetwork();
                    context.getDevice(deviceName).setOptions(config.getDeviceConfigByName(deviceName).getDeviceOptions());
                    if (!config.getDeviceConfigByName(deviceName).getDeviceOptions().isLogcatCaptureEnabled() || context.getDevice(deviceName).getIDevice() instanceof StubDevice) continue;
                    context.getDevice(deviceName).startLogcat();
                }
            }
            catch (RuntimeException e) {
                this.startInvocation(config, info.getContext(), listener);
                this.reportFailure(TestInvocation.createFailureFromException(e, TestRecordProto.FailureStatus.INFRA_FAILURE), listener);
                for (ITestDevice device : info.getContext().getDevices()) {
                    invocationPath.reportLogs(device, listener, Stage.ERROR);
                }
                this.reportHostLog(listener, config);
                this.reportInvocationEnded(config, info.getContext(), listener, 0L);
                TfObjectTracker.clearTracking();
                CurrentInvocation.clearInvocationInfos();
                LogUtil.CLog.i("Cleaning up builds");
                invocationPath.cleanUpBuilds(context, config);
                if (!sharding) {
                    this.deleteInvocationFiles(info, config);
                }
                if (!config.getCommandOptions().reportInvocationComplete()) {
                    this.getLogRegistry().dumpToGlobalLog(config.getLogOutput());
                    this.getLogRegistry().unregisterLogger();
                    config.getLogOutput().closeLog();
                }
                config.cleanConfigurationData();
                if (cleanUpThread != null) {
                    Runtime.getRuntime().removeShutdownHook(cleanUpThread);
                }
                return;
            }
            boolean deviceInit = false;
            if (RunMode.REGULAR.equals((Object)mode) || RunMode.SANDBOX.equals((Object)mode)) {
                CloseableTraceScope ignored;
                this.mStatus = "sharding";
                Integer n = config.getCommandOptions().getShardCount();
                Integer shardIndex = config.getCommandOptions().getShardIndex();
                boolean startInvocationCalled = false;
                if (n != null && shardIndex != null) {
                    try {
                        ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.pre_sharding_required_setup.name());
                        try {
                            deviceInit = true;
                            this.startInvocation(config, context, listener);
                            startInvocationCalled = true;
                            invocationPath.runDevicePreInvocationSetup(context, config, listener);
                        }
                        finally {
                            ignored.close();
                        }
                    }
                    catch (DeviceNotAvailableException | TargetSetupError e) {
                        LogUtil.CLog.e(e);
                        FailureDescription failure = FailureDescription.create(e.getMessage());
                        failure.setCause(e).setFailureStatus(TestRecordProto.FailureStatus.INFRA_FAILURE);
                        if (e instanceof DeviceNotAvailableException) {
                            this.setExitCode(CommandRunner.ExitCode.DEVICE_UNAVAILABLE, e);
                        } else {
                            this.setExitCode(CommandRunner.ExitCode.THROWABLE_EXCEPTION, e);
                        }
                        try {
                            invocationPath.runDevicePostInvocationTearDown(context, config, e);
                        }
                        finally {
                            this.reportFailure(TestInvocation.createFailureFromException(e, TestRecordProto.FailureStatus.INFRA_FAILURE), listener);
                            for (ITestDevice device : context.getDevices()) {
                                invocationPath.reportLogs(device, listener, Stage.ERROR);
                            }
                            this.reportHostLog(listener, config);
                            this.reportInvocationEnded(config, context, listener, 0L);
                        }
                        TfObjectTracker.clearTracking();
                        CurrentInvocation.clearInvocationInfos();
                        LogUtil.CLog.i("Cleaning up builds");
                        invocationPath.cleanUpBuilds(context, config);
                        if (!sharding) {
                            this.deleteInvocationFiles(info, config);
                        }
                        if (!config.getCommandOptions().reportInvocationComplete()) {
                            this.getLogRegistry().dumpToGlobalLog(config.getLogOutput());
                            this.getLogRegistry().unregisterLogger();
                            config.getLogOutput().closeLog();
                        }
                        config.cleanConfigurationData();
                        if (cleanUpThread != null) {
                            Runtime.getRuntime().removeShutdownHook(cleanUpThread);
                        }
                        return;
                    }
                }
                config.getGlobalFilters().setUpFilters(config, config.getSkipManager().getDemotedTests().keySet());
                try {
                    ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.sharding.name());
                    try {
                        sharding = invocationPath.shardConfig(config, info, rescheduler, listener);
                    }
                    finally {
                        ignored.close();
                    }
                }
                catch (RuntimeException unexpected) {
                    LogUtil.CLog.e("Exception during sharding.");
                    LogUtil.CLog.e(unexpected);
                    if (deviceInit) {
                        invocationPath.runDevicePostInvocationTearDown(context, config, unexpected);
                    }
                    if (!startInvocationCalled) {
                        this.startInvocation(config, context, listener);
                    }
                    this.reportFailure(TestInvocation.createFailureFromException(unexpected, TestRecordProto.FailureStatus.INFRA_FAILURE).setActionInProgress(ActionInProgress.TEST), listener);
                    this.reportHostLog(listener, config);
                    listener.invocationEnded(0L);
                    TfObjectTracker.clearTracking();
                    CurrentInvocation.clearInvocationInfos();
                    LogUtil.CLog.i("Cleaning up builds");
                    invocationPath.cleanUpBuilds(context, config);
                    if (!sharding) {
                        this.deleteInvocationFiles(info, config);
                    }
                    if (!config.getCommandOptions().reportInvocationComplete()) {
                        this.getLogRegistry().dumpToGlobalLog(config.getLogOutput());
                        this.getLogRegistry().unregisterLogger();
                        config.getLogOutput().closeLog();
                    }
                    config.cleanConfigurationData();
                    if (cleanUpThread != null) {
                        Runtime.getRuntime().removeShutdownHook(cleanUpThread);
                    }
                    return;
                }
                if (sharding) {
                    LogUtil.CLog.i("Invocation for %s has been sharded, rescheduling", context.getSerials());
                    this.reportHostLog(listener, config, "host_log_before_sharding");
                    this.logExpandedConfiguration(config, listener, mode, true);
                    config.getLogSaver().invocationEnded(0L);
                    if (aggregator != null) {
                        aggregator.forwardAggregatedInvocationLogs();
                        aggregator.cleanEventsFiles();
                    }
                    return;
                }
            }
            if (!deviceInit) {
                try (CloseableTraceScope closeableTraceScope = new CloseableTraceScope("startInvocation");){
                    this.startInvocation(config, context, listener);
                }
            }
            if (!RunMode.DELEGATED_INVOCATION.equals((Object)mode) && (config.getTests() == null || config.getTests().isEmpty())) {
                LogUtil.CLog.e("No tests to run");
                if (deviceInit) {
                    invocationPath.runDevicePostInvocationTearDown(context, config, null);
                }
                if (this.mEventsLogger != null) {
                    this.logEventsFile(this.mEventsLogger.getLoggedEvents(), listener);
                }
                listener.invocationEnded(0L);
                return;
            }
            this.performInvocation(config, info, invocationPath, listener, deviceInit);
            this.setExitCode(CommandRunner.ExitCode.NO_ERROR, null);
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        finally {
            TfObjectTracker.clearTracking();
            CurrentInvocation.clearInvocationInfos();
            LogUtil.CLog.i("Cleaning up builds");
            invocationPath.cleanUpBuilds(context, config);
            if (!sharding) {
                this.deleteInvocationFiles(info, config);
            }
            if (!config.getCommandOptions().reportInvocationComplete()) {
                this.getLogRegistry().dumpToGlobalLog(config.getLogOutput());
                this.getLogRegistry().unregisterLogger();
                config.getLogOutput().closeLog();
            }
            config.cleanConfigurationData();
            if (cleanUpThread != null) {
                Runtime.getRuntime().removeShutdownHook(cleanUpThread);
            }
        }
    }

    @VisibleForTesting
    public void registerExecutionFiles(ExecutionFiles executionFiles) {
        CurrentInvocation.registerExecutionFiles(executionFiles);
    }

    protected void setExitCode(CommandRunner.ExitCode code, Throwable stack) {
        this.mExitCode = code;
        this.mExitStack = stack;
    }

    protected void addInvocationMetric(InvocationMetricLogger.InvocationMetricKey key, long value) {
        InvocationMetricLogger.addInvocationMetrics(key, value);
    }

    protected void addInvocationMetric(InvocationMetricLogger.InvocationMetricKey key, String value) {
        InvocationMetricLogger.addInvocationMetrics(key, value);
    }

    public static String getDeviceLogName(Stage stage) {
        return DEVICE_LOG_NAME_PREFIX + stage.getName();
    }

    public static String getEmulatorLogName(Stage stage) {
        return EMULATOR_LOG_NAME_PREFIX + stage.getName();
    }

    @Override
    public void notifyInvocationForceStopped(String message2, ErrorIdentifier errorId) {
        this.mStopCause = message2;
        this.mStopErrorId = errorId;
        if (this.mStopRequestTime == null) {
            this.mStopRequestTime = System.currentTimeMillis();
            this.mForcedStopRequestedAfterTest = this.mTestDone;
            this.mShutdownBeforeTest = !this.mTestStarted;
        }
    }

    @Override
    public void notifyInvocationStopped(String message2) {
        if (this.mSoftStopRequestTime == null) {
            this.mSoftStopRequestTime = System.currentTimeMillis();
            this.mShutdownBeforeTest = !this.mTestStarted;
        }
    }

    public IInvocationExecution createInvocationExec(RunMode mode) {
        switch (mode) {
            case PARENT_SANDBOX: {
                return new ParentSandboxInvocationExecution();
            }
            case SANDBOX: {
                return new SandboxedInvocationExecution();
            }
            case REMOTE_INVOCATION: {
                this.mIsRemoteInvocation = true;
                return new RemoteInvocationExecution();
            }
            case DELEGATED_INVOCATION: {
                return new DelegatedInvocationExecution();
            }
        }
        return new InvocationExecution();
    }

    public static void printStageDelimiter(Stage phase, boolean end) {
        String startEnd = end ? "ENDING" : "STARTING";
        String message2 = String.format("===== %s PHASE %s =====", new Object[]{phase, startEnd});
        PrettyPrintDelimiter.printStageDelimiter(message2);
    }

    @VisibleForTesting
    protected void applyAutomatedReporters(IConfiguration config) {
        AutomatedReporters autoReport = new AutomatedReporters();
        autoReport.applyAutomatedReporters(config);
    }

    private void logExecuteShellCommand(List<ITestDevice> devices, ITestLogger logger) {
        for (ITestDevice device : devices) {
            File log;
            if (device.getIDevice() instanceof StubDevice || !(device instanceof NativeDevice) || (log = ((NativeDevice)device).getExecuteShellCommandLog()) == null || !log.exists()) continue;
            if (log.length() == 0L) {
                LogUtil.CLog.d("executeShellCommandLog file was empty, skip logging.");
                continue;
            }
            try (FileInputStreamSource source = new FileInputStreamSource(log);){
                logger.testLog(String.format("executeShellCommandLog_%s", device.getSerialNumber()), LogDataType.TEXT, source);
            }
        }
    }

    private void logEventsFile(File eventsLog, ITestLogger logger) {
        if (eventsLog != null && eventsLog.length() > 0L) {
            try (FileInputStreamSource source = new FileInputStreamSource(eventsLog, true);){
                logger.testLog("event-logs", LogDataType.TF_EVENTS, source);
            }
        }
        FileUtil.deleteFile(eventsLog);
    }

    private void updateInvocationContext(IInvocationContext context, IConfiguration config) {
        context.setTestTag(this.getTestTag(config));
        if (config.getCommandOptions().getInvocationData().containsKey("subprocess")) {
            return;
        }
        if (config.getCommandLine() != null) {
            context.addInvocationAttribute(COMMAND_ARGS_KEY, config.getCommandLine());
        }
        if (config.getCommandOptions().getShardCount() != null) {
            context.addInvocationAttribute("shard_count", config.getCommandOptions().getShardCount().toString());
        }
        if (config.getCommandOptions().getShardIndex() != null) {
            context.addInvocationAttribute("shard_index", config.getCommandOptions().getShardIndex().toString());
        }
        LinkedHashSet<ExternalDependency> externalDependencies = new LinkedHashSet<ExternalDependency>();
        for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
            for (Object obj : deviceConfig.getAllObjects()) {
                if (!(obj instanceof IExternalDependency)) continue;
                externalDependencies.addAll(((IExternalDependency)obj).getDependencies());
            }
        }
        if (!externalDependencies.isEmpty()) {
            List dependencyClassNames = externalDependencies.stream().map(dependency -> dependency.getClass().getName()).collect(Collectors.toList());
            context.addInvocationAttribute(INVOCATION_EXTERNAL_DEPENDENCIES, String.join((CharSequence)", ", dependencyClassNames));
        }
    }

    private String getTestTag(IConfiguration config) {
        String testTag = config.getCommandOptions().getTestTag();
        if (config.getCommandOptions().getTestTagSuffix() != null) {
            testTag = String.format("%s-%s", testTag, config.getCommandOptions().getTestTagSuffix());
        }
        return testTag;
    }

    private void deleteInvocationFiles(TestInformation testInfo, IConfiguration config) {
        LastShardDetector lastShardDetector;
        Object obj = config.getConfigurationObject("last_shard_detector");
        if (obj != null && !(lastShardDetector = (LastShardDetector)obj).isLastShardDone()) {
            return;
        }
        FileUtil.recursiveDelete(testInfo.dependenciesFolder());
        testInfo.executionFiles().clearFiles();
    }

    private Map<ITestDevice, FreeDeviceState> handleAndLogReleaseState(IInvocationContext context, Throwable exception, Throwable tearDownException) {
        if (exception == null && tearDownException != null) {
            exception = tearDownException;
        } else if (tearDownException instanceof DeviceNotAvailableException) {
            exception = tearDownException;
        }
        Map<ITestDevice, FreeDeviceState> devicesStates = CommandScheduler.createReleaseMap(context, exception);
        if (devicesStates.size() >= 1) {
            this.addInvocationMetric(InvocationMetricLogger.InvocationMetricKey.DEVICE_RELEASE_STATE, devicesStates.values().iterator().next().toString());
        }
        int countPhysicalLost = 0;
        int countVirtualLost = 0;
        for (Map.Entry<ITestDevice, FreeDeviceState> fds : devicesStates.entrySet()) {
            if (fds.getKey().getIDevice() instanceof TcpDevice && exception instanceof DeviceNotAvailableException) {
                ++countVirtualLost;
                continue;
            }
            if (fds.getKey().getIDevice() instanceof StubDevice || !FreeDeviceState.UNAVAILABLE.equals((Object)fds.getValue()) && !FreeDeviceState.UNRESPONSIVE.equals((Object)fds.getValue())) continue;
            if (fds.getKey() instanceof RemoteAndroidDevice || fds.getKey() instanceof NestedRemoteDevice) {
                ++countVirtualLost;
                continue;
            }
            ++countPhysicalLost;
        }
        if (countPhysicalLost > 0) {
            this.addInvocationMetric(InvocationMetricLogger.InvocationMetricKey.DEVICE_LOST_DETECTED, countPhysicalLost);
            if (GlobalConfiguration.getDeviceManagerInstance() instanceof DeviceManager) {
                String adbOutput = ((DeviceManager)GlobalConfiguration.getDeviceManagerInstance()).executeGlobalAdbCommand("devices");
                LogUtil.CLog.e("'adb devices' output:\n%s", adbOutput);
                CommandResult fastbootResult = this.getRunUtil().runTimedCmdSilently(60000L, GlobalConfiguration.getDeviceManagerInstance().getFastbootPath(), "devices");
                LogUtil.CLog.d("'fastboot devices' output:\n%s", fastbootResult.getStdout());
            }
        } else if (countVirtualLost > 0) {
            LogUtil.CLog.e("Counting as virtual_device_lost.");
            this.addInvocationMetric(InvocationMetricLogger.InvocationMetricKey.VIRTUAL_DEVICE_LOST_DETECTED, countVirtualLost);
        }
        return devicesStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportRecoveryLogs(List<ITestDevice> devices, ITestInvocationListener listener) {
        for (ITestDevice device : devices) {
            if (device == null || device.getIDevice() instanceof StubDevice || device.getDeviceState() != TestDeviceState.RECOVERY) continue;
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.ATTEMPT_RECOVERY_LOG_COUNT, 1L);
            ITestDevice.RecoveryMode mode = device.getRecoveryMode();
            try {
                device.setRecoveryMode(ITestDevice.RecoveryMode.NONE);
                String output = device.executeAdbCommand("root");
                LogUtil.CLog.d("adb recovery root output: %s", output);
                File recovery_log = device.pullFile(RECOVERY_LOG_DEVICE_PATH);
                if (recovery_log == null) {
                    return;
                }
                try (FileInputStreamSource fis = new FileInputStreamSource(recovery_log);){
                    listener.testLog(String.format("recovery_log_%s.txt", device.getSerialNumber()), LogDataType.RECOVERY_MODE_LOG, fis);
                }
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.i("Device unavailable, can't pull recovery.log");
            }
            finally {
                device.setRecoveryMode(mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportInvocationEnded(IConfiguration config, IInvocationContext context, ITestInvocationListener listener, long elapsedTime) {
        if (this.mIsRemoteInvocation || !TestInvocation.isSubprocess(config)) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.INVOCATION_END, System.currentTimeMillis());
        }
        ILeveledLogOutput endHostLog = config.getLogOutput();
        try {
            endHostLog.init();
            this.getLogRegistry().registerLogger(endHostLog);
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            endHostLog = null;
        }
        PrettyPrintDelimiter.printStageDelimiter("===== Result Reporters =====");
        try {
            ((InvocationContext)context).logInvocationMetrics();
            if (this.mEventsLogger != null) {
                this.logEventsFile(this.mEventsLogger.getLoggedEvents(), listener);
            }
            listener.invocationEnded(elapsedTime);
        }
        finally {
            InvocationMetricLogger.clearInvocationMetrics();
            if (endHostLog != null) {
                endHostLog.closeLog();
                this.getLogRegistry().unregisterLogger();
            }
        }
        if (!config.getCommandOptions().reportInvocationComplete()) {
            return;
        }
        if (config.getCommandOptions().getInvocationData().containsKey("subprocess")) {
            config.getCommandOptions().setReportInvocationComplete(false);
            return;
        }
        try {
            endHostLog.init();
            this.getLogRegistry().registerLogger(endHostLog);
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            config.getCommandOptions().setReportInvocationComplete(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceNotAvailableException bareMinimumResponsiveness(List<ITestDevice> devices) {
        for (ITestDevice device : devices) {
            if (device == null || device.getIDevice() instanceof StubDevice) continue;
            if (device.isStateBootloaderOrFastbootd()) {
                return null;
            }
            if (TestDeviceState.RECOVERY.equals((Object)device.getDeviceState())) {
                return null;
            }
            ITestDevice.RecoveryMode current = device.getRecoveryMode();
            device.setRecoveryMode(ITestDevice.RecoveryMode.NONE);
            LogUtil.CLog.d("Testing minimum responsiveness.");
            try {
                if (device instanceof NativeDevice) {
                    ((NativeDevice)device).invalidatePropertyCache();
                }
                device.waitForDeviceOnline(60000L);
                device.getApiLevel();
            }
            catch (DeviceNotAvailableException e) {
                DeviceNotAvailableException deviceNotAvailableException = e;
                return deviceNotAvailableException;
            }
            finally {
                device.setRecoveryMode(current);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceNotAvailableException checkDevicesAvailable(List<ITestDevice> devices, ITestInvocationListener listener) {
        DeviceNotAvailableException dnae = null;
        for (ITestDevice device : devices) {
            if (device == null || device.getIDevice() instanceof StubDevice) continue;
            if (device.isStateBootloaderOrFastbootd()) {
                dnae = new DeviceNotAvailableException("Device was left in fastboot state after tests", device.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
                this.reportFailure(TestInvocation.createFailureFromException(dnae, TestRecordProto.FailureStatus.INFRA_FAILURE), listener);
                continue;
            }
            if (TestDeviceState.RECOVERY.equals((Object)device.getDeviceState())) {
                dnae = new DeviceNotAvailableException("Device was left in recovery state after tests", device.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
                this.reportFailure(TestInvocation.createFailureFromException(dnae, TestRecordProto.FailureStatus.INFRA_FAILURE), listener);
                continue;
            }
            ITestDevice.RecoveryMode current = device.getRecoveryMode();
            device.setRecoveryMode(ITestDevice.RecoveryMode.NONE);
            try {
                boolean available = device.waitForDeviceAvailable(180000L);
                if (available) continue;
                throw new DeviceNotAvailableException(String.format("Device %s failed availability check after running tests.", device.getSerialNumber()), device.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
            }
            catch (DeviceNotAvailableException e) {
                String msg = String.format("Device was left offline after tests: %s", e.getMessage());
                DeviceNotAvailableException wrap = new DeviceNotAvailableException(msg, (Throwable)e, e.getSerial(), e.getErrorId());
                this.reportFailure(TestInvocation.createFailureFromException(wrap, TestRecordProto.FailureStatus.INFRA_FAILURE), listener);
                dnae = e;
            }
            finally {
                device.setRecoveryMode(current);
            }
        }
        return dnae;
    }

    public static IBuildInfo backFillBuildInfoForReporting(String commandLine) {
        IBuildInfo info = new BuildInfo();
        CommandLineBuildInfoBuilder builder = new CommandLineBuildInfoBuilder();
        try {
            ArrayList<String> command = new ArrayList<String>(Arrays.asList(QuotationAwareTokenizer.tokenizeLine(commandLine, false)));
            command.remove(0);
            ArgsOptionParser parser = new ArgsOptionParser(builder);
            parser.parseBestEffort(command, true);
            info = builder.createBuild();
        }
        catch (ConfigurationException ignore) {
            LogUtil.CLog.e(ignore);
        }
        return info;
    }

    private Long measureWorkFolderSize(IConfiguration config, TestInformation testInfo) {
        LastShardDetector lastShardDetector;
        if (testInfo == null) {
            return null;
        }
        File workFolder = testInfo.dependenciesFolder();
        LogUtil.CLog.d("Measuring size of %s", workFolder);
        if (workFolder == null || !workFolder.exists()) {
            return null;
        }
        if (TestInvocation.isSubprocess(config)) {
            LogUtil.CLog.d("Skip measuring size since we are in subprocess");
            return null;
        }
        Object obj = config.getConfigurationObject("last_shard_detector");
        if (obj != null && !(lastShardDetector = (LastShardDetector)obj).isLastShardDone()) {
            return null;
        }
        return FileUtil.sizeOfDirectory(workFolder);
    }

    @Override
    public ITestInvocation.ExitInformation getExitInfo() {
        ITestInvocation.ExitInformation info = new ITestInvocation.ExitInformation();
        info.mExitCode = this.mExitCode;
        info.mStack = this.mExitStack;
        return info;
    }

    @Override
    public void setClearcutClient(ClearcutClient client) {
        this.mClient = client;
    }

    public static boolean isSubprocess(IConfiguration config) {
        if (System.getenv("DELEGATED_MODE") != null) {
            return true;
        }
        return config.getCommandOptions().getInvocationData().containsKey("subprocess");
    }

    public static boolean shouldSkipBugreportError(@Nullable Throwable t) {
        if (t == null) {
            return false;
        }
        if (!(t instanceof HarnessException)) {
            return false;
        }
        HarnessException e = (HarnessException)t;
        if (e.getErrorId() == null) {
            return false;
        }
        long errorId = e.getErrorId().code();
        if (errorId >= 505250L && errorId < 505300L) {
            return true;
        }
        if (errorId >= 500501L && errorId < 501000L) {
            return true;
        }
        return errorId == 500501L || errorId == 500003L || errorId == 500008L || errorId == 500009L || errorId == 500010L || errorId == 500013L || errorId == 500014L || errorId == 500017L;
    }

    private /* synthetic */ Boolean lambda$performInvocation$0(ITestDevice device, ITestInvocationListener listener, IConfiguration config, String reportName) throws Exception {
        LogUtil.CLog.d("Start taking bugreport on '%s'", device.getSerialNumber());
        this.takeBugreport(device, listener, config.getCommandOptions(), reportName);
        return true;
    }

    private class ReportHostLog
    extends Thread {
        private ITestInvocationListener mListener;
        private IConfiguration mConfiguration;

        public ReportHostLog(ITestInvocationListener listener, IConfiguration config) {
            this.mListener = listener;
            this.mConfiguration = config;
        }

        @Override
        public void run() {
            TestInvocation.this.reportHostLog(this.mListener, this.mConfiguration);
        }
    }

    public static enum Stage {
        ERROR("error"),
        SETUP("setup"),
        TEST("test"),
        TEARDOWN("teardown");

        private final String mName;

        private Stage(String name) {
            this.mName = name;
        }

        public String getName() {
            return this.mName;
        }
    }

    public static enum RunMode {
        REGULAR,
        PARENT_SANDBOX,
        SANDBOX,
        REMOTE_INVOCATION,
        DELEGATED_INVOCATION;

    }

    private class CleanUpInvocationFiles
    extends Thread {
        private TestInformation mTestInfo;
        private IConfiguration mConfig;

        public CleanUpInvocationFiles(TestInformation currentInfo, IConfiguration config) {
            this.mTestInfo = currentInfo;
            this.mConfig = config;
        }

        @Override
        public void run() {
            TestInvocation.this.deleteInvocationFiles(this.mTestInfo, this.mConfig);
        }
    }
}

