/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.logger;

import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationLocal;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ActionInProgress;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.error.ErrorIdentifier;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class CurrentInvocation {
    private static final Map<ThreadGroup, InternalInvocationTracking> mPerGroupInfo = new ConcurrentHashMap<ThreadGroup, InternalInvocationTracking>();
    private static final Map<ThreadGroup, Map<InvocationLocal<?>, Optional<?>>> mInvocationLocals = new ConcurrentHashMap();

    private CurrentInvocation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInvocationInfo(InvocationInfo key, File value) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                mPerGroupInfo.put(group, new InternalInvocationTracking());
            }
            CurrentInvocation.mPerGroupInfo.get((Object)group).mInvocationInfoFiles.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getInfo(InvocationInfo key) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                mPerGroupInfo.put(group, new InternalInvocationTracking());
            }
            return CurrentInvocation.mPerGroupInfo.get((Object)group).mInvocationInfoFiles.get((Object)key);
        }
    }

    public static File getWorkFolder() {
        File workfolder = CurrentInvocation.getInfo(InvocationInfo.WORK_FOLDER);
        if (workfolder == null || !workfolder.exists()) {
            return null;
        }
        return workfolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInvocationInfos() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            mPerGroupInfo.remove(group);
        }
        mInvocationLocals.remove(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExecutionFiles(ExecutionFiles invocFiles) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                mPerGroupInfo.put(group, new InternalInvocationTracking());
            }
            if (CurrentInvocation.mPerGroupInfo.get((Object)group).mExecutionFiles == null) {
                CurrentInvocation.mPerGroupInfo.get((Object)group).mExecutionFiles = invocFiles;
            } else {
                LogUtil.CLog.w("CurrentInvocation#registerExecutionFiles should only be called once per invocation.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionFiles getInvocationFiles() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                mPerGroupInfo.put(group, new InternalInvocationTracking());
            }
            return CurrentInvocation.mPerGroupInfo.get((Object)group).mExecutionFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActionInProgress(ActionInProgress action) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                mPerGroupInfo.put(group, new InternalInvocationTracking());
            }
            CurrentInvocation.mPerGroupInfo.get((Object)group).mActionInProgress = action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ActionInProgress getActionInProgress() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                return null;
            }
            return CurrentInvocation.mPerGroupInfo.get((Object)group).mActionInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInvocationContext(IInvocationContext context) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                mPerGroupInfo.put(group, new InternalInvocationTracking());
            }
            CurrentInvocation.mPerGroupInfo.get((Object)group).mContext = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IInvocationContext getInvocationContext() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                return null;
            }
            return CurrentInvocation.mPerGroupInfo.get((Object)group).mContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IsolationGrade moduleCurrentIsolation() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                return IsolationGrade.NOT_ISOLATED;
            }
            return CurrentInvocation.mPerGroupInfo.get((Object)group).mIsModuleIsolated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setModuleIsolation(IsolationGrade isolation) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                mPerGroupInfo.put(group, new InternalInvocationTracking());
            }
            CurrentInvocation.mPerGroupInfo.get((Object)group).mIsModuleIsolated = isolation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IsolationGrade runCurrentIsolation() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                return IsolationGrade.NOT_ISOLATED;
            }
            return CurrentInvocation.mPerGroupInfo.get((Object)group).mIsRunIsolated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRunIsolation(IsolationGrade isolation) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, InternalInvocationTracking> map = mPerGroupInfo;
        synchronized (map) {
            if (mPerGroupInfo.get(group) == null) {
                mPerGroupInfo.put(group, new InternalInvocationTracking());
            }
            CurrentInvocation.mPerGroupInfo.get((Object)group).mIsRunIsolated = isolation;
        }
    }

    public static FailureDescription createFailure(String errorMessage, ErrorIdentifier errorIdentifier) {
        FailureDescription failure = FailureDescription.create(errorMessage);
        ActionInProgress action = CurrentInvocation.getActionInProgress();
        if (action != null) {
            failure.setActionInProgress(action);
        }
        if (errorIdentifier != null) {
            failure.setErrorIdentifier(errorIdentifier);
            failure.setFailureStatus(errorIdentifier.status());
        }
        Class<?> clazz = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        failure.setOrigin(clazz.getCanonicalName());
        return failure;
    }

    static <T> T getLocal(InvocationLocal<T> local) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map locals = mInvocationLocals.computeIfAbsent(group, unused -> new ConcurrentHashMap());
        Optional holder = locals.computeIfAbsent(local, unused -> Optional.ofNullable(local.initialValue()));
        T value = holder.orElse(null);
        return value;
    }

    private static class InternalInvocationTracking {
        public Map<InvocationInfo, File> mInvocationInfoFiles = new HashMap<InvocationInfo, File>();
        public ExecutionFiles mExecutionFiles;
        public ActionInProgress mActionInProgress = ActionInProgress.UNSET;
        public IsolationGrade mIsModuleIsolated = IsolationGrade.FULLY_ISOLATED;
        public IsolationGrade mIsRunIsolated = IsolationGrade.FULLY_ISOLATED;
        public IInvocationContext mContext;

        private InternalInvocationTracking() {
        }
    }

    public static enum InvocationInfo {
        WORK_FOLDER("work_folder");

        private final String mKeyName;

        private InvocationInfo(String key) {
            this.mKeyName = key;
        }

        public String toString() {
            return this.mKeyName;
        }
    }

    public static enum IsolationGrade {
        NOT_ISOLATED,
        REBOOT_ISOLATED,
        FULLY_ISOLATED;

    }
}

