/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.logger;

import com.android.tradefed.log.LogUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InvocationMetricLogger {
    private static ThreadLocal<ThreadGroup> sLocal = new ThreadLocal();
    private static final Map<ThreadGroup, Map<String, String>> mPerGroupMetrics = Collections.synchronizedMap(new HashMap());

    private InvocationMetricLogger() {
    }

    public static void setLocalGroup(ThreadGroup tg) {
        sLocal.set(tg);
    }

    public static void resetLocalGroup() {
        sLocal.remove();
    }

    public static void addInvocationMetrics(InvocationMetricKey key, long value) {
        if (key.shouldAdd()) {
            String existingVal = InvocationMetricLogger.getInvocationMetrics().get(key.toString());
            long existingLong = 0L;
            if (existingVal != null) {
                try {
                    existingLong = Long.parseLong(existingVal);
                }
                catch (NumberFormatException e) {
                    LogUtil.CLog.e("%s is expected to contain a number, instead found: %s", key.toString(), existingVal);
                }
            }
            value += existingLong;
        }
        InvocationMetricLogger.addInvocationMetrics(key.toString(), Long.toString(value));
    }

    public static void addInvocationMetrics(InvocationGroupMetricKey groupKey, String group, String value) {
        String existingVal;
        String key = groupKey.toString() + ":" + group;
        if (groupKey.shouldAdd() && (existingVal = InvocationMetricLogger.getInvocationMetrics().get(key.toString())) != null) {
            value = String.format("%s,%s", existingVal, value);
        }
        InvocationMetricLogger.addInvocationMetrics(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInvocationMetrics(String key, String value) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, Map<String, String>> map = mPerGroupMetrics;
        synchronized (map) {
            if (sLocal.get() != null) {
                group = sLocal.get();
            }
            if (mPerGroupMetrics.get(group) == null) {
                mPerGroupMetrics.put(group, new HashMap());
            }
            mPerGroupMetrics.get(group).put(key, value);
        }
    }

    public static void addInvocationMetrics(InvocationGroupMetricKey groupKey, String group, long value) {
        String key = groupKey.toString() + ":" + group;
        if (groupKey.shouldAdd()) {
            String existingVal = InvocationMetricLogger.getInvocationMetrics().get(key);
            long existingLong = 0L;
            if (existingVal != null) {
                try {
                    existingLong = Long.parseLong(existingVal);
                }
                catch (NumberFormatException e) {
                    LogUtil.CLog.e("%s is expected to contain a number, instead found: %s", key.toString(), existingVal);
                }
            }
            value += existingLong;
        }
        InvocationMetricLogger.addInvocationMetrics(key, Long.toString(value));
    }

    public static void addInvocationMetrics(InvocationMetricKey key, String value) {
        String existingVal;
        if (key.shouldAdd() && (existingVal = InvocationMetricLogger.getInvocationMetrics().get(key.toString())) != null) {
            value = String.format("%s,%s", existingVal, value);
        }
        InvocationMetricLogger.addInvocationMetrics(key.toString(), value);
    }

    public static void addInvocationPairMetrics(InvocationMetricKey key, long start, long end) {
        String existingVal;
        String value = start + ":" + end;
        if (key.shouldAdd() && (existingVal = InvocationMetricLogger.getInvocationMetrics().get(key.toString())) != null) {
            value = String.format("%s,%s", existingVal, value);
        }
        InvocationMetricLogger.addInvocationMetrics(key.toString(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getInvocationMetrics() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, Map<String, String>> map = mPerGroupMetrics;
        synchronized (map) {
            if (sLocal.get() != null) {
                group = sLocal.get();
            }
            if (mPerGroupMetrics.get(group) == null) {
                mPerGroupMetrics.put(group, new HashMap());
            }
            return new HashMap<String, String>(mPerGroupMetrics.get(group));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInvocationMetrics() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, Map<String, String>> map = mPerGroupMetrics;
        synchronized (map) {
            mPerGroupMetrics.remove(group);
        }
    }

    public static enum InvocationMetricKey {
        WIFI_AP_NAME("wifi_ap_name", false),
        WIFI_CONNECT_TIME("wifi_connect_time", true),
        WIFI_CONNECT_COUNT("wifi_connect_count", true),
        WIFI_CONNECT_RETRY_COUNT("wifi_connect_retry_count", true),
        BUGREPORT_TIME("bugreport_time", true),
        BUGREPORT_COUNT("bugreport_count", true),
        ANR_TIME("anr_time", true),
        ANR_COUNT("anr_count", true),
        LOGCAT_DUMP_TIME("logcat_dump_time", true),
        LOGCAT_DUMP_COUNT("logcat_dump_count", true),
        CLEARED_RUN_ERROR("cleared_run_error", true),
        FETCH_BUILD("fetch_build_time_ms", true),
        SETUP("setup_time_ms", true),
        SHARDING_DEVICE_SETUP_TIME("remote_device_sharding_setup_ms", true),
        AUTO_RETRY_TIME("auto_retry_time_ms", true),
        BACKFILL_BUILD_INFO("backfill_build_info", false),
        STAGE_TESTS_TIME("stage_tests_time_ms", true),
        STAGE_REMOTE_TIME("stage_remote_time_ms", true),
        STAGE_TESTS_BYTES("stage_tests_bytes", true),
        STAGE_TESTS_INDIVIDUAL_DOWNLOADS("stage_tests_individual_downloads", true),
        STAGE_UNDEFINED_DEPENDENCY("stage_undefined_dependency", true),
        SERVER_REFERENCE("server_reference", false),
        INSTRUMENTATION_RERUN_FROM_FILE("instrumentation_rerun_from_file", true),
        INSTRUMENTATION_RERUN_SERIAL("instrumentation_rerun_serial", true),
        DOWNLOAD_RETRY_COUNT("download_retry_count", true),
        METADATA_RETRY_COUNT("metadata_retry_count", true),
        XTS_STAGE_TESTS_TIME("xts_stage_tests_time_ms", true),
        XTS_STAGE_TESTS_BYTES("xts_stage_tests_bytes", true),
        XTS_PARTIAL_DOWNLOAD_SUCCESS_COUNT("xts_partial_download_success_count", true),
        XTS_PARTIAL_DOWNLOAD_UNSUPPORTED_FILTER_FALLBACK_COUNT("xts_partial_download_unsupported_filter_fallback_count", true),
        XTS_PARTIAL_DOWNLOAD_FALLBACK_COUNT("xts_partial_download_fallback_count", true),
        XTS_PARTIAL_DOWNLOAD_UNFOUND_MODULES("xts_partial_download_unfound_modules", true),
        XTS_PARTIAL_DOWNLOAD_TOTAL_COUNT("xts_partial_download_total_count", true),
        SANDBOX_JAR_STAGING_PARTIAL_DOWNLOAD_FEATURE_COUNT("sandbox_jar_staging_partial_download_FEATURE_count", true),
        SANDBOX_JAR_STAGING_PARTIAL_DOWNLOAD_SUCCESS_COUNT("sandbox_jar_staging_partial_download_SUCCESS_count", true),
        TEST_DISCOVERY_MODULE_COUNT("test_discovery_module_count", true),
        TEAR_DOWN_DISK_USAGE("teardown_disk_usage_bytes", false),
        AUTO_RECOVERY_MODE_COUNT("recovery_mode_count", true),
        ATTEMPT_RECOVERY_LOG_COUNT("attempt_pull_recovery_log", true),
        RECOVERY_TIME("recovery_time", true),
        RECOVERY_ROUTINE_COUNT("recovery_routine_count", true),
        ADB_ROOT_TIME("adb_root_time", true),
        ADB_ROOT_ROUTINE_COUNT("adb_root_routine_count", true),
        ADB_REBOOT_TIME("adb_reboot_time", true),
        ADB_REBOOT_ROUTINE_COUNT("adb_reboot_routine_count", true),
        BOOTLOADER_REBOOT_TIME("bootloader_reboot_time", true),
        BOOTLOADER_REBOOT_COUNT("bootloader_reboot_count", true),
        FASTBOOTD_REBOOT_TIME("fastbootd_reboot_time", true),
        FASTBOOTD_REBOOT_COUNT("fastbootd_reboot_count", true),
        BOOTLOADER_SAME_STATE_REBOOT("bootloader_same_state_reboot", true),
        POSTBOOT_SETUP_TIME("postboot_setup_time", true),
        POSTBOOT_SETUP_COUNT("postboot_setup_count", true),
        POSTBOOT_WIFI_SETUP_TIME("postboot_wifi_setup_time", true),
        POSTBOOT_WIFI_SETUP_COUNT("postboot_wifi_setup_count", true),
        MD5_CALCULATION_TIME("md5_calculation_time", true),
        MD5_CALCULATION_COUNT("md5_calculation_count", true),
        PULL_FILE_TIME("pull_file_time_ms", true),
        PULL_FILE_COUNT("pull_file_count", true),
        PULL_DIR_TIME("pull_dir_time_ms", true),
        PULL_DIR_COUNT("pull_dir_count", true),
        PUSH_FILE_TIME("push_file_time_ms", true),
        PUSH_FILE_COUNT("push_file_count", true),
        PUSH_DIR_TIME("push_dir_time_ms", true),
        PUSH_DIR_COUNT("push_dir_count", true),
        DELETE_DEVICE_FILE_TIME("delete_device_file_time_ms", true),
        DELETE_DEVICE_FILE_COUNT("delete_device_file_count", true),
        DOES_FILE_EXISTS_TIME("does_file_exists_time_ms", true),
        DOES_FILE_EXISTS_COUNT("does_file_exists_count", true),
        PACKAGE_INSTALL_TIME("package_install_time_ms", true),
        PACKAGE_INSTALL_COUNT("package_install_count", true),
        RESET_RETRY_ISOLATION_PAIR("reset_isolation_timestamp_pair", true),
        REBOOT_RETRY_ISOLATION_PAIR("reboot_isolation_timestamp_pair", true),
        RETRY_MODULE_SKIPPED_COUNT("retry_module_skipped_count", true),
        RETRY_TEST_SKIPPED_COUNT("retry_test_skipped_count", true),
        RETRY_SKIPPED_ALL_FILTERED_COUNT("retry_skipped_all_filtered_count", true),
        COLLECTOR_TIME("collector_time_ms", true),
        SOFT_RESTART_AFTER_MODULE("soft_restart_after_module", true),
        CLOUD_DEVICE_PROJECT("cloud_device_project", false),
        CLOUD_DEVICE_MACHINE_TYPE("cloud_device_machine_type", false),
        CLOUD_DEVICE_ZONE("cloud_device_zone", false),
        CLOUD_DEVICE_STABLE_HOST_IMAGE("stable_host_image_name", false),
        CLOUD_DEVICE_STABLE_HOST_IMAGE_PROJECT("stable_host_image_project", false),
        SHUTDOWN_BEFORE_TEST("shutdown_before_test", false),
        SHUTDOWN_AFTER_TEST("shutdown_after_test", false),
        SHUTDOWN_LATENCY("shutdown_latency_ms", false),
        SHUTDOWN_HARD_LATENCY("shutdown_hard_latency_ms", false),
        DEVICE_COUNT("device_count", false),
        DEVICE_DONE_TIMESTAMP("device_done_timestamp", false),
        DEVICE_RELEASE_STATE("device_release_state", false),
        DEVICE_LOST_DETECTED("device_lost_detected", false),
        VIRTUAL_DEVICE_LOST_DETECTED("virtual_device_lost_detected", false),
        DEVICE_RECOVERY("device_recovery", true),
        DEVICE_RECOVERY_FROM_RECOVERY("device_recovery_from_recovery", true),
        DEVICE_RECOVERED_FROM_SSH_TUNNEL("device_recovered_from_ssh_tunnel", true),
        DEVICE_RECOVERED_FROM_DEVICE_RESET("device_recovered_from_device_reset", true),
        DEVICE_RECOVERY_FAIL("device_recovery_fail", true),
        SANDBOX_EXIT_CODE("sandbox_exit_code", false),
        CF_FETCH_ARTIFACT_TIME("cf_fetch_artifact_time_ms", false),
        CF_GCE_CREATE_TIME("cf_gce_create_time_ms", false),
        CF_LAUNCH_CVD_TIME("cf_launch_cvd_time_ms", false),
        CF_INSTANCE_COUNT("cf_instance_count", false),
        CF_LOG_SIZE("cf_log_size_bytes", true),
        CF_OXYGEN_SERVER_URL("cf_oxygen_server_url", false),
        CF_OXYGEN_SESSION_ID("cf_oxygen_session_id", false),
        CF_OXYGEN_VERSION("cf_oxygen_version", false),
        CRASH_FAILURES("crash_failures", true),
        UNCAUGHT_CRASH_FAILURES("uncaught_crash_failures", true),
        TEST_CRASH_FAILURES("test_crash_failures", true),
        UNCAUGHT_TEST_CRASH_FAILURES("uncaught_test_crash_failures", true),
        DEVICE_RESET_COUNT("device_reset_count", true),
        DEVICE_RESET_MODULES("device_reset_modules", true),
        DEVICE_POWERWASH_DURATIONS("device_powerwash_durations", true),
        DEVICE_RESET_MODULES_FOR_TARGET_PREPARER("device_reset_modules_for_target_preparer", true),
        DEVICE_SNAPSHOT_SUCCESS_COUNT("device_snapshot_success_count", true),
        DEVICE_SNAPSHOT_FAILURE_COUNT("device_snapshot_failure_count", true),
        DEVICE_SNAPSHOT_DURATIONS("device_snapshot_durations", true),
        DEVICE_SNAPSHOT_RESTORE_SUCCESS_COUNT("device_snapshot_restore_success_count", true),
        DEVICE_SNAPSHOT_RESTORE_FAILURE_COUNT("device_snapshot_restore_failure_count", true),
        DEVICE_SNAPSHOT_RESTORE_DURATIONS("device_snapshot_restore_durations", true),
        DEVICE_SUSPEND_SUCCESS_COUNT("device_suspend_success_count", true),
        DEVICE_SUSPEND_FAILURE_COUNT("device_suspend_failure_count", true),
        DEVICE_SUSPEND_DURATIONS("device_suspend_durations", true),
        DEVICE_RESUME_SUCCESS_COUNT("device_resume_success_count", true),
        DEVICE_RESUME_FAILURE_COUNT("device_resume_failure_count", true),
        DEVICE_RESUME_DURATIONS("device_resume_durations", true),
        DEVICE_STOP_SUCCESS_COUNT("device_stop_success_count", true),
        DEVICE_STOP_FAILURE_COUNT("device_stop_failure_count", true),
        DEVICE_STOP_DURATIONS("device_stop_durations", true),
        NONPERSISTENT_DEVICE_PROPERTIES("nonpersistent_device_properties", true),
        PERSISTENT_DEVICE_PROPERTIES("persistent_device_properties", true),
        INVOCATION_START("tf_invocation_start_timestamp", false),
        LOAD_TEST_CONFIGS_TIME("load_test_configs_time_ms", true),
        OXYGEN_DEVICE_DIRECT_LEASE_COUNT("oxygen_device_direct_lease_count", true),
        OXYGEN_DEVICE_DIRECT_RELEASE_COUNT("oxygen_device_direct_release_count", true),
        OXYGEN_DEVICE_RELEASE_FAILURE_COUNT("oxygen_device_release_failure_count", true),
        OXYGEN_DEVICE_RELEASE_FAILURE_MESSAGE("oxygen_device_release_failure_message", true),
        DYNAMIC_FILE_RESOLVER_PAIR("tf_dynamic_resolver_pair_timestamp", true),
        ARTIFACTS_DOWNLOAD_SIZE("tf_artifacts_download_size_bytes", true),
        ARTIFACTS_UPLOAD_SIZE("tf_artifacts_upload_size_bytes", true),
        LOG_SAVING_TIME("log_saving_time", true),
        LOG_SAVING_COUNT("log_saving_count", true),
        FETCH_BUILD_START("tf_fetch_build_start_timestamp", false),
        FETCH_BUILD_END("tf_fetch_build_end_timestamp", false),
        FETCH_BUILD_PAIR("tf_fetch_build_pair_timestamp", true),
        SETUP_START("tf_setup_start_timestamp", false),
        SETUP_END("tf_setup_end_timestamp", false),
        SETUP_PAIR("tf_setup_pair_timestamp", true),
        TEST_SETUP_PAIR("tf_test_setup_pair_timestamp", true),
        FLASHING_FROM_FASTBOOTD("flashing_from_fastbootd", true),
        FLASHING_TIME("flashing_time_ms", true),
        FLASHING_PERMIT_LATENCY("flashing_permit_latency_ms", true),
        FLASHING_METHOD("flashing_method", false),
        DOWNLOAD_PERMIT_LATENCY("download_permit_latency_ms", true),
        UNZIP_TESTS_DIR_TIME("unzip_tests_dir_time_ms", true),
        UNZIP_TESTS_DIR_COUNT("unzip_tests_dir_count", true),
        TEST_PAIR("tf_test_pair_timestamp", false),
        TEARDOWN_START("tf_teardown_start_timestamp", false),
        TEARDOWN_END("tf_teardown_end_timestamp", false),
        TEARDOWN_PAIR("tf_teardown_pair_timestamp", true),
        TEST_TEARDOWN_PAIR("tf_test_teardown_pair_timestamp", true),
        INVOCATION_END("tf_invocation_end_timestamp", false),
        MODULE_SETUP_PAIR("tf_module_setup_pair_timestamp", true),
        MODULE_TEARDOWN_PAIR("tf_module_teardown_pair_timestamp", true),
        STATUS_CHECKER_PAIR("status_checker_pair", true),
        LAB_PREPARER_NOT_ILAB("lab_preparer_not_ilab", true),
        TARGET_PREPARER_IS_ILAB("target_preparer_is_ilab", true),
        ART_RUN_TEST_CHECKER_COMMAND_TIME_MS("art_run_test_checker_command_time_ms", true),
        CAS_DOWNLOAD_FILES("cas_download_files", true),
        CAS_DOWNLOAD_FILE_SUCCESS_COUNT("cas_download_file_success_count", true),
        CAS_DOWNLOAD_FILE_FAIL_COUNT("cas_download_file_fail_count", true),
        CAS_DOWNLOAD_TIME("cas_download_time_ms", true),
        CAS_DOWNLOAD_WAIT_TIME("cas_download_wait_time_ms", true),
        CAS_LOCK_TIMEOUTS("cas_lock_timeout", true),
        CAS_CACHE_FALLBACK_COUNT("cas_cache_fallback_count", true),
        CAS_TIMEOUT_COUNT("cas_timeout_count", true),
        CAS_DOWNLOAD_HOT_BYTES("cas_download_hot_bytes", true),
        CAS_DOWNLOAD_COLD_BYTES("cas_download_cold_bytes", true),
        CAS_DOWNLOAD_HOT_FILES_COUNT("cas_download_hot_files_count", true),
        CAS_DOWNLOAD_COLD_FILES_COUNT("cas_download_cold_files_count", true),
        CACHE_HIT_COUNT("cache_hit_count", true),
        CACHE_WAIT_FOR_LOCK("cache_wait_for_lock", true),
        CF_CACHE_WAIT_TIME("cf_cache_wait_time_sec", false),
        CF_ARTIFACTS_FETCH_SOURCE("cf_artifacts_fetch_source", false),
        AB_DOWNLOAD_SIZE_ELAPSED_TIME("ab_download_size_elapsed_time", true),
        ZIP_PARTIAL_DOWNLOAD_CACHE_HIT("zip_partial_download_cache_hit", true),
        DOWNLOAD_BOTH_ZIPS_AND_TS("download_both_zips_and_ts", true),
        DUPLICATE_MAPPING_DIFFERENT_OPTIONS("duplicate_mapping_different_options", true),
        HAS_ANY_RUN_FAILURES("has_any_run_failures", false),
        TOTAL_TEST_COUNT("total_test_count", true),
        DEVICE_ERROR_SIGNATURES("device_failure_signatures", false),
        DEVICE_IMAGE_NOT_CHANGED("device_image_not_changed", false),
        TEST_ARTIFACT_NOT_CHANGED("test_artifact_not_changed", true),
        POWERWASH_TIME("powerwash_time_ms", true),
        POWERWASH_SUCCESS_COUNT("powerwash_success_count", true),
        POWERWASH_FAILURE_COUNT("powerwash_failure_count", true),
        LEASE_RETRY_COUNT_SUCCESS("lease_retry_count_success", true),
        LEASE_RETRY_COUNT_FAILURE("lease_retry_count_failure", true),
        TRACE_INTERNAL_ERROR("trace_internal_error", true),
        INCREMENTAL_FLASHING_TIME("incremental_flashing_time", true),
        INCREMENTAL_FLASHING_ATTEMPT_COUNT("incremental_flashing_attempt_count", true),
        INCREMENTAL_FLASHING_TEARDOWN_FAILURE("incremental_flashing_teardown_failure", true),
        INCREMENTAL_FLASHING_UPDATE_FAILURE("incremental_flashing_update_failure", true),
        DEVICE_IMAGE_CACHE_MISMATCH("device_image_cache_mismatch", true),
        DEVICE_IMAGE_CACHE_ORIGIN("device_image_cache_origin", true),
        SILENT_INVOCATION_SKIP_COUNT("silent_invocation_skip_count", true),
        DEMOTION_FILTERS_RECEIVED_COUNT("demotion_filters_received_count", true),
        invocation_warm_up("invocation_warm_up", true),
        dynamic_download("dynamic_download", true),
        fetch_artifact("fetch_artifact", true),
        start_logcat("start_logcat", true),
        pre_sharding_required_setup("pre_sharding_required_setup", true),
        sharding("sharding", true),
        pre_multi_preparer("pre_multi_preparer", true),
        lab_setup("lab_setup", true),
        test_setup("test_setup", true),
        test_execution("test_execution", true),
        check_device_availability("check_device_availability", true),
        bugreport("bugreport", true),
        host_sleep("host_sleep", true),
        test_teardown("test_teardown", true),
        test_cleanup("test_cleanup", true),
        log_and_release_device("log_and_release_device", true),
        invocation_events_processing("invocation_events_processing", true),
        stage_suite_test_artifacts("stage_suite_test_artifacts", true),
        wait_for_results_update("wait_for_results_update", true),
        instru_collect_tests("instru_collect_tests", true),
        CACHED_MODULE_RESULTS_COUNT("cached_module_results_count", true);

        private final String mKeyName;
        private final boolean mAdditive;

        private InvocationMetricKey(String key, boolean additive) {
            this.mKeyName = key;
            this.mAdditive = additive;
        }

        public String toString() {
            return this.mKeyName;
        }

        public boolean shouldAdd() {
            return this.mAdditive;
        }
    }

    public static enum InvocationGroupMetricKey {
        TEST_TYPE_COUNT("test-type-count", true),
        TARGET_PREPARER_SETUP_LATENCY("target-preparer-setup-latency", true),
        TARGET_PREPARER_TEARDOWN_LATENCY("target-preparer-teardown-latency", true),
        LAB_PREPARER_SETUP_LATENCY("lab-preparer-setup-latency", true),
        LAB_PREPARER_TEARDOWN_LATENCY("lab-preparer-teardown-latency", true),
        MULTI_TARGET_PREPARER_TEARDOWN_LATENCY("multi-target-preparer-teardown-latency", true),
        INCREMENTAL_FLASHING_PATCHES_SIZE("incremental-flashing-patches-size", true),
        INCREMENTAL_FLASHING_TARGET_SIZE("incremental-flashing-target-size", true);

        private final String mGroupName;
        private final boolean mAdditive;

        private InvocationGroupMetricKey(String groupName, boolean additive) {
            this.mGroupName = groupName;
            this.mAdditive = additive;
        }

        public String toString() {
            return this.mGroupName;
        }

        public boolean shouldAdd() {
            return this.mAdditive;
        }
    }
}

