/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.logger;

import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.postprocessor.IPostProcessor;
import com.android.tradefed.targetprep.ILabPreparer;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.multi.IMultiTargetPreparer;
import com.android.tradefed.testtype.IRemoteTest;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TfObjectTracker {
    public static final String TF_OBJECTS_TRACKING_KEY = "tf_objects_tracking";
    private static final Set<Class<?>> TRACKED_CLASSES = new LinkedHashSet();
    private static final Map<ThreadGroup, Map<String, Long>> mPerGroupUsage;

    private TfObjectTracker() {
    }

    public static void countWithParents(Class<?> object) {
        if (!TfObjectTracker.count(object)) {
            return;
        }
        TfObjectTracker.countWithParents(object.getSuperclass());
    }

    public static void directCount(String className, long occurrences) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        if (mPerGroupUsage.get(group) == null) {
            mPerGroupUsage.put(group, new ConcurrentHashMap());
        }
        Map<String, Long> countMap = mPerGroupUsage.get(group);
        long count = 0L;
        if (countMap.get(className) != null) {
            count = countMap.get(className);
        }
        countMap.put(className, count += occurrences);
    }

    private static boolean count(Class<?> object) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        String qualifiedName = object.getName();
        boolean tracked = false;
        for (Class<?> classTracked : TRACKED_CLASSES) {
            if (!classTracked.isAssignableFrom(object)) continue;
            tracked = true;
            break;
        }
        if (!tracked) {
            return false;
        }
        if (qualifiedName.contains("$")) {
            return true;
        }
        if (mPerGroupUsage.get(group) == null) {
            mPerGroupUsage.put(group, new ConcurrentHashMap());
        }
        Map<String, Long> countMap = mPerGroupUsage.get(group);
        long count = 0L;
        if (countMap.get(qualifiedName) != null) {
            count = countMap.get(qualifiedName);
        }
        countMap.put(qualifiedName, ++count);
        return true;
    }

    public static Map<String, Long> getUsage() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        if (mPerGroupUsage.get(group) == null) {
            mPerGroupUsage.put(group, new ConcurrentHashMap());
        }
        return new HashMap<String, Long>(mPerGroupUsage.get(group));
    }

    public static void clearTracking() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        mPerGroupUsage.remove(group);
    }

    static {
        TRACKED_CLASSES.add(IBuildProvider.class);
        TRACKED_CLASSES.add(IMetricCollector.class);
        TRACKED_CLASSES.add(IMultiTargetPreparer.class);
        TRACKED_CLASSES.add(IPostProcessor.class);
        TRACKED_CLASSES.add(IRemoteTest.class);
        TRACKED_CLASSES.add(ILabPreparer.class);
        TRACKED_CLASSES.add(ITargetPreparer.class);
        mPerGroupUsage = new ConcurrentHashMap<ThreadGroup, Map<String, Long>>();
    }
}

