/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.sandbox;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.InvocationExecution;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.invoker.tracing.TracePropagatingExecutorService;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.sandbox.ISandbox;
import com.android.tradefed.sandbox.SandboxInvocationRunner;
import com.android.tradefed.sandbox.SandboxOptions;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;

public class ParentSandboxInvocationExecution
extends InvocationExecution {
    private SandboxSetupThread setupThread;
    private TestInformation mTestInfo;

    @Override
    public boolean fetchBuild(TestInformation testInfo, IConfiguration config, IRescheduler rescheduler, ITestInvocationListener listener) throws DeviceNotAvailableException, BuildRetrievalError {
        this.mTestInfo = testInfo;
        if (!testInfo.getContext().getBuildInfos().isEmpty()) {
            LogUtil.CLog.d("Context already contains builds: %s. Skipping download as we are in sandbox-test-mode.", testInfo.getContext().getBuildInfos());
            return true;
        }
        CompletableFuture<Exception> futureClient = null;
        if (this.getSandboxOptions(config).shouldUseSplitDiscovery()) {
            futureClient = CompletableFuture.supplyAsync(() -> {
                try {
                    this.getSandbox(config).fetchSandboxExtraArtifacts(testInfo.getContext(), config, QuotationAwareTokenizer.tokenizeLine(config.getCommandLine(), false));
                    return null;
                }
                catch (BuildRetrievalError | ConfigurationException | IOException e) {
                    return e;
                }
            }, TracePropagatingExecutorService.create(ForkJoinPool.commonPool()));
        }
        boolean res = super.fetchBuild(testInfo, config, rescheduler, listener);
        if (this.getSandboxOptions(config).shouldUseSplitDiscovery()) {
            Exception e = null;
            try {
                e = futureClient.get();
                if (e != null) {
                    if (e instanceof BuildRetrievalError) {
                        throw (BuildRetrievalError)e;
                    }
                    throw new HarnessRuntimeException(e.getMessage(), e, InfraErrorIdentifier.SANDBOX_SETUP_ERROR);
                }
            }
            catch (InterruptedException | ExecutionException execError) {
                throw new BuildRetrievalError(execError.getMessage(), (Throwable)execError, InfraErrorIdentifier.SANDBOX_SETUP_ERROR);
            }
            if (res && e == null) {
                this.getSandbox(config).discoverTests(testInfo.getContext(), config);
            }
        }
        return res;
    }

    @Override
    protected List<ITargetPreparer> getTargetPreparersToRun(IConfiguration config, String deviceName) {
        return new ArrayList<ITargetPreparer>();
    }

    @Override
    protected List<ITargetPreparer> getLabPreparersToRun(IConfiguration config, String deviceName) {
        ArrayList<ITargetPreparer> preparersToRun = new ArrayList<ITargetPreparer>();
        preparersToRun.addAll(config.getDeviceConfigByName(deviceName).getLabPreparers());
        return preparersToRun;
    }

    @Override
    public void doSetup(TestInformation testInfo, IConfiguration config, ITestLogger listener) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        boolean parallelSetup = this.getSandboxOptions(config).shouldParallelSetup();
        try {
            super.doSetup(testInfo, config, listener);
        }
        catch (DeviceNotAvailableException | BuildError | TargetSetupError | RuntimeException e) {
            if (parallelSetup) {
                try {
                    this.setupThread.join();
                }
                catch (InterruptedException ie) {
                    LogUtil.CLog.e(ie);
                }
                SandboxInvocationRunner.teardownSandbox(config);
            }
            throw e;
        }
    }

    @Override
    public void doTeardown(TestInformation testInfo, IConfiguration config, ITestLogger logger, Throwable exception) throws Throwable {
        super.doTeardown(testInfo, config, logger, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCleanUp(IInvocationContext context, IConfiguration config, Throwable exception) {
        try {
            super.doCleanUp(context, config, exception);
        }
        finally {
            SandboxInvocationRunner.teardownSandbox(config);
        }
    }

    @Override
    public void runDevicePreInvocationSetup(IInvocationContext context, IConfiguration config, ITestLogger logger) throws DeviceNotAvailableException, TargetSetupError {
        if (this.shouldRunDeviceSpecificSetup(config)) {
            boolean parallelSetup = this.getSandboxOptions(config).shouldParallelSetup();
            if (parallelSetup) {
                this.setupThread = new SandboxSetupThread(Thread.currentThread().getThreadGroup(), this.mTestInfo, config, (ITestInvocationListener)logger);
                this.setupThread.start();
            }
            try {
                super.runDevicePreInvocationSetup(context, config, logger);
            }
            catch (DeviceNotAvailableException | TargetSetupError | RuntimeException e) {
                if (parallelSetup) {
                    try {
                        this.setupThread.join();
                    }
                    catch (InterruptedException ie) {
                        LogUtil.CLog.e(ie);
                    }
                    SandboxInvocationRunner.teardownSandbox(config);
                }
                throw e;
            }
        }
    }

    @Override
    public void runDevicePostInvocationTearDown(IInvocationContext context, IConfiguration config, Throwable exception) {
        if (this.shouldRunDeviceSpecificSetup(config)) {
            super.runDevicePostInvocationTearDown(context, config, exception);
        }
    }

    @Override
    public void runTests(TestInformation info, IConfiguration config, ITestInvocationListener listener) throws Throwable {
        try (CloseableTraceScope ignore = new CloseableTraceScope("prepareAndRunSandbox");){
            this.prepareAndRunSandbox(info, config, listener);
        }
    }

    @Override
    public void reportLogs(ITestDevice device, ITestLogger logger, TestInvocation.Stage stage) {
        if (!TestInvocation.Stage.ERROR.equals((Object)stage)) {
            return;
        }
        super.reportLogs(device, logger, stage);
    }

    protected IConfigurationFactory getFactory() {
        return ConfigurationFactory.getInstance();
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareAndRunSandbox(TestInformation info, IConfiguration config, ITestInvocationListener listener) throws Throwable {
        for (String deviceName : info.getContext().getDeviceConfigNames()) {
            if (info.getContext().getDevice(deviceName).getIDevice() instanceof StubDevice) continue;
            info.getContext().getDevice(deviceName).stopLogcat();
            LogUtil.CLog.i("Done stopping logcat for %s", info.getContext().getDevice(deviceName).getSerialNumber());
        }
        if (this.getSandboxOptions(config).shouldParallelSetup()) {
            long startTime = System.currentTimeMillis();
            try {
                this.setupThread.join();
            }
            finally {
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.DYNAMIC_FILE_RESOLVER_PAIR, startTime, System.currentTimeMillis());
            }
            if (this.setupThread.error != null) {
                LogUtil.CLog.e("An exception occurred during parallel setup.");
                throw this.setupThread.error;
            }
            return SandboxInvocationRunner.runSandbox(info, config, listener);
        }
        return SandboxInvocationRunner.prepareAndRun(info, config, listener);
    }

    private boolean shouldRunDeviceSpecificSetup(IConfiguration config) {
        SandboxOptions options = this.getSandboxOptions(config);
        return options != null && options.startAvdInParent();
    }

    private SandboxOptions getSandboxOptions(IConfiguration config) {
        return (SandboxOptions)config.getConfigurationObject("sandbox_options");
    }

    private ISandbox getSandbox(IConfiguration config) {
        return (ISandbox)config.getConfigurationObject("sandbox");
    }

    private class SandboxSetupThread
    extends Thread {
        private final TestInformation info;
        private final IConfiguration config;
        private final ITestInvocationListener listener;
        public Throwable error;

        public SandboxSetupThread(ThreadGroup currentGroup, TestInformation info, IConfiguration config, ITestInvocationListener listener) {
            super(currentGroup, "SandboxSetupThread");
            this.setDaemon(true);
            this.info = info;
            this.config = config;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                SandboxInvocationRunner.prepareSandbox(this.info, this.config, this.listener);
            }
            catch (Throwable e) {
                this.error = e;
            }
        }
    }
}

