/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.sandbox;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.InvocationExecution;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SandboxedInvocationExecution
extends InvocationExecution {
    @Override
    public boolean fetchBuild(TestInformation testInfo, IConfiguration config, IRescheduler rescheduler, ITestInvocationListener listener) throws DeviceNotAvailableException, BuildRetrievalError {
        LogUtil.CLog.d("Skipping download in the sandbox.");
        if (!config.getConfigurationDescription().shouldUseSandbox()) {
            throw new RuntimeException("We should only skip download if we are a sandbox. Something went very wrong.");
        }
        for (String deviceName : testInfo.getContext().getDeviceConfigNames()) {
            IDeviceConfiguration deviceConfig = config.getDeviceConfigByName(deviceName);
            IBuildProvider provider = deviceConfig.getBuildProvider();
            if (!(provider instanceof IInvocationContextReceiver)) continue;
            ((IInvocationContextReceiver)((Object)provider)).setInvocationContext(testInfo.getContext());
        }
        for (IBuildInfo info : testInfo.getContext().getBuildInfos()) {
            this.setTestTag(info, config);
        }
        this.backFillTestInformation(testInfo, testInfo.getBuildInfo());
        return true;
    }

    @Override
    public void cleanUpBuilds(IInvocationContext context, IConfiguration config) {
    }

    @Override
    protected List<ITargetPreparer> getTargetPreparersToRun(IConfiguration config, String deviceName) {
        ArrayList<ITargetPreparer> preparersToRun = new ArrayList<ITargetPreparer>();
        preparersToRun.addAll(config.getDeviceConfigByName(deviceName).getTargetPreparers());
        return preparersToRun;
    }

    @Override
    protected List<ITargetPreparer> getLabPreparersToRun(IConfiguration config, String deviceName) {
        return new ArrayList<ITargetPreparer>();
    }

    private void backFillTestInformation(TestInformation testInfo, IBuildInfo primaryBuild) {
        File hostDir;
        File targetDir;
        File testsDir;
        ExecutionFiles execFiles = testInfo.executionFiles();
        if (execFiles.get(ExecutionFiles.FilesKey.TESTS_DIRECTORY) == null && (testsDir = primaryBuild.getFile(BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE)) != null && testsDir.exists()) {
            execFiles.put(ExecutionFiles.FilesKey.TESTS_DIRECTORY, testsDir, true);
        }
        if (execFiles.get(ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY) == null && (targetDir = primaryBuild.getFile(BuildInfoKey.BuildInfoFileKey.TARGET_LINKED_DIR)) != null && targetDir.exists()) {
            execFiles.put(ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY, targetDir, true);
        }
        if (execFiles.get(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY) == null && (hostDir = primaryBuild.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR)) != null && hostDir.exists()) {
            execFiles.put(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY, hostDir, true);
        }
        for (String key : primaryBuild.getVersionedFileKeys()) {
            VersionedFile versionedFile = primaryBuild.getVersionedFile(key);
            if (versionedFile == null || !versionedFile.getFile().exists() || execFiles.containsKey(key)) continue;
            execFiles.put(key, versionedFile.getFile());
        }
    }

    @Override
    protected void logHostAdb(IConfiguration config, ITestLogger logger) {
    }
}

