/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.shard.IDynamicShardingClient;
import com.android.tradefed.invoker.shard.IDynamicShardingConnectionInfo;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.internal.android.engprod.v1.DynamicTestTargetProviderGrpc;
import com.google.internal.android.engprod.v1.ProvideTestTargetRequest;
import com.google.internal.android.engprod.v1.ProvideTestTargetResponse;
import com.google.internal.android.engprod.v1.RequestTestTargetRequest;
import com.google.internal.android.engprod.v1.RequestTestTargetResponse;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.util.concurrent.Executors;

public class ConfigurableGrpcDynamicShardingClient
implements IDynamicShardingClient {
    private ManagedChannel mChannel;
    private DynamicTestTargetProviderGrpc.DynamicTestTargetProviderBlockingStub mStub;
    private Credentials mCredentials;

    private ConfigurableGrpcDynamicShardingClient(ManagedChannel channel, DynamicTestTargetProviderGrpc.DynamicTestTargetProviderBlockingStub stub, Credentials creds) {
        this.mChannel = channel;
        this.mStub = stub;
        this.mCredentials = creds;
    }

    @Override
    public ProvideTestTargetResponse provideTestTarget(ProvideTestTargetRequest request) {
        return this.mStub.provideTestTarget(request);
    }

    @Override
    public RequestTestTargetResponse requestTestTarget(RequestTestTargetRequest request) {
        return this.mStub.requestTestTarget(request);
    }

    public ConfigurableGrpcDynamicShardingClient(IDynamicShardingConnectionInfo connectionInfo) {
        try {
            GoogleCredentials creds = GoogleCredentials.getApplicationDefault().createScoped(connectionInfo.getAuthScopes());
            ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(connectionInfo.getServerAddress(), connectionInfo.getServerPort()).executor(Executors.newCachedThreadPool())).maxInboundMessageSize(32768)).build();
            DynamicTestTargetProviderGrpc.DynamicTestTargetProviderBlockingStub stub = (DynamicTestTargetProviderGrpc.DynamicTestTargetProviderBlockingStub)DynamicTestTargetProviderGrpc.newBlockingStub(channel).withCallCredentials(MoreCallCredentials.from(creds));
            this.mChannel = channel;
            this.mStub = stub;
            this.mCredentials = creds;
        }
        catch (IOException e) {
            throw new HarnessRuntimeException(e.getMessage(), InfraErrorIdentifier.UNDETERMINED);
        }
    }
}

