/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.shard.ConfigurableGrpcDynamicShardingClient;
import com.android.tradefed.invoker.shard.DynamicShardingConnectionInfoMessage;
import com.android.tradefed.invoker.shard.IDynamicShardingClient;
import com.android.tradefed.invoker.shard.IDynamicShardingConnectionInfo;
import com.android.tradefed.invoker.shard.RemoteDynamicPool;
import com.android.tradefed.invoker.shard.StrictShardHelper;
import com.android.tradefed.invoker.shard.TestsPoolPoller;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.service.TradefedFeatureClient;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.ITestSuite;
import com.google.common.base.Strings;
import com.google.internal.android.engprod.v1.ProvideTestTargetRequest;
import com.google.internal.android.engprod.v1.SerializedTestTarget;
import com.proto.tradefed.feature.FeatureResponse;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

public class DynamicShardHelper
extends StrictShardHelper {
    @Override
    public boolean shardConfig(IConfiguration config, TestInformation testInfo, IRescheduler rescheduler, ITestLogger logger) {
        Integer shardCount = config.getCommandOptions().getShardCount();
        Integer shardIndex = config.getCommandOptions().getShardIndex();
        String invocationId = testInfo.getContext().getAttribute("invocation_id");
        String attemptId = testInfo.getContext().getAttribute("attempt_index");
        boolean shouldDelegate = false;
        if (shardIndex == null) {
            shouldDelegate = true;
        }
        if (shardCount == null) {
            throw new HarnessRuntimeException("shard-count is null while shard-index is " + shardIndex, InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
        }
        if (shardCount == 1) {
            return false;
        }
        if (Strings.isNullOrEmpty(attemptId)) {
            shouldDelegate = true;
        }
        if (Strings.isNullOrEmpty(invocationId)) {
            LogUtil.CLog.d("No invocation_id specified, falling back to strict sharding.");
            shouldDelegate = true;
        }
        if (shouldDelegate) {
            LogUtil.CLog.d("Setting option 'remote-dynamic-sharding' to false since precondition checks failed.");
            config.getCommandOptions().setShouldRemoteDynamicShard(false);
            return super.shardConfig(config, testInfo, rescheduler, logger);
        }
        IDynamicShardingClient client = this.getClient();
        String poolId = String.format("invocation-%s-attempt-%s", invocationId, attemptId);
        List<ITestSuite> allModules = this.getAllModules(config, testInfo);
        HashMap<String, ITestSuite> moduleMapping = new HashMap<String, ITestSuite>();
        for (ITestSuite test : allModules) {
            moduleMapping.put(test.getDirectModule().getId(), test);
        }
        try {
            List targetsToUpload = moduleMapping.keySet().stream().map(x -> SerializedTestTarget.newBuilder().setTargetName((String)x).build()).collect(Collectors.toList());
            LogUtil.CLog.d("Uploading to pool %s test targets: %s", poolId, targetsToUpload);
            ProvideTestTargetRequest request = ProvideTestTargetRequest.newBuilder().setReferencePoolId(poolId).addAllTestTargets(targetsToUpload).build();
            client.provideTestTarget(request);
        }
        catch (StatusRuntimeException e) {
            if (Status.fromThrowable(e).getCode() != Status.Code.ALREADY_EXISTS) {
                throw e;
            }
            LogUtil.CLog.v("Another shard has already seeded the pool '%s'.", poolId);
        }
        RemoteDynamicPool pool = RemoteDynamicPool.newInstance(client, poolId, moduleMapping);
        CountDownLatch tracker = new CountDownLatch(2);
        TestsPoolPoller poller = new TestsPoolPoller(pool, tracker);
        config.setTest(poller);
        return false;
    }

    private IDynamicShardingClient getClient() {
        TradefedFeatureClient featureClient = new TradefedFeatureClient();
        FeatureResponse resp = featureClient.triggerFeature("getDynamicShardingConnectionInfo", new HashMap<String, String>());
        if (resp.hasMultiPartResponse()) {
            DynamicShardingConnectionInfoMessage msg = DynamicShardingConnectionInfoMessage.fromMultiPartResponse(resp.getMultiPartResponse());
            return new ConfigurableGrpcDynamicShardingClient(msg);
        }
        LogUtil.CLog.v("Failed to get connection info from feature client, will attempt to load a client using the service loader");
        ServiceLoader<IDynamicShardingClient> serviceLoader = ServiceLoader.load(IDynamicShardingClient.class);
        for (IDynamicShardingClient client : serviceLoader) {
            if (!IDynamicShardingConnectionInfo.class.isAssignableFrom(client.getClass())) continue;
            return new ConfigurableGrpcDynamicShardingClient((IDynamicShardingConnectionInfo)((Object)client));
        }
        throw new HarnessRuntimeException("Failed to retrieve dynamic sharding connection info, feature server problem?", InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
    }

    private List<ITestSuite> getAllModules(IConfiguration config, TestInformation testInfo) {
        ArrayList<ITestSuite> allTests = new ArrayList<ITestSuite>();
        for (IRemoteTest test : config.getTests()) {
            if (test instanceof ITestSuite) {
                ((ITestSuite)test).setIntraModuleSharding(false);
                allTests.addAll(((ITestSuite)test).split(1000000, testInfo).stream().map(x -> (ITestSuite)x).collect(Collectors.toList()));
                continue;
            }
            throw new HarnessRuntimeException("Test not an instance of ITestSuite, cannot execute this using dynamic sharding.", InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
        }
        return allTests;
    }
}

