/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.shard.IDynamicShardingConnectionInfo;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.proto.tradefed.feature.MultiPartResponse;
import com.proto.tradefed.feature.PartResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DynamicShardingConnectionInfoMessage
implements IDynamicShardingConnectionInfo {
    private final String mServerName;
    private final Integer mServerPort;
    private final List<String> mAuthScopes;
    public static final String SERVER_NAME_KEY = "server_name";
    public static final String SERVER_PORT_KEY = "server_port";
    public static final String AUTH_SCOPES_KEY = "auth_scopes";

    DynamicShardingConnectionInfoMessage(String serverName, Integer serverPort, List<String> authScopes) {
        this.mServerName = serverName;
        this.mServerPort = serverPort;
        this.mAuthScopes = authScopes;
    }

    public static DynamicShardingConnectionInfoMessage fromConnectionInfo(IDynamicShardingConnectionInfo info) {
        return new DynamicShardingConnectionInfoMessage(info.getServerAddress(), info.getServerPort(), info.getAuthScopes());
    }

    public static DynamicShardingConnectionInfoMessage fromMultiPartResponse(MultiPartResponse response) {
        Optional<Object> serverName = Optional.empty();
        Optional<Object> serverPort = Optional.empty();
        ArrayList<String> authScopes = new ArrayList<String>();
        for (PartResponse part : response.getResponsePartList()) {
            if (part.getKey().equals(AUTH_SCOPES_KEY)) {
                authScopes.add(part.getValue());
            }
            if (part.getKey().equals(SERVER_NAME_KEY)) {
                if (serverName.isPresent()) {
                    throw new HarnessRuntimeException("Malformed dynamic sharding connection info: server name was specified more than once.", InfraErrorIdentifier.UNDETERMINED);
                }
                serverName = Optional.of(part.getValue());
            }
            if (!part.getKey().equals(SERVER_PORT_KEY)) continue;
            if (serverPort.isPresent()) {
                throw new HarnessRuntimeException("Malformed dynamic sharding connection info: server port was specified more than once.", InfraErrorIdentifier.UNDETERMINED);
            }
            serverPort = Optional.of(Integer.parseInt(part.getValue()));
        }
        if (!serverName.isPresent()) {
            throw new HarnessRuntimeException("Malformed dynamic sharding connection info: server name was not specified.", InfraErrorIdentifier.UNDETERMINED);
        }
        if (!serverPort.isPresent()) {
            throw new HarnessRuntimeException("Malformed dynamic sharding connection info: server port was not specified.", InfraErrorIdentifier.UNDETERMINED);
        }
        return new DynamicShardingConnectionInfoMessage((String)serverName.get(), (Integer)serverPort.get(), authScopes);
    }

    public MultiPartResponse.Builder toResponseBuilder() {
        MultiPartResponse.Builder builder = MultiPartResponse.newBuilder();
        builder.addResponsePart(PartResponse.newBuilder().setKey(SERVER_NAME_KEY).setValue(this.mServerName));
        builder.addResponsePart(PartResponse.newBuilder().setKey(SERVER_PORT_KEY).setValue(this.mServerPort.toString()));
        for (String scope : this.mAuthScopes) {
            builder.addResponsePart(PartResponse.newBuilder().setKey(AUTH_SCOPES_KEY).setValue(scope));
        }
        return builder;
    }

    @Override
    public String getServerAddress() {
        return this.mServerName;
    }

    @Override
    public Integer getServerPort() {
        return this.mServerPort;
    }

    @Override
    public List<String> getAuthScopes() {
        return this.mAuthScopes;
    }
}

