/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.shard.ITestsPool;
import com.android.tradefed.invoker.shard.token.ITokenProvider;
import com.android.tradefed.invoker.shard.token.ITokenRequest;
import com.android.tradefed.invoker.shard.token.TokenProperty;
import com.android.tradefed.invoker.shard.token.TokenProviderHelper;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.IRemoteTest;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class LocalPool
implements ITestsPool {
    private final Collection<IRemoteTest> mGenericPool;
    private final Collection<ITokenRequest> mTokenPool;
    private final Set<ITokenRequest> mRejectedToken;

    public LocalPool(Collection<IRemoteTest> genericPool, Collection<ITokenRequest> tokenPool) {
        this.mGenericPool = genericPool;
        this.mTokenPool = tokenPool;
        this.mRejectedToken = Sets.newConcurrentHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRemoteTest poll(TestInformation info, boolean reportNotExecuted) {
        Collection<IRemoteTest> collection;
        if (this.mTokenPool != null) {
            collection = this.mTokenPool;
            synchronized (collection) {
                if (!this.mTokenPool.isEmpty()) {
                    for (ITokenRequest test : this.mTokenPool) {
                        if (reportNotExecuted) {
                            this.mRejectedToken.remove(test);
                            this.mTokenPool.remove(test);
                            return test;
                        }
                        if (this.mRejectedToken.contains(test)) continue;
                        Set<TokenProperty> tokens = test.getRequiredTokens(info);
                        if (tokens == null || tokens.isEmpty() || this.isSupported(info, tokens)) {
                            this.mTokenPool.remove(test);
                            this.mRejectedToken.remove(test);
                            return test;
                        }
                        this.mRejectedToken.add(test);
                    }
                }
            }
        }
        collection = this.mGenericPool;
        synchronized (collection) {
            if (this.mGenericPool.isEmpty()) {
                return null;
            }
            IRemoteTest test = this.mGenericPool.iterator().next();
            this.mGenericPool.remove(test);
            return test;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITokenRequest pollRejectedTokenModule() {
        if (this.mTokenPool == null) {
            return null;
        }
        Collection<ITokenRequest> collection = this.mTokenPool;
        synchronized (collection) {
            if (this.mRejectedToken.isEmpty()) {
                return null;
            }
            ITokenRequest test = this.mRejectedToken.iterator().next();
            this.mRejectedToken.remove(test);
            this.mTokenPool.remove(test);
            return test;
        }
    }

    int peekTokenSize() {
        if (this.mTokenPool != null) {
            return this.mTokenPool.size();
        }
        return 0;
    }

    private boolean isSupported(TestInformation info, Set<TokenProperty> requiredTokens) {
        for (TokenProperty prop : requiredTokens) {
            ITokenProvider provider = TokenProviderHelper.getTokenProvider(prop);
            if (provider == null) {
                LogUtil.CLog.e("No provider for token %s", new Object[]{prop});
                return false;
            }
            if (provider.hasToken(info.getDevice(), prop)) continue;
            return false;
        }
        return true;
    }
}

