/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.ddmlib.Log;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ParentShardReplicate {
    public static void replicatedSetup(IConfiguration config, IKeyStoreClient client) {
        if (!config.getCommandOptions().shouldUseReplicateSetup()) {
            return;
        }
        if (config.getDeviceConfig().size() != 1) {
            return;
        }
        Integer shardCount = config.getCommandOptions().getShardCount();
        Integer shardIndex = config.getCommandOptions().getShardIndex();
        Integer deviceCount = shardCount;
        if (!(shardCount != null && shardIndex == null || (deviceCount = config.getCommandOptions().getMultiDeviceCount()) != null && deviceCount >= 2)) {
            return;
        }
        LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "Using replicated setup.");
        try {
            List<IDeviceConfiguration> currentConfigs = config.getDeviceConfig();
            HashSet<String> objectToReplicate = new HashSet<String>(Configuration.getMultiDeviceSupportedTag());
            objectToReplicate.remove("build_provider");
            for (int i = 0; i < deviceCount - 1; ++i) {
                IConfiguration deepCopy = config.partialDeepClone(new ArrayList<String>(objectToReplicate), client);
                String newName = String.format("expanded-%s", i);
                IDeviceConfiguration newDeviceConfig = deepCopy.getDeviceConfig().get(0).clone(newName);
                newDeviceConfig.addSpecificConfig(new StubBuildProvider());
                currentConfigs.add(newDeviceConfig);
            }
            config.setDeviceConfigList(currentConfigs);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e("Failed replicated setup configuration:");
            LogUtil.CLog.e(e);
        }
    }
}

