/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.shard.IDynamicShardingClient;
import com.android.tradefed.invoker.shard.ITestsPool;
import com.android.tradefed.invoker.shard.token.ITokenRequest;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.ITestSuite;
import com.google.internal.android.engprod.v1.RequestTestTargetRequest;
import com.google.internal.android.engprod.v1.RequestTestTargetResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RemoteDynamicPool
implements ITestsPool {
    private IDynamicShardingClient mClient;
    private Map<String, ITestSuite> mModuleMapping;
    private String mPoolId;
    private List<IRemoteTest> mQueuedTests = new ArrayList<IRemoteTest>();

    public static RemoteDynamicPool newInstance(IDynamicShardingClient client, String poolId, Map<String, ITestSuite> moduleMapping) {
        return new RemoteDynamicPool(client, poolId, moduleMapping);
    }

    private RemoteDynamicPool(IDynamicShardingClient client, String poolId, Map<String, ITestSuite> moduleMapping) {
        this.mClient = client;
        this.mModuleMapping = moduleMapping;
        this.mPoolId = poolId;
    }

    @Override
    public IRemoteTest poll(TestInformation info, boolean reportNotExecuted) {
        if (this.mQueuedTests.isEmpty()) {
            RequestTestTargetRequest request = RequestTestTargetRequest.newBuilder().setReferencePoolId(this.mPoolId).build();
            RequestTestTargetResponse response = this.mClient.requestTestTarget(request);
            LogUtil.CLog.v(String.format("Received test targets: %s", response.getTestTargetsList()));
            this.mQueuedTests.addAll(response.getTestTargetsList().stream().map(x -> this.mModuleMapping.get(x.getTargetName())).collect(Collectors.toList()));
            if (this.mQueuedTests.isEmpty()) {
                return null;
            }
            return this.mQueuedTests.remove(this.mQueuedTests.size() - 1);
        }
        return this.mQueuedTests.remove(this.mQueuedTests.size() - 1);
    }

    @Override
    public ITokenRequest pollRejectedTokenModule() {
        return null;
    }
}

