/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.ExistingBuildProvider;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;

public class ShardBuildCloner {
    public static void cloneBuildInfos(IConfiguration fromConfig, IConfiguration toConfig, TestInformation testInfo) {
        IInvocationContext context = testInfo.getContext();
        IBuildInfo primaryClone = null;
        for (String deviceName : context.getDeviceConfigNames()) {
            IBuildInfo toBuild = context.getBuildInfo(deviceName).clone();
            if (primaryClone == null) {
                primaryClone = toBuild;
            }
            try {
                IDeviceConfiguration deviceConfig = toConfig.getDeviceConfigByName(deviceName);
                if (deviceConfig == null) {
                    throw new RuntimeException(String.format("Configuration doesn't have device '%s' while context does [%s].", deviceName, context.getDeviceConfigNames()));
                }
                deviceConfig.addSpecificConfig(new ExistingBuildProvider(toBuild, fromConfig.getDeviceConfigByName(deviceName).getBuildProvider()));
            }
            catch (ConfigurationException e) {
                LogUtil.CLog.e(e);
            }
        }
        IBuildInfo primaryBuild = context.getBuildInfos().get(0);
        TestInformation newInfo = TestInformation.createCopyTestInfo(testInfo, context);
        ExecutionFiles execFiles = newInfo.executionFiles();
        if (execFiles.get(ExecutionFiles.FilesKey.TESTS_DIRECTORY) != null && execFiles.get(ExecutionFiles.FilesKey.TESTS_DIRECTORY).equals(primaryBuild.getFile(BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE))) {
            execFiles.put(ExecutionFiles.FilesKey.TESTS_DIRECTORY, primaryClone.getFile(BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE));
        }
        if (execFiles.get(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY) != null && execFiles.get(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY).equals(primaryBuild.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR))) {
            execFiles.put(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY, primaryClone.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR));
        }
        if (execFiles.get(ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY) != null && execFiles.get(ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY).equals(primaryBuild.getFile(BuildInfoKey.BuildInfoFileKey.TARGET_LINKED_DIR))) {
            execFiles.put(ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY, primaryClone.getFile(BuildInfoKey.BuildInfoFileKey.TARGET_LINKED_DIR));
        }
        for (String key : primaryBuild.getVersionedFileKeys()) {
            VersionedFile versionedFile = primaryBuild.getVersionedFile(key);
            if (!versionedFile.getFile().equals(execFiles.get(key))) continue;
            execFiles.put(key, primaryClone.getFile(key));
        }
        try {
            toConfig.setConfigurationObject("shared_test_information", newInfo);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e(e);
        }
    }
}

