/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.ShardListener;
import com.android.tradefed.invoker.ShardMainResultForwarder;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.shard.IShardHelper;
import com.android.tradefed.invoker.shard.ITestsPool;
import com.android.tradefed.invoker.shard.LastShardDetector;
import com.android.tradefed.invoker.shard.LocalPool;
import com.android.tradefed.invoker.shard.ShardBuildCloner;
import com.android.tradefed.invoker.shard.TestsPoolPoller;
import com.android.tradefed.invoker.shard.token.ITokenRequest;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.IShardableListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.suite.ITestSuite;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.android.tradefed.util.keystore.KeyStoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class ShardHelper
implements IShardHelper {
    public static final String LAST_SHARD_DETECTOR = "last_shard_detector";
    public static final String SHARED_TEST_INFORMATION = "shared_test_information";
    private static final List<String> CONFIG_OBJ_TO_CLONE = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shardConfig(IConfiguration config, TestInformation testInfo, IRescheduler rescheduler, ITestLogger logger) {
        IInvocationContext context = testInfo.getContext();
        ArrayList<IRemoteTest> shardableTests = new ArrayList<IRemoteTest>();
        boolean isSharded = false;
        Integer shardCount = config.getCommandOptions().getShardCount();
        for (IRemoteTest test : config.getTests()) {
            isSharded |= ShardHelper.shardTest(shardableTests, test, shardCount, testInfo, logger);
        }
        if (!isSharded) {
            return false;
        }
        Map<Integer, List<IRemoteTest>> multiDevicesShards = this.buildMultiDevicesShard(shardableTests);
        int expectedShard = shardableTests.size();
        if (shardCount != null) {
            expectedShard = Math.min(shardCount, shardableTests.size());
        }
        if (!multiDevicesShards.isEmpty()) {
            expectedShard += multiDevicesShards.size();
        }
        LastShardDetector lastShard = new LastShardDetector();
        ShardMainResultForwarder resultCollector = new ShardMainResultForwarder(ShardHelper.buildMainShardListeners(config, lastShard), expectedShard);
        config.getLogSaver().invocationStarted(context);
        resultCollector.invocationStarted(context);
        ArrayList<IRemoteTest> arrayList = shardableTests;
        synchronized (arrayList) {
            int i;
            Collection<ITokenRequest> tokenPool;
            CountDownLatch tracker;
            this.scheduledMultiDevicesShard(multiDevicesShards, config, testInfo, rescheduler, resultCollector, expectedShard);
            if (shardCount != null) {
                Collections.shuffle(shardableTests);
                tracker = new CountDownLatch(expectedShard - multiDevicesShards.size());
                tokenPool = null;
                if (config.getCommandOptions().shouldUseTokenSharding()) {
                    tokenPool = this.extractTokenTests(shardableTests);
                }
                for (i = 0; i < expectedShard - multiDevicesShards.size(); ++i) {
                    IConfiguration shardConfig = this.cloneConfigObject(config);
                    try {
                        shardConfig.setConfigurationObject(LAST_SHARD_DETECTOR, lastShard);
                    }
                    catch (ConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    TestsPoolPoller poller = new TestsPoolPoller(this.createTestsPool(shardableTests, tokenPool), tracker);
                    shardConfig.setTest(poller);
                    this.rescheduleConfig(shardConfig, config, testInfo, rescheduler, resultCollector, i);
                }
            } else {
                tracker = new CountDownLatch(shardableTests.size());
                tokenPool = null;
                if (config.getCommandOptions().shouldUseTokenSharding()) {
                    tokenPool = this.extractTokenTests(shardableTests);
                }
                i = 0;
                for (IRemoteTest testShard : shardableTests) {
                    LogUtil.CLog.d("Rescheduling sharded config...");
                    IConfiguration shardConfig = this.cloneConfigObject(config);
                    try {
                        shardConfig.setConfigurationObject(LAST_SHARD_DETECTOR, lastShard);
                    }
                    catch (ConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    if (config.getCommandOptions().shouldUseDynamicSharding()) {
                        TestsPoolPoller poller = new TestsPoolPoller(this.createTestsPool(shardableTests, tokenPool), tracker);
                        shardConfig.setTest(poller);
                    } else {
                        shardConfig.setTest(testShard);
                    }
                    this.rescheduleConfig(shardConfig, config, testInfo, rescheduler, resultCollector, i);
                    ++i;
                }
            }
        }
        if (!config.getConfigurationDescription().shouldUseSandbox()) {
            for (String deviceName : context.getDeviceConfigNames()) {
                config.getDeviceConfigByName(deviceName).getBuildProvider().cleanUp(context.getBuildInfo(deviceName));
            }
        }
        return true;
    }

    private ITestsPool createTestsPool(Collection<IRemoteTest> tests, Collection<ITokenRequest> tokenTests) {
        return new LocalPool(tests, tokenTests);
    }

    private void rescheduleConfig(IConfiguration shardConfig, IConfiguration config, TestInformation testInfo, IRescheduler rescheduler, ShardMainResultForwarder resultCollector, int index) {
        this.validateOptions(testInfo, shardConfig);
        ShardBuildCloner.cloneBuildInfos(config, shardConfig, testInfo);
        shardConfig.setTestInvocationListeners(ShardHelper.buildShardListeners(resultCollector, config, config.getTestInvocationListeners()));
        String suffix = String.format("_shard_index_%s", index);
        if (shardConfig.getCommandOptions().getHostLogSuffix() != null) {
            suffix = shardConfig.getCommandOptions().getHostLogSuffix() + suffix;
        }
        shardConfig.getCommandOptions().setHostLogSuffix(suffix);
        shardConfig.getConfigurationDescription().setSandboxed(false);
        shardConfig.getConfigurationDescription().setShardIndex(index);
        rescheduler.scheduleConfig(shardConfig);
    }

    protected IGlobalConfiguration getGlobalConfiguration() {
        return GlobalConfiguration.getInstance();
    }

    protected void validateOptions(TestInformation testInfo, IConfiguration config) {
        try {
            config.validateOptions();
            DynamicRemoteFileResolver resolver = new DynamicRemoteFileResolver();
            resolver.setDevice(testInfo.getDevice());
            resolver.addExtraArgs(config.getCommandOptions().getDynamicDownloadArgs());
            config.resolveDynamicOptions(resolver);
        }
        catch (BuildRetrievalError | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private IConfiguration cloneConfigObject(IConfiguration origConfig) {
        IKeyStoreClient client = null;
        try {
            client = this.getGlobalConfiguration().getKeyStoreFactory().createKeyStoreClient();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(String.format("failed to load keystore client when sharding: %s", e.getMessage()), e);
        }
        try {
            IConfiguration deepCopy = origConfig.partialDeepClone(CONFIG_OBJ_TO_CLONE, client);
            deepCopy.getCommandOptions().setShardCount(null);
            deepCopy.getConfigurationDescription().addMetadata("sharded", "true");
            deepCopy.getConfigurationDescription().removeMetadata("SERVER_REFERENCE");
            return deepCopy;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(String.format("failed to deep copy a configuration: %s", e.getMessage()), e);
        }
    }

    private static boolean shardTest(List<IRemoteTest> shardableTests, IRemoteTest test, Integer shardCount, TestInformation testInfo, ITestLogger logger) {
        boolean isSharded = false;
        if (test instanceof IShardableTest) {
            IShardableTest shardableTest;
            Collection<IRemoteTest> shards;
            if (test instanceof IBuildReceiver) {
                ((IBuildReceiver)((Object)test)).setBuild(testInfo.getBuildInfo());
            }
            if (test instanceof IDeviceTest) {
                ((IDeviceTest)((Object)test)).setDevice(testInfo.getDevice());
            }
            if (test instanceof IInvocationContextReceiver) {
                ((IInvocationContextReceiver)((Object)test)).setInvocationContext(testInfo.getContext());
            }
            if (test instanceof ITestLoggerReceiver) {
                ((ITestLoggerReceiver)((Object)test)).setTestLogger(logger);
            }
            if ((shards = (shardableTest = (IShardableTest)test).split(shardCount, testInfo)) != null) {
                shardableTests.addAll(shards);
                isSharded = true;
            }
        }
        if (!isSharded) {
            shardableTests.add(test);
        }
        return isSharded;
    }

    private static List<ITestInvocationListener> buildMainShardListeners(IConfiguration config, LastShardDetector lastShardDetector) {
        ArrayList<ITestInvocationListener> newListeners = new ArrayList<ITestInvocationListener>();
        for (ITestInvocationListener l : config.getTestInvocationListeners()) {
            if (!(l instanceof IShardableListener)) {
                newListeners.add(l);
                continue;
            }
            if (((IShardableListener)l).supportShardListener()) continue;
            newListeners.add(l);
        }
        newListeners.add(lastShardDetector);
        return newListeners;
    }

    private static List<ITestInvocationListener> buildShardListeners(ShardMainResultForwarder resultCollector, IConfiguration config, List<ITestInvocationListener> origListeners) {
        ArrayList<ITestInvocationListener> shardListeners = new ArrayList<ITestInvocationListener>();
        for (ITestInvocationListener l : origListeners) {
            if (!(l instanceof IShardableListener) || !((IShardableListener)l).supportShardListener()) continue;
            shardListeners.add(((IShardableListener)l).clone());
        }
        ShardListener origConfigListener = new ShardListener(resultCollector);
        origConfigListener.setSupportGranularResults(ShardHelper.isAutoRetryEnabled(config));
        shardListeners.add(origConfigListener);
        return shardListeners;
    }

    private static boolean isAutoRetryEnabled(IConfiguration config) {
        IRetryDecision decision = config.getRetryDecision();
        return decision.isAutoRetryEnabled() && decision.getMaxRetryCount() > 0;
    }

    private Collection<ITokenRequest> extractTokenTests(Collection<IRemoteTest> shardableTests) {
        ArrayList<ITokenRequest> tokenPool = new ArrayList<ITokenRequest>();
        for (IRemoteTest test : new ArrayList<IRemoteTest>(shardableTests)) {
            if (!(test instanceof ITokenRequest)) continue;
            tokenPool.add((ITokenRequest)test);
            shardableTests.remove(test);
        }
        return tokenPool;
    }

    private Map<Integer, List<IRemoteTest>> buildMultiDevicesShard(List<IRemoteTest> shardableTests) {
        LinkedHashMap<Integer, List<IRemoteTest>> neededDevicePerTest = new LinkedHashMap<Integer, List<IRemoteTest>>();
        for (IRemoteTest test : new ArrayList<IRemoteTest>(shardableTests)) {
            if (!(test instanceof ITestSuite) || ((ITestSuite)test).getDirectModule().neededDevices() <= 1) continue;
            shardableTests.remove(test);
            int neededDevices = ((ITestSuite)test).getDirectModule().neededDevices();
            if (!neededDevicePerTest.containsKey(neededDevices)) {
                neededDevicePerTest.put(neededDevices, new ArrayList());
            }
            List multiDevicesTests = (List)neededDevicePerTest.get(neededDevices);
            multiDevicesTests.add(test);
        }
        return neededDevicePerTest;
    }

    private void scheduledMultiDevicesShard(Map<Integer, List<IRemoteTest>> multiDevicesShards, IConfiguration config, TestInformation testInfo, IRescheduler rescheduler, ShardMainResultForwarder resultCollector, int expectedShard) {
        if (multiDevicesShards.isEmpty()) {
            return;
        }
        int index = expectedShard - multiDevicesShards.size();
        for (Map.Entry<Integer, List<IRemoteTest>> multiDevicesTest : multiDevicesShards.entrySet()) {
            IConfiguration shardConfig = this.cloneConfigObject(config);
            shardConfig.setTests(multiDevicesTest.getValue());
            shardConfig.getCommandOptions().setMultiDeviceCount(multiDevicesTest.getKey());
            shardConfig.getCommandOptions().setReplicateSetup(true);
            this.rescheduleConfig(shardConfig, config, testInfo, rescheduler, resultCollector, index);
            ++index;
        }
    }

    static {
        CONFIG_OBJ_TO_CLONE.add("system_checker");
        CONFIG_OBJ_TO_CLONE.add("metrics_collector");
        CONFIG_OBJ_TO_CLONE.add("build_provider");
        CONFIG_OBJ_TO_CLONE.add("target_preparer");
        CONFIG_OBJ_TO_CLONE.add("device_recovery");
        CONFIG_OBJ_TO_CLONE.add("device_options");
        CONFIG_OBJ_TO_CLONE.add("multi_target_preparer");
        CONFIG_OBJ_TO_CLONE.add("cmd_options");
        CONFIG_OBJ_TO_CLONE.add("logger");
        CONFIG_OBJ_TO_CLONE.add("log_saver");
        CONFIG_OBJ_TO_CLONE.add("retry_decision");
        CONFIG_OBJ_TO_CLONE.add("config_desc");
    }
}

