/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.cloud.NestedRemoteDevice;
import com.android.tradefed.device.metric.CountTestCasesCollector;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.IMetricCollectorReceiver;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.shard.ITestsPool;
import com.android.tradefed.invoker.shard.LocalPool;
import com.android.tradefed.invoker.shard.token.ITokenRequest;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.ISystemStatusCheckerReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IReportNotExecuted;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.suite.BaseTestSuite;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TimeUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public final class TestsPoolPoller
implements IRemoteTest,
IConfigurationReceiver,
ISystemStatusCheckerReceiver,
IMetricCollectorReceiver {
    private static final long WAIT_RECOVERY_TIME = 900000L;
    private ITestsPool mTestsPool;
    private CountDownLatch mTracker;
    private TestInformation mTestInfo;
    private IConfiguration mConfig;
    private List<ISystemStatusChecker> mSystemStatusCheckers;
    private List<IMetricCollector> mCollectors;
    private ILogRegistry mRegistry = null;

    public TestsPoolPoller(ITestsPool testsPool, CountDownLatch tracker) {
        this.mTracker = tracker;
        this.mTestsPool = testsPool;
    }

    IRemoteTest poll() {
        return this.poll(false);
    }

    private IRemoteTest poll(boolean reportNotExecuted) {
        return this.mTestsPool.poll(this.mTestInfo, reportNotExecuted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run(TestInformation info, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mTestInfo = info;
        listenerWithCollectors = listener;
        for (IMetricCollector collector : this.mCollectors) {
            if (collector instanceof IConfigurationReceiver) {
                ((IConfigurationReceiver)collector).setConfiguration(this.mConfig);
            }
            listenerWithCollectors = collector.init(info.getContext(), listenerWithCollectors);
        }
        while (true) lbl-1000:
        // 8 sources

        {
            if ((test = this.poll()) == null) {
                return;
            }
            if (test instanceof IBuildReceiver) {
                ((IBuildReceiver)test).setBuild(info.getBuildInfo());
            }
            if (test instanceof IDeviceTest) {
                ((IDeviceTest)test).setDevice(info.getDevice());
            }
            if (test instanceof IInvocationContextReceiver) {
                ((IInvocationContextReceiver)test).setInvocationContext(info.getContext());
            }
            if (test instanceof ISystemStatusCheckerReceiver) {
                ((ISystemStatusCheckerReceiver)test).setSystemStatusChecker(this.mSystemStatusCheckers);
            }
            if (test instanceof ITestFilterReceiver) {
                this.mConfig.getGlobalFilters().applyFiltersToTest((ITestFilterReceiver)test);
            } else if (test instanceof BaseTestSuite) {
                LogUtil.CLog.d("Applying global filters to BaseTestSuite");
                this.mConfig.getGlobalFilters().applyFiltersToTest((BaseTestSuite)test);
            }
            validationConfig = new Configuration("validation", "validation");
            try {
                validationConfig.setTest(test);
                validationConfig.validateOptions();
                resolver = new DynamicRemoteFileResolver();
                resolver.addExtraArgs(validationConfig.getCommandOptions().getDynamicDownloadArgs());
                resolver.setDevice(info.getDevice());
                validationConfig.resolveDynamicOptions(resolver);
                if (test instanceof IConfigurationReceiver) {
                    ((IConfigurationReceiver)test).setConfiguration(this.mConfig);
                }
                if (test instanceof IMetricCollectorReceiver) {
                    ((IMetricCollectorReceiver)test).setMetricCollectors(this.mCollectors);
                    test.run(info, listener);
                }
                if (this.mConfig != null && this.mConfig.getCommandOptions().reportTestCaseCount()) {
                    counter = new CountTestCasesCollector(test);
                    listenerWithCollectors = counter.init(info.getContext(), listenerWithCollectors);
                }
                test.run(info, listenerWithCollectors);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Caught an Exception in a test: %s. Proceeding to next test.", new Object[]{test.getClass()});
                LogUtil.CLog.e(e);
            }
            catch (DeviceUnresponsiveException due) {
                LogUtil.CLog.w("Ignored DeviceUnresponsiveException because recovery was successful, proceeding with next test. Stack trace:");
                LogUtil.CLog.w(due);
                LogUtil.CLog.w("Proceeding to the next test.");
            }
            catch (DeviceNotAvailableException dnae) {
                this.HandleDeviceNotAvailable(dnae, test);
            }
            catch (BuildRetrievalError | ConfigurationException e) {
                LogUtil.CLog.w("Failed to validate the @options of test: %s. Proceeding to next test.", new Object[]{test.getClass()});
                LogUtil.CLog.w(e);
            }
            finally {
                validationConfig.cleanConfigurationData();
                CurrentInvocation.setRunIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                CurrentInvocation.setModuleIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                if (!(test instanceof BaseTestSuite)) continue;
                ((BaseTestSuite)test).cleanUpSuiteSetup();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.mTracker.countDown();
            if (this.mTracker.getCount() == 0L) {
                this.reportNotExecuted(listener);
            }
        }
    }

    void HandleDeviceNotAvailable(DeviceNotAvailableException originalException, IRemoteTest test) throws DeviceNotAvailableException {
        ITestDevice device = this.mTestInfo.getDevice();
        try {
            if (!(device instanceof NestedRemoteDevice) && this.mTracker.getCount() > 1L) {
                LogUtil.CLog.d("Wait %s for device to maybe come back online.", TimeUtil.formatElapsedTime(900000L));
                device.waitForDeviceAvailable(900000L);
                device.reboot();
                LogUtil.CLog.d("TestPoller was recovered after %s went offline", device.getSerialNumber());
                return;
            }
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            // empty catch block
        }
        LogUtil.CLog.e("Test %s threw DeviceNotAvailableException. Test poller associated with device %s is terminating.", test.getClass(), device.getSerialNumber());
        this.logDeviceEvent(ILogRegistry.EventType.SHARD_POLLER_EARLY_TERMINATION, device.getSerialNumber(), originalException);
        throw originalException;
    }

    private void reportNotExecuted(ITestInvocationListener listener) {
        ITokenRequest tokenTest = this.mTestsPool.pollRejectedTokenModule();
        while (tokenTest != null) {
            if (tokenTest instanceof IReportNotExecuted) {
                String message2 = String.format("Test did not run. No token '%s' matching it on any device.", tokenTest.getRequiredTokens(this.mTestInfo));
                ((IReportNotExecuted)((Object)tokenTest)).reportNotExecuted(listener, message2);
            } else {
                LogUtil.CLog.e("Could not report not executed tests from %s.", tokenTest.getClass().getCanonicalName());
            }
            tokenTest = this.mTestsPool.pollRejectedTokenModule();
        }
        IRemoteTest test = this.poll(true);
        while (test != null) {
            if (test instanceof IReportNotExecuted) {
                ((IReportNotExecuted)((Object)test)).reportNotExecuted(listener);
            } else {
                LogUtil.CLog.e("Could not report not executed tests from %s.", test.getClass().getCanonicalName());
            }
            test = this.poll(true);
        }
    }

    private void logDeviceEvent(ILogRegistry.EventType event, String serial, Throwable t) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("serial", serial);
        args.put("trace", StreamUtil.getStackTrace(t));
        this.getLogRegistry().logEvent(Log.LogLevel.DEBUG, event, args);
    }

    private ILogRegistry getLogRegistry() {
        if (this.mRegistry != null) {
            return this.mRegistry;
        }
        return LogRegistry.getLogRegistry();
    }

    public void setLogRegistry(ILogRegistry registry) {
        this.mRegistry = registry;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    @Override
    public void setSystemStatusChecker(List<ISystemStatusChecker> systemCheckers) {
        this.mSystemStatusCheckers = systemCheckers;
    }

    @Override
    public void setMetricCollectors(List<IMetricCollector> collectors) {
        this.mCollectors = collectors;
    }

    int peekTokenPoolSize() {
        return ((LocalPool)this.mTestsPool).peekTokenSize();
    }
}

