/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard.token;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.shard.token.ITokenProvider;
import com.android.tradefed.invoker.shard.token.TokenProperty;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CecControllerTokenProvider
implements ITokenProvider {
    private static final int TIMEOUT_MILLIS = 10000;
    private List<String> devicesWithToken = new ArrayList<String>();

    @Override
    public boolean hasToken(ITestDevice device, TokenProperty token) {
        if (device.getIDevice() instanceof StubDevice) {
            return false;
        }
        switch (token) {
            case CEC_TEST_CONTROLLER: {
                try {
                    if (!device.hasFeature("feature:android.hardware.hdmi.cec") || !device.hasFeature("feature:android.software.leanback")) {
                        return true;
                    }
                    return this.isCecAdapterConnected(device);
                }
                catch (DeviceNotAvailableException dnae) {
                    LogUtil.CLog.e("Device not available. Not providing token.");
                    return false;
                }
            }
        }
        LogUtil.CLog.e("Token '%s' doesn't match any CecControllerTokenProvider tokens.", new Object[]{token});
        return false;
    }

    @VisibleForTesting
    boolean checkConsoleOutput(String expectedMessage, long timeoutMillis, BufferedReader inputConsole) throws IOException {
        long startTime;
        long endTime = startTime = System.currentTimeMillis();
        do {
            String line;
            if (!inputConsole.ready() || (line = inputConsole.readLine()) == null || !line.toLowerCase().contains(expectedMessage)) continue;
            LogUtil.CLog.v("Found " + expectedMessage + " in " + line);
            return true;
        } while ((endTime = System.currentTimeMillis()) - startTime <= timeoutMillis);
        return false;
    }

    List<String> getValidCecClientPorts() throws IOException, InterruptedException {
        ArrayList<String> listPortsCommand = new ArrayList<String>();
        listPortsCommand.add("cec-client");
        listPortsCommand.add("-l");
        ArrayList<String> comPorts = new ArrayList<String>();
        Process cecClient = RunUtil.getDefault().runCmdInBackground(listPortsCommand);
        try (BufferedReader inputConsole = new BufferedReader(new InputStreamReader(cecClient.getInputStream()));){
            while (cecClient.isAlive()) {
                String line;
                if (!inputConsole.ready() || !(line = inputConsole.readLine()).toLowerCase().contains("com port")) continue;
                String port = line.split(":")[1].trim();
                comPorts.add(port);
            }
        }
        cecClient.waitFor();
        return comPorts;
    }

    @VisibleForTesting
    String convertStringToHexParams(String rawParams) {
        StringBuilder params = new StringBuilder("");
        for (int i = 0; i < rawParams.length(); ++i) {
            params.append(String.format(":%02x", rawParams.charAt(i)));
        }
        return params.toString().substring(1);
    }

    int getDumpsysLogicalAddress(ITestDevice device) throws IOException, DeviceNotAvailableException {
        String line;
        String pattern = "(.*?)(mAddress: )(?<address>\\d+)(.*?)";
        Pattern p = Pattern.compile(pattern);
        String dumpsys = device.executeShellCommand("dumpsys hdmi_control");
        BufferedReader reader = new BufferedReader(new StringReader(dumpsys));
        while ((line = reader.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            int address = Integer.decode(m.group("address"));
            return address;
        }
        throw new IOException("Could not parse logical address from dumpsys.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    boolean isCecAdapterConnected(ITestDevice device) throws DeviceNotAvailableException {
        ArrayList<String> launchCommand = new ArrayList<String>();
        String serialNo = device.getProperty("ro.serialno");
        if (this.devicesWithToken.contains(serialNo)) {
            return true;
        }
        launchCommand.add("cec-client");
        try {
            int toDevice;
            List<String> comPorts = this.getValidCecClientPorts();
            if (comPorts.size() == 0) {
                return false;
            }
            int targetDevice = this.getDumpsysLogicalAddress(device);
            launchCommand.add("-t");
            if (targetDevice == 0) {
                toDevice = 4;
                launchCommand.add("p");
            } else {
                toDevice = 0;
                launchCommand.add("x");
            }
            String serialNoParam = this.convertStringToHexParams(serialNo);
            StringBuilder sendVendorCommand = new StringBuilder("cmd hdmi_control vendorcommand ");
            sendVendorCommand.append(" -t " + targetDevice);
            sendVendorCommand.append(" -d " + toDevice);
            sendVendorCommand.append(" -a " + serialNoParam);
            Iterator<String> iterator2 = comPorts.iterator();
            while (iterator2.hasNext()) {
                String port = iterator2.next();
                launchCommand.add(port);
                Process mCecClient = RunUtil.getDefault().runCmdInBackground(launchCommand);
                try (BufferedReader inputConsole = new BufferedReader(new InputStreamReader(mCecClient.getInputStream()));){
                    if (this.checkConsoleOutput("waiting for input", 10000L, inputConsole)) {
                        device.executeShellCommand(sendVendorCommand.toString());
                        if (!this.checkConsoleOutput(serialNoParam, 10000L, inputConsole)) continue;
                        this.devicesWithToken.add(serialNo);
                        boolean bl = true;
                        return bl;
                    }
                    LogUtil.CLog.e("Console did not get ready!");
                }
                finally {
                    Process killProcess = mCecClient.destroyForcibly();
                    killProcess.waitFor();
                    launchCommand.remove(port);
                }
            }
            return false;
        }
        catch (IOException | InterruptedException e) {
            LogUtil.CLog.e("Caught " + e.getClass().getSimpleName() + ". Could not launch the cec-client process.");
            return false;
        }
    }
}

