/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.shard.token;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.helper.TelephonyHelper;
import com.android.tradefed.invoker.shard.token.ITokenProvider;
import com.android.tradefed.invoker.shard.token.TokenProperty;
import com.android.tradefed.log.LogUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TelephonyTokenProvider
implements ITokenProvider {
    public static final String ORANGE_SIM_ID = "20801";
    public static final String THALES_GEMALTO_SIM_ID = "00101";
    public static final String GSM_OPERATOR_PROP = "gsm.sim.operator.numeric";
    private static final String[] SECURE_ELEMENT_SIM_IDS = new String[]{"20801", "00101"};

    @Override
    public boolean hasToken(ITestDevice device, TokenProperty token) {
        if (device.getIDevice() instanceof StubDevice) {
            return false;
        }
        try {
            TelephonyHelper.SimCardInformation info = this.getSimInfo(device);
            if (info == null || !info.mHasTelephonySupport) {
                LogUtil.CLog.e("SimcardInfo: %s", info);
                return false;
            }
            switch (token) {
                case SIM_CARD: {
                    if ("5".equals(info.mSimState)) {
                        return true;
                    }
                    LogUtil.CLog.w("%s cannot run with token '%s' - Sim info: %s", new Object[]{device.getSerialNumber(), token, info});
                    return false;
                }
                case UICC_SIM_CARD: {
                    if (info.mCarrierPrivileges) {
                        return true;
                    }
                    LogUtil.CLog.w("%s cannot run with token '%s' - Sim info: %s", new Object[]{device.getSerialNumber(), token, info});
                    return false;
                }
                case SECURE_ELEMENT_SIM_CARD: {
                    if (info.mHasSecuredElement && info.mHasSeService) {
                        List<String> simProp = this.getOptionalDualSimProperty(device, GSM_OPERATOR_PROP);
                        if (!Collections.disjoint(simProp, Arrays.asList(SECURE_ELEMENT_SIM_IDS))) {
                            return true;
                        }
                        LogUtil.CLog.w("%s doesn't have a Orange Sim card (%s) for secured elements. %s returned: '%s'", device.getSerialNumber(), ORANGE_SIM_ID, GSM_OPERATOR_PROP, simProp);
                    }
                    LogUtil.CLog.w("%s cannot run with token '%s' - Sim info: %s", new Object[]{device.getSerialNumber(), token, info});
                    return false;
                }
            }
            LogUtil.CLog.w("Token '%s' doesn't match any TelephonyTokenProvider tokens.", new Object[]{token});
            return false;
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Ignoring DNAE: %s", e);
            return false;
        }
    }

    @VisibleForTesting
    TelephonyHelper.SimCardInformation getSimInfo(ITestDevice device) throws DeviceNotAvailableException {
        return TelephonyHelper.getSimInfo(device);
    }

    private List<String> getOptionalDualSimProperty(ITestDevice device, String property) throws DeviceNotAvailableException {
        String propRes = device.getProperty(property);
        LogUtil.CLog.d("queried sim property: '%s'. result: '%s'", property, propRes);
        if (Strings.isNullOrEmpty(propRes)) {
            return new ArrayList<String>();
        }
        String[] splitProp = propRes.split(",");
        ArrayList<String> results = new ArrayList<String>();
        for (String p : splitProp) {
            results.add(p);
        }
        return results;
    }
}

