/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.tracing;

import com.android.ddmlib.Log;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import perfetto.internal.protos.PerfettoTrace;

public class ActiveTrace {
    public static final String TRACE_KEY = "invocation-trace";
    private final long pid;
    private final long tid;
    private final long traceUuid;
    private final int uid = 5555;
    private final boolean mainTradefedProcess;
    private final Map<String, Long> mThreadToTracker;
    private File mTraceOutput;

    public ActiveTrace(long pid, long tid) {
        this(pid, tid, false);
    }

    public ActiveTrace(long pid, long tid, boolean mainProcess) {
        this.pid = pid;
        this.tid = tid;
        this.traceUuid = UUID.randomUUID().getMostSignificantBits() & Long.MAX_VALUE;
        this.mThreadToTracker = new HashMap<String, Long>();
        this.mainTradefedProcess = mainProcess;
    }

    public void startTracing(boolean isSubprocess) {
        if (this.mTraceOutput != null) {
            throw new IllegalStateException("Tracing was already started.");
        }
        try {
            this.mTraceOutput = FileUtil.createTempFile(TRACE_KEY, ".perfetto-trace");
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        this.createMainInvocationTracker((int)this.pid, (int)this.tid, this.traceUuid, isSubprocess);
    }

    /*
     * Loose catch block
     */
    public void addSubprocessTrace(File subTrace) {
        FileInputStream stream;
        if (this.mTraceOutput == null) {
            return;
        }
        try {
            stream = new FileInputStream(subTrace);
            GZIPInputStream gzip = new GZIPInputStream(stream);
            LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "merging with gzipped %s", subTrace);
            FileUtil.writeToFile(gzip, this.mTraceOutput, true);
            gzip.close();
            stream.close();
            return;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                gzip.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "%s isn't gzip.", subTrace);
                            stream.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        try {
            stream = new FileInputStream(subTrace);
            try {
                FileUtil.writeToFile(stream, this.mTraceOutput, true);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    public void reportTraceEvent(String categories, String name, PerfettoTrace.TrackEvent.Type type) {
        this.reportTraceEvent(categories, name, (int)this.tid, null, type);
    }

    public long reportingThreadId() {
        return this.tid;
    }

    public boolean isMainTradefedProcess() {
        return this.mainTradefedProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportTraceEvent(String categories, String name, int threadId, String threadName, PerfettoTrace.TrackEvent.Type type) {
        long traceIdentifier = this.traceUuid;
        if ((long)threadId != this.tid) {
            Map<String, Long> map = this.mThreadToTracker;
            synchronized (map) {
                if (this.mThreadToTracker.containsKey(Integer.toString(threadId))) {
                    Long returnedValue = this.mThreadToTracker.get(Integer.toString(threadId));
                    if (returnedValue == null) {
                        LogUtil.CLog.e("Consistency error in trace identifier.");
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.TRACE_INTERNAL_ERROR, 1L);
                        return;
                    }
                    traceIdentifier = returnedValue;
                } else {
                    traceIdentifier = UUID.randomUUID().getMostSignificantBits() & Long.MAX_VALUE;
                    this.createThreadTracker((int)this.pid, threadId, threadName, traceIdentifier);
                    this.mThreadToTracker.put(Integer.toString(threadId), traceIdentifier);
                }
            }
        }
        PerfettoTrace.TracePacket.Builder tracePacket = PerfettoTrace.TracePacket.newBuilder().setTrustedUid(5555).setTrustedPid((int)this.pid).setTimestamp(System.nanoTime()).setTrustedPacketSequenceId(1).setSequenceFlags(1).setProcessDescriptor(PerfettoTrace.ProcessDescriptor.newBuilder().setPid((int)this.pid)).setThreadDescriptor(PerfettoTrace.ThreadDescriptor.newBuilder().setTid(threadId)).setTrackEvent(PerfettoTrace.TrackEvent.newBuilder().setTrackUuid(traceIdentifier).setName(name).setType(type).addCategories(categories).addDebugAnnotations(PerfettoTrace.DebugAnnotation.newBuilder().setName(name)));
        this.writeToTrace(tracePacket.build());
    }

    public File finalizeTracing() {
        LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "Finalizing trace: %s", this.mTraceOutput);
        File trace = this.mTraceOutput;
        this.mTraceOutput = null;
        return trace;
    }

    private String createProcessName(boolean isSubprocess) {
        if (isSubprocess) {
            return "subprocess-test-invocation";
        }
        if (this.isMainTradefedProcess()) {
            return "Tradefed";
        }
        return "test-invocation";
    }

    private void createMainInvocationTracker(int pid, int tid, long traceUuid, boolean isSubprocess) {
        PerfettoTrace.TrackDescriptor.Builder descriptor = PerfettoTrace.TrackDescriptor.newBuilder().setUuid(traceUuid).setName(this.createProcessName(isSubprocess)).setThread(PerfettoTrace.ThreadDescriptor.newBuilder().setTid(tid).setThreadName("invocation-thread").setPid(pid)).setProcess(PerfettoTrace.ProcessDescriptor.newBuilder().setPid(pid).setProcessName(this.createProcessName(isSubprocess)));
        PerfettoTrace.TracePacket.Builder traceTrackDescriptor = PerfettoTrace.TracePacket.newBuilder().setTrustedUid(5555).setTimestamp(System.nanoTime()).setTrustedPacketSequenceId(1).setSequenceFlags(1).setTrustedPid(pid).setTrackDescriptor(descriptor.build());
        this.writeToTrace(traceTrackDescriptor.build());
    }

    private void createThreadTracker(int pid, int tid, String threadName, long traceUuid) {
        PerfettoTrace.TrackDescriptor.Builder descriptor = PerfettoTrace.TrackDescriptor.newBuilder().setUuid(traceUuid).setThread(PerfettoTrace.ThreadDescriptor.newBuilder().setTid(tid).setThreadName(threadName).setPid(pid));
        PerfettoTrace.TracePacket.Builder traceTrackDescriptor = PerfettoTrace.TracePacket.newBuilder().setTrustedUid(5555).setTimestamp(System.nanoTime()).setTrustedPacketSequenceId(1).setSequenceFlags(1).setTrustedPid(pid).setTrackDescriptor(descriptor.build());
        this.writeToTrace(traceTrackDescriptor.build());
    }

    private synchronized void writeToTrace(PerfettoTrace.TracePacket packet) {
        if (this.mTraceOutput == null) {
            return;
        }
        PerfettoTrace.Trace wrappingTrace = PerfettoTrace.Trace.newBuilder().addPacket(packet).build();
        try (FileOutputStream out = new FileOutputStream(this.mTraceOutput, true);){
            wrappingTrace.writeTo(out);
            out.flush();
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to write execution trace to file.");
            LogUtil.CLog.e(e);
        }
    }
}

