/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.tracing;

import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.ActiveTrace;
import com.android.tradefed.invoker.tracing.TracingLogger;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import javax.annotation.Nullable;
import perfetto.internal.protos.PerfettoTrace;

public class CloseableTraceScope
implements AutoCloseable {
    private static final String DEFAULT_CATEGORY = "invocation";
    private final String category;
    private final String name;
    private final long startTime;
    @Nullable
    private final ActiveTrace trace;

    public CloseableTraceScope(String category, String name) {
        this(TracingLogger.getActiveTrace(), category, name);
    }

    public CloseableTraceScope(String name) {
        this(DEFAULT_CATEGORY, name);
    }

    public CloseableTraceScope(ActiveTrace trace, String name) {
        this(trace, DEFAULT_CATEGORY, name);
    }

    public CloseableTraceScope() {
        this(DEFAULT_CATEGORY, Thread.currentThread().getName());
    }

    private CloseableTraceScope(ActiveTrace trace, String category, String name) {
        this.category = category;
        this.name = name;
        this.startTime = System.currentTimeMillis();
        this.trace = trace;
        if (this.trace == null) {
            return;
        }
        int threadId = (int)Thread.currentThread().getId();
        String threadName = Thread.currentThread().getName();
        this.trace.reportTraceEvent(category, name, threadId, threadName, PerfettoTrace.TrackEvent.Type.TYPE_SLICE_BEGIN);
    }

    @Override
    public void close() {
        if (this.trace == null) {
            return;
        }
        int threadId = (int)Thread.currentThread().getId();
        String threadName = Thread.currentThread().getName();
        this.trace.reportTraceEvent(this.category, this.name, threadId, threadName, PerfettoTrace.TrackEvent.Type.TYPE_SLICE_END);
        Optional<InvocationMetricLogger.InvocationMetricKey> optionalKey = Enums.getIfPresent(InvocationMetricLogger.InvocationMetricKey.class, this.name);
        if (optionalKey.isPresent() && Thread.currentThread().getId() == this.trace.reportingThreadId()) {
            InvocationMetricLogger.addInvocationPairMetrics(optionalKey.get(), this.startTime, System.currentTimeMillis());
        }
    }
}

