/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker.tracing;

import com.android.tradefed.invoker.tracing.ActiveTrace;
import com.android.tradefed.invoker.tracing.TracingLogger;
import com.android.tradefed.log.LogUtil;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public final class TracePropagatingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;

    public static TracePropagatingExecutorService create(ExecutorService delegate2) {
        return new TracePropagatingExecutorService(delegate2);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.wrapTask(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.wrapTask(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.wrapTask(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapTasks(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapTasks(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapTasks(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapTasks(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.wrapTask(command));
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    private TracePropagatingExecutorService(ExecutorService delegate2) {
        this.delegate = Objects.requireNonNull(delegate2);
    }

    private <T> Callable<T> wrapTask(Callable<T> task) {
        ActiveTrace rootTrace = TracingLogger.getActiveTrace();
        return () -> {
            try (TraceScope ignored = TracePropagatingExecutorService.makeActive(rootTrace);){
                Object v = task.call();
                return v;
            }
        };
    }

    private Runnable wrapTask(Runnable command) {
        Callable<Object> wrapped = this.wrapTask(Executors.callable(command));
        return () -> {
            try {
                wrapped.call();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new AssertionError((Object)e);
            }
        };
    }

    protected <T> Collection<? extends Callable<T>> wrapTasks(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> wrapped = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            wrapped.add(this.wrapTask(task));
        }
        return wrapped;
    }

    private static TraceScope makeActive(@Nullable ActiveTrace toAttach) {
        ActiveTrace toRestore = TracePropagatingExecutorService.setActiveTraceIfChanged(toAttach);
        return () -> {
            if (TracePropagatingExecutorService.setActiveTraceIfChanged(toRestore) != toAttach) {
                LogUtil.CLog.w("Unexpected active trace, close was not correctly called");
            }
        };
    }

    @Nullable
    private static ActiveTrace setActiveTraceIfChanged(@Nullable ActiveTrace toAttach) {
        ActiveTrace toRestore = TracingLogger.getActiveTrace();
        if (toAttach != toRestore) {
            TracingLogger.setActiveTrace(toAttach);
        }
        return toRestore;
    }

    static interface TraceScope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

