/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.lite;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.Suite;

public final class HostUtils {
    private HostUtils() {
    }

    public static final List<Class<?>> getJUnitClasses(Set<String> classNames, Set<String> jarAbsPaths, List<String> excludePaths, ClassLoader pcl) throws IllegalArgumentException {
        HashSet<String> outputNames = new HashSet<String>();
        ArrayList output = new ArrayList();
        for (String className2 : classNames) {
            if (outputNames.contains(className2)) continue;
            try {
                Class<?> klass = Class.forName(className2, true, pcl);
                outputNames.add(className2);
                output.add(klass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Could not load Test class %s", className2), e);
            }
        }
        for (String jarName : jarAbsPaths) {
            ZipFile jarFile = null;
            try {
                File file2 = new File(jarName);
                jarFile = new JarFile(file2);
                Stream<JarEntry> s = ((JarFile)jarFile).stream();
                URL[] urls = new URL[]{new URL(String.format("jar:file:%s!/", file2.getAbsolutePath()))};
                URLClassLoader cl = URLClassLoader.newInstance(urls);
                s = s.filter(je -> !je.isDirectory() && je.getName().endsWith(".class") && !je.getName().contains("$") && !outputNames.contains(HostUtils.getClassName(je.getName())));
                if (!excludePaths.isEmpty()) {
                    s = s.filter(je -> excludePaths.stream().noneMatch(path -> je.getName().startsWith((String)path)));
                }
                s.map(je -> HostUtils.getClassName(je.getName())).filter(className -> HostUtils.testLoadClass(className, cl, jarName)).peek(className -> outputNames.add((String)className)).map(className -> {
                    try {
                        return cl.loadClass((String)className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(String.format("Cannot find test class %s", className));
                    }
                }).sorted(Comparator.comparing(c -> c.getProtectionDomain().getCodeSource().getLocation().toString())).forEachOrdered(cls -> output.add((Class<?>)cls));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                try {
                    if (jarFile == null) continue;
                    jarFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Something went wrong closing the jarfile: " + jarName, new Object[0]));
                }
            }
        }
        return output;
    }

    public static final List<Class<?>> getJUnitClasses(Set<String> classNames, Set<String> jarAbsPaths, ClassLoader pcl) throws IllegalArgumentException {
        return HostUtils.getJUnitClasses(classNames, jarAbsPaths, new ArrayList<String>(), pcl);
    }

    public static boolean testLoadClass(String className, URLClassLoader cl, String jarName) throws IllegalArgumentException {
        try {
            Class<?> cls = cl.loadClass(className);
            int modifiers = cls.getModifiers();
            if (!(!HostUtils.hasJUnitAnnotation(cls) || Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers) || Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers))) {
                return true;
            }
        }
        catch (UnsupportedClassVersionError ucve) {
            throw new IllegalArgumentException(String.format("Could not load class %s from jar %s. Reason:\n%s", className, jarName, ucve.toString()));
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(String.format("Cannot find test class %s", className), cnfe);
        }
        catch (IllegalAccessError | NoClassDefFoundError err) {
            return false;
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(String.format("Tried to load %s from jar %s , but failed", className, jarName), e);
        }
        return false;
    }

    public static boolean hasJUnitAnnotation(Class<?> classObj) {
        if (classObj.isAnnotationPresent(RunWith.class) && Runner.class.isAssignableFrom(classObj.getAnnotation(RunWith.class).value())) {
            for (Method m2 : classObj.getMethods()) {
                if (!m2.isAnnotationPresent(Test.class)) continue;
                return true;
            }
        } else if (!classObj.isAnnotationPresent(RunWith.class)) {
            if (classObj.isAnnotationPresent(Suite.SuiteClasses.class)) {
                return true;
            }
            for (Method m3 : classObj.getMethods()) {
                if (!m3.isAnnotationPresent(Test.class)) continue;
                return true;
            }
            if (TestCase.class.isAssignableFrom(classObj)) {
                return Arrays.asList(classObj.getDeclaredMethods()).stream().anyMatch(m -> m.getName().startsWith("test") && Arrays.asList(m.getAnnotations()).stream().map(anno -> anno.toString()).noneMatch(s -> s.contains("Suppress")));
            }
        }
        return false;
    }

    private static String getClassName(String name) {
        return name.substring(0, name.length() - 6).replace('/', '.');
    }
}

