/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseLeveledLogOutput
implements ILeveledLogOutput {
    @Option(name="include-log-tag", description="List of tags that should be included in the display")
    private Set<String> mIncludeTag = new HashSet<String>();
    @Option(name="class-verbosity", description="Sets the verbosity of a particular class tag. For example: StubTest INFO.")
    private Map<String, Log.LogLevel> mClassVerbosity = new HashMap<String, Log.LogLevel>();
    @Option(name="component-verbosity", description="Sets the verbosity of a group of Tradefed components.For example: target_preparer WARN.")
    private Map<String, Log.LogLevel> mComponentVerbosity = new HashMap<String, Log.LogLevel>();
    @Option(name="force-verbosity-map", description="Enforce a pre-set verbosity of some component to avoid extreme logging.")
    private boolean mEnableForcedVerbosity = true;
    private Map<String, Log.LogLevel> mForcedVerbosity = ImmutableMap.of("ddms", Log.LogLevel.WARN);
    private Map<String, Log.LogLevel> mVerbosityMap = new HashMap<String, Log.LogLevel>();

    public final void initFilters(IConfiguration config) {
        this.initComponentVerbosity(this.mComponentVerbosity, this.mVerbosityMap, config);
        this.mVerbosityMap.putAll(this.mClassVerbosity);
    }

    public final boolean shouldDisplay(boolean forceStdout, Log.LogLevel invocationLogLevel, Log.LogLevel messageLogLevel, String tag) {
        if (forceStdout) {
            return true;
        }
        return this.mVerbosityMap.get(tag) != null ? messageLogLevel.getPriority() >= this.mVerbosityMap.get(tag).getPriority() : messageLogLevel.getPriority() >= invocationLogLevel.getPriority();
    }

    private void initComponentVerbosity(Map<String, Log.LogLevel> components, Map<String, Log.LogLevel> receiver, IConfiguration config) {
        for (String component : components.keySet()) {
            Collection<Object> objs = config.getAllConfigurationObjectsOfType(component);
            if (objs == null) continue;
            for (Object o : objs) {
                String objTag = LogUtil.CLog.parseClassName(o.getClass().getName());
                receiver.put(objTag, components.get(component));
            }
        }
        if (this.shouldForceVerbosity()) {
            this.mVerbosityMap.putAll(this.mForcedVerbosity);
        }
    }

    @Override
    public abstract ILeveledLogOutput clone();

    public boolean shouldForceVerbosity() {
        return this.mEnableForcedVerbosity;
    }

    public Map<String, Log.LogLevel> getForcedVerbosityMap() {
        return this.mForcedVerbosity;
    }
}

