/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.BaseLeveledLogOutput;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BaseStreamLogger<OS extends OutputStream>
extends BaseLeveledLogOutput {
    @Option(name="log-level", description="the minimum log level to log.")
    private Log.LogLevel mLogLevel = Log.LogLevel.DEBUG;
    @Option(name="log-level-display", shortName=108, description="the minimum log level to display on stdout.", importance=Option.Importance.ALWAYS)
    private Log.LogLevel mLogLevelDisplay = Log.LogLevel.ERROR;
    protected OS mOutputStream;

    @Override
    public Log.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    @Override
    public void setLogLevel(Log.LogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    public void setLogLevelDisplay(Log.LogLevel logLevel) {
        this.mLogLevelDisplay = logLevel;
    }

    public Log.LogLevel getLogLevelDisplay() {
        return this.mLogLevelDisplay;
    }

    @Override
    public void closeLog() {
        StreamUtil.flushAndCloseStream(this.mOutputStream);
        this.mOutputStream = null;
    }

    @Override
    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message2) {
        this.internalPrintLog(logLevel, tag, message2, true);
    }

    @Override
    public void printLog(Log.LogLevel logLevel, String tag, String message2) {
        this.internalPrintLog(logLevel, tag, message2, false);
    }

    private void internalPrintLog(Log.LogLevel logLevel, String tag, String message2, boolean forceStdout) {
        String outMessage = LogUtil.getLogFormatString(logLevel, tag, message2);
        if (this.shouldDisplay(forceStdout, this.mLogLevelDisplay, logLevel, tag)) {
            System.out.print(outMessage);
        }
        if (this.shouldWrite(tag, logLevel, this.mLogLevel)) {
            try {
                this.writeToLog(outMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean shouldWrite(String tag, Log.LogLevel messageLogLevel, Log.LogLevel invocationLogLevel) {
        Log.LogLevel forcedLevel = this.getForcedVerbosityMap().get(tag);
        if (forcedLevel == null || !this.shouldForceVerbosity()) {
            return true;
        }
        int minWriteLevel = Math.max(forcedLevel.getPriority(), invocationLogLevel.getPriority());
        return messageLogLevel.getPriority() >= minWriteLevel;
    }

    protected void writeToLog(String message2) throws IOException {
        if (this.mOutputStream != null) {
            ((OutputStream)this.mOutputStream).write(message2.getBytes());
        }
    }
}

