/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.log.BaseStreamLogger;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.util.SizeLimitedOutputStream;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;

@OptionClass(alias="file")
public class FileLogger
extends BaseStreamLogger<SizeLimitedOutputStream> {
    private static final String TEMP_FILE_PREFIX = "tradefed_log_";
    private static final String TEMP_FILE_SUFFIX = ".txt";
    @Option(name="max-log-size", description="maximum allowable size of tmp log data in mB.")
    private long mMaxLogSizeMbytes = 20L;

    @Override
    public void init() throws IOException {
        this.init(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
    }

    protected void init(String logPrefix, String fileSuffix) {
        this.mOutputStream = new SizeLimitedOutputStream(this.mMaxLogSizeMbytes * 1024L * 1024L, logPrefix, fileSuffix);
    }

    @Override
    public ILeveledLogOutput clone() {
        FileLogger logger = new FileLogger();
        OptionCopier.copyOptionsNoThrow(this, logger);
        return logger;
    }

    public long getMaxLogSizeMbytes() {
        return this.mMaxLogSizeMbytes;
    }

    @Override
    public InputStreamSource getLog() {
        if (this.mOutputStream != null) {
            try {
                ((SizeLimitedOutputStream)this.mOutputStream).flush();
                return new SnapshotInputStreamSource("FileLogger", ((SizeLimitedOutputStream)this.mOutputStream).getData());
            }
            catch (IOException e) {
                System.err.println("Failed to get log");
                e.printStackTrace();
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    @Override
    public void closeLog() {
        this.doCloseLog();
    }

    @VisibleForTesting
    void doCloseLog() {
        SizeLimitedOutputStream stream = (SizeLimitedOutputStream)this.mOutputStream;
        this.mOutputStream = null;
        StreamUtil.flushAndCloseStream(stream);
        if (stream != null) {
            stream.delete();
        }
    }

    void dumpToLog(InputStream inputStream) throws IOException {
        if (this.mOutputStream != null) {
            StreamUtil.copyStreams(inputStream, this.mOutputStream);
        }
    }
}

