/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.log.FileLogger;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.ILogRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class HistoryLogger
extends FileLogger {
    private static final String TEMP_FILE_PREFIX = "tradefed_history_log_";
    private static final String TEMP_FILE_SUFFIX = ".txt";

    @Override
    public void init() throws IOException {
        this.init(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
    }

    @Override
    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message2) {
        throw new UnsupportedOperationException("printAndPromptLog is not supported by HistoryLogger");
    }

    @Override
    public void printLog(Log.LogLevel logLevel, String tag, String message2) {
        throw new UnsupportedOperationException("printLog is not supported by HistoryLogger");
    }

    public void logEvent(Log.LogLevel logLevel, ILogRegistry.EventType event, Map<String, String> args) {
        StringBuilder message2 = new StringBuilder();
        message2.append((Object)event);
        message2.append(": ");
        if (args == null) {
            args = new HashMap<String, String>();
        }
        JSONObject formattedArgs = new JSONObject(args);
        message2.append(formattedArgs.toString());
        message2.append("\n");
        this.internalPrintLog(logLevel, message2.toString());
    }

    private void internalPrintLog(Log.LogLevel logLevel, String message2) {
        if (logLevel.getPriority() >= this.getLogLevelDisplay().getPriority()) {
            System.out.print(message2);
        }
        try {
            this.writeToLog(message2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ILeveledLogOutput clone() {
        HistoryLogger logger = new HistoryLogger();
        OptionCopier.copyOptionsNoThrow(this, logger);
        return logger;
    }
}

