/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.tradefed.device.BackgroundDeviceAction;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LargeOutputReceiver;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.StreamUtil;

public class LogReceiver {
    private BackgroundDeviceAction mDeviceAction;
    private LargeOutputReceiver mReceiver;
    private String mDesc;
    private static final int DELAY = 5;
    private static final int LOG_SIZE = 0x1400000;

    public LogReceiver(ITestDevice device, String cmd, String desc) {
        this(device, cmd, 0x1400000L, 5, desc);
    }

    public LogReceiver(ITestDevice device, String cmd, String desc, long logcat_size, int delay_secs) {
        this(device, cmd, logcat_size, delay_secs, desc);
    }

    private LogReceiver(ITestDevice device, String cmd, long maxFileSize, int logStartDelay, String desc) {
        this.mReceiver = new LargeOutputReceiver(desc, device.getSerialNumber(), maxFileSize);
        this.mDeviceAction = new BackgroundDeviceAction(cmd, desc, device, this.mReceiver, logStartDelay);
        this.mDesc = desc;
    }

    public String getDescriptor() {
        return this.mDesc;
    }

    public void start() {
        this.mDeviceAction.start();
    }

    public void stop() {
        this.mDeviceAction.cancel();
        this.mReceiver.cancel();
        this.mReceiver.delete();
    }

    public InputStreamSource getData() {
        return this.mReceiver.getData();
    }

    public InputStreamSource getLogcatData(int maxBytes) {
        return this.mReceiver.getData(maxBytes);
    }

    public void clear() {
        this.mReceiver.clear();
    }

    public void postLog(ITestInvocationListener listener) {
        InputStreamSource stream = this.getData();
        try {
            listener.testLog(this.getDescriptor(), LogDataType.TEXT, this.getData());
        }
        finally {
            StreamUtil.cancel(stream);
        }
    }
}

