/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.log.FileLogger;
import com.android.tradefed.log.HistoryLogger;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class LogRegistry
implements ILogRegistry {
    private static final String GLOBAL_LOG_PATH = "GLOBAL_LOG_PATH";
    private static final String LOG_TAG = "LogRegistry";
    private static final String GLOBAL_LOG_PREFIX = "tradefed_global_log_";
    private static final String HISTORY_LOG_PREFIX = "tradefed_history_log_";
    private static LogRegistry mLogRegistry = null;
    private Map<ThreadGroup, ILeveledLogOutput> mLogTable = new Hashtable<ThreadGroup, ILeveledLogOutput>();
    private FileLogger mGlobalLogger;
    private HistoryLogger mHistoryLogger;

    LogRegistry() {
        try {
            this.mGlobalLogger = new FileLogger();
            this.mGlobalLogger.init();
        }
        catch (IOException e) {
            System.err.println("Failed to create global logger");
            throw new IllegalStateException(e);
        }
        try {
            this.mHistoryLogger = new HistoryLogger();
            this.mHistoryLogger.init();
        }
        catch (IOException e) {
            System.err.println("Failed to create history logger");
            throw new IllegalStateException(e);
        }
    }

    public static ILogRegistry getLogRegistry() {
        if (mLogRegistry == null) {
            mLogRegistry = new LogRegistry();
        }
        return mLogRegistry;
    }

    @Override
    public void setGlobalLogDisplayLevel(Log.LogLevel logLevel) {
        this.mGlobalLogger.setLogLevelDisplay(logLevel);
        this.mHistoryLogger.setLogLevel(logLevel);
    }

    @Override
    public Log.LogLevel getGlobalLogDisplayLevel() {
        return this.mGlobalLogger.getLogLevelDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLogger(ILeveledLogOutput log) {
        Map<ThreadGroup, ILeveledLogOutput> map = this.mLogTable;
        synchronized (map) {
            ILeveledLogOutput oldValue = this.mLogTable.put(this.getCurrentThreadGroup(), log);
            if (oldValue != null) {
                Log.e(LOG_TAG, "Registering a new logger when one already exists for this thread!");
                oldValue.closeLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLogger() {
        ThreadGroup currentThreadGroup = this.getCurrentThreadGroup();
        if (currentThreadGroup != null) {
            Map<ThreadGroup, ILeveledLogOutput> map = this.mLogTable;
            synchronized (map) {
                this.mLogTable.remove(currentThreadGroup);
            }
        } else {
            this.printLog(Log.LogLevel.ERROR, LOG_TAG, "Unregistering when thread has no logger registered.");
        }
    }

    @Override
    public void dumpToGlobalLog(ILeveledLogOutput log) {
        block14: {
            try (InputStreamSource source = log.getLog();){
                if (source == null) break block14;
                try (InputStream stream = source.createInputStream();){
                    this.mGlobalLogger.dumpToLog(stream);
                }
            }
            catch (IOException | RuntimeException e) {
                System.err.println("Failed to dump log");
                e.printStackTrace();
            }
        }
    }

    ThreadGroup getCurrentThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    @Override
    public void printLog(Log.LogLevel logLevel, String tag, String message2) {
        ILeveledLogOutput log = this.getLogger();
        Log.LogLevel currentLogLevel = log.getLogLevel();
        if (logLevel.getPriority() >= currentLogLevel.getPriority()) {
            log.printLog(logLevel, tag, message2);
        }
    }

    @Override
    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message2) {
        this.getLogger().printAndPromptLog(logLevel, tag, message2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILeveledLogOutput getLogger() {
        Map<ThreadGroup, ILeveledLogOutput> map = this.mLogTable;
        synchronized (map) {
            ILeveledLogOutput log = this.mLogTable.get(this.getCurrentThreadGroup());
            if (log == null) {
                log = this.mGlobalLogger;
            }
            return log;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAndRemoveAllLogs() {
        Map<ThreadGroup, ILeveledLogOutput> map = this.mLogTable;
        synchronized (map) {
            Collection<ILeveledLogOutput> allLogs = this.mLogTable.values();
            Iterator<ILeveledLogOutput> iter = allLogs.iterator();
            while (iter.hasNext()) {
                ILeveledLogOutput log = iter.next();
                log.closeLog();
                iter.remove();
            }
        }
        this.saveGlobalLog();
        this.mGlobalLogger.closeLog();
        this.mHistoryLogger.closeLog();
    }

    @Override
    public void saveGlobalLog() {
        File logDir = null;
        if (System.getenv(GLOBAL_LOG_PATH) != null && !(logDir = new File(System.getenv(GLOBAL_LOG_PATH))).exists()) {
            logDir = null;
        }
        this.saveGlobalLogToDir(logDir);
    }

    @Override
    public void logEvent(Log.LogLevel logLevel, ILogRegistry.EventType event, Map<String, String> args) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        args.put("time", sdfDate.format(new Date()));
        this.mHistoryLogger.logEvent(logLevel, event, args);
    }

    private void saveGlobalLogToDir(File dir) {
        try (InputStreamSource globalLog = this.mGlobalLogger.getLog();){
            this.saveLog(GLOBAL_LOG_PREFIX, globalLog, dir);
        }
    }

    private void saveHistoryLogToDir(File dir) {
        try (InputStreamSource globalLog = this.mHistoryLogger.getLog();){
            this.saveLog(HISTORY_LOG_PREFIX, globalLog, dir);
        }
    }

    private void saveLog(String filePrefix, InputStreamSource logData, File parentdir) {
        try {
            File tradefedLog = FileUtil.createTempFile(filePrefix, ".txt", parentdir);
            FileUtil.writeToFile(logData.createInputStream(), tradefedLog);
            String message2 = LogUtil.getLogFormatString(Log.LogLevel.VERBOSE, this.getClass().getSimpleName(), String.format("Saved log to %s", tradefedLog.getAbsolutePath()));
            System.out.println(message2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void dumpLogs() {
        this.dumpLogsToDir(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLogsToDir(File dir) {
        Map<ThreadGroup, ILeveledLogOutput> map = this.mLogTable;
        synchronized (map) {
            for (Map.Entry<ThreadGroup, ILeveledLogOutput> logEntry : this.mLogTable.entrySet()) {
                String filePrefix = String.format("%s_log_", logEntry.getKey().getName());
                InputStreamSource logSource = logEntry.getValue().getLog();
                try {
                    this.saveLog(filePrefix, logSource, dir);
                }
                finally {
                    if (logSource == null) continue;
                    logSource.close();
                }
            }
        }
        this.saveHistoryLogToDir(dir);
        this.saveGlobalLogToDir(dir);
    }
}

