/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogUtil {
    private LogUtil() {
    }

    public static void printLog(Log.LogLevel logLevel, String tag, String message2) {
        System.out.print(LogUtil.getLogFormatString(logLevel, tag, message2));
    }

    public static String getLogFormatString(Log.LogLevel logLevel, String tag, String message2) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
        return String.format("%s %c/%s: %s\n", formatter.format(new Date()), Character.valueOf(logLevel.getPriorityLetter()), tag, message2);
    }

    public static class CLog {
        protected static final String CLASS_NAME = CLog.class.getName();

        public static void v(String message2) {
            Log.v(CLog.getClassName(2), message2);
        }

        public static void v(String format, Object ... args) {
            Log.v(CLog.getClassName(2), String.format(format, args));
        }

        public static void d(String message2) {
            Log.d(CLog.getClassName(2), message2);
        }

        public static void d(String format, Object ... args) {
            Log.d(CLog.getClassName(2), String.format(format, args));
        }

        public static void i(String message2) {
            Log.i(CLog.getClassName(2), message2);
        }

        public static void i(String format, Object ... args) {
            Log.i(CLog.getClassName(2), String.format(format, args));
        }

        public static void w(String message2) {
            Log.w(CLog.getClassName(2), message2);
        }

        public static void w(Throwable t) {
            Log.w(CLog.getClassName(2), CLog.getStackTraceString(t));
        }

        public static void w(String format, Object ... args) {
            Log.w(CLog.getClassName(2), String.format(format, args));
        }

        public static void e(String message2) {
            Log.e(CLog.getClassName(2), message2);
        }

        public static void e(String format, Object ... args) {
            Log.e(CLog.getClassName(2), String.format(format, args));
        }

        public static void e(Throwable t) {
            Log.e(CLog.getClassName(2), t);
        }

        public static void logAndDisplay(Log.LogLevel logLevel, String message2) {
            Log.logAndDisplay(logLevel, CLog.getClassName(2), message2);
        }

        public static void logAndDisplay(Log.LogLevel logLevel, String format, Object ... args) {
            Log.logAndDisplay(logLevel, CLog.getClassName(2), String.format(format, args));
        }

        public static void wtf(String message2) {
            CLog.wtf(message2, null);
        }

        public static void wtf(Throwable t) {
            CLog.wtf(t.getMessage(), t);
        }

        public static void wtf(String format, Object ... args) {
            CLog.wtf(String.format(format, args), null);
        }

        public static void wtf(String message2, Throwable t) {
            String tag = CLog.findCallerClassName();
            String logMessage = "WTF - " + message2;
            String stackTrace = CLog.getStackTraceString(t);
            if (stackTrace.length() > 0) {
                logMessage = logMessage + "\n" + stackTrace;
            }
            Log.logAndDisplay(Log.LogLevel.ASSERT, tag, logMessage);
        }

        private static String getStackTraceString(Throwable t) {
            if (t == null) {
                return "";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }

        public static String getClassName(int frame) {
            StackTraceElement[] frames = new Throwable().getStackTrace();
            return CLog.parseClassName(frames[frame].getClassName());
        }

        public static String findCallerClassName() {
            return CLog.findCallerClassName(null);
        }

        public static String findCallerClassName(Throwable t) {
            StackTraceElement[] frames;
            String className = "Unknown";
            if (t == null) {
                t = new Throwable();
            }
            if ((frames = t.getStackTrace()).length == 0) {
                return className;
            }
            for (int f = 0; f < frames.length && (className = frames[f].getClassName()).equals(CLASS_NAME); ++f) {
            }
            return CLog.parseClassName(className);
        }

        public static String parseClassName(String fullName) {
            int lastdollar;
            int lastdot = fullName.lastIndexOf(46);
            String simpleName = fullName;
            if (lastdot != -1) {
                simpleName = fullName.substring(lastdot + 1);
            }
            if ((lastdollar = simpleName.lastIndexOf(36)) != -1) {
                simpleName = simpleName.substring(0, lastdollar);
            }
            return simpleName;
        }
    }
}

