/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.log.BaseStreamLogger;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

@OptionClass(alias="simple-file")
public class SimpleFileLogger
extends BaseStreamLogger<FileOutputStream> {
    @Option(name="path", description="File path to log to.", mandatory=true)
    private File mFile;

    @Override
    public void init() throws IOException {
        this.mFile.getParentFile().mkdirs();
        this.mOutputStream = new FileOutputStream(this.mFile, true);
    }

    @Override
    public InputStreamSource getLog() {
        if (this.mFile != null) {
            return new FileInputStreamSource(this.mFile);
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    @Override
    public SimpleFileLogger clone() {
        SimpleFileLogger logger = new SimpleFileLogger();
        OptionCopier.copyOptionsNoThrow(this, logger);
        return logger;
    }
}

