/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.ITerribleFailureHandler;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.Email;
import com.android.tradefed.util.IEmail;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

@OptionClass(alias="wtf-email-handler")
public class TerribleFailureEmailHandler
implements ITerribleFailureHandler {
    private static final String DEFAULT_SUBJECT_PREFIX = "WTF happened to tradefed";
    @Option(name="sender", description="The envelope-sender address to use for the messages.", importance=Option.Importance.IF_UNSET)
    private String mSender = null;
    @Option(name="destination", description="One or more destination addresses.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mDestinations = new LinkedHashSet<String>();
    @Option(name="subject-prefix", description="The prefix to be added to the beginning of the email subject.")
    private String mSubjectPrefix = "WTF happened to tradefed";
    @Option(name="min-email-interval", description="The minimum interval between emails in ms. If a new WTF happens within this interval from the previous one, it will be ignored.")
    private long mMinEmailInterval = 300000L;
    private IEmail mMailer;
    private long mLastEmailSentTime = 0L;

    public TerribleFailureEmailHandler() {
        this(new Email());
    }

    protected TerribleFailureEmailHandler(IEmail mailer) {
        this.mMailer = mailer;
    }

    public void addDestination(String dest) {
        this.mDestinations.add(dest);
    }

    public void setSender(String sender) {
        this.mSender = sender;
    }

    public void setMinEmailInterval(long interval) {
        this.mMinEmailInterval = interval;
    }

    protected String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LogUtil.CLog.e(e);
            return "unknown host";
        }
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected String generateEmailSubject() {
        StringBuilder subj = new StringBuilder();
        subj.append(this.mSubjectPrefix);
        subj.append(" on ");
        subj.append(this.getLocalHostName());
        return subj.toString();
    }

    protected String generateEmailBody(String message2, Throwable cause) {
        StringBuilder bodyBuilder = new StringBuilder();
        bodyBuilder.append("host: ");
        bodyBuilder.append(this.getLocalHostName());
        bodyBuilder.append("\n\n");
        bodyBuilder.append("What a Terrible Failure!  ");
        bodyBuilder.append(message2);
        bodyBuilder.append("\n\n");
        if (cause != null) {
            bodyBuilder.append("Invocation failed: ");
            bodyBuilder.append(TerribleFailureEmailHandler.getStackTraceString(cause));
            bodyBuilder.append("\n\n");
        }
        return bodyBuilder.toString();
    }

    protected IEmail.Message generateEmailMessage(String description, Throwable cause) {
        IEmail.Message msg = new IEmail.Message();
        msg.setSender(this.mSender);
        msg.setSubject(this.generateEmailSubject());
        msg.setBody(this.generateEmailBody(description, cause));
        msg.setHtml(false);
        Iterator<String> toAddress = this.mDestinations.iterator();
        while (toAddress.hasNext()) {
            msg.addTo(toAddress.next());
        }
        return msg;
    }

    @Override
    public boolean onTerribleFailure(String description, Throwable cause) {
        if (this.mDestinations.isEmpty()) {
            LogUtil.CLog.e("Failed to send email because no destination addresses were set.");
            return false;
        }
        long now = this.getCurrentTimeMillis();
        if (0L < this.mMinEmailInterval && now - this.mLastEmailSentTime < this.mMinEmailInterval) {
            LogUtil.CLog.w("Skipped to send %s email: email interval %dms < %dms", DEFAULT_SUBJECT_PREFIX, now - this.mLastEmailSentTime, this.mMinEmailInterval);
            return false;
        }
        IEmail.Message msg = this.generateEmailMessage(description, cause);
        try {
            this.mMailer.send(msg);
        }
        catch (IllegalArgumentException e) {
            LogUtil.CLog.e("Failed to send %s email", DEFAULT_SUBJECT_PREFIX);
            LogUtil.CLog.e(e);
            return false;
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to send %s email", DEFAULT_SUBJECT_PREFIX);
            LogUtil.CLog.e(e);
            return false;
        }
        this.mLastEmailSentTime = now;
        return true;
    }

    private static String getStackTraceString(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

