/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.monitoring;

import com.android.tradefed.cluster.ClusterHostUtil;
import com.android.tradefed.cluster.IClusterOptions;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.internal.protobuf.util.Timestamps;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.monitoring.collector.IResourceMetricCollector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Attribute;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.LabResource;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.LabResourceRequest;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.LabResourceServiceGrpc;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Metric;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.MonitoredEntity;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Resource;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

@OptionClass(alias="lab-resource-monitor")
public class LabResourceDeviceMonitor
extends LabResourceServiceGrpc.LabResourceServiceImplBase
implements IDeviceMonitor {
    public static final String DEVICE_SERIAL_KEY = "device_serial";
    public static final String HOST_NAME_KEY = "hostname";
    public static final String LAB_NAME_KEY = "lab_name";
    public static final String TEST_HARNESS_KEY = "test_harness";
    public static final String HARNESS_VERSION_KEY = "harness_version";
    public static final String HOST_GROUP_KEY = "host_group";
    public static final int DEFAULT_PORT = 8887;
    public static final int DEFAULT_THREAD_COUNT = 1;
    public static final String POOL_ATTRIBUTE_NAME = "pool";
    public static final String RUN_TARGET_ATTRIBUTE_NAME = "run_target";
    public static final String STATUS_RESOURCE_NAME = "status";
    public static final String HARDWARE_REVISION_RESOURCE_NAME = "hardware_revision";
    public static final float FIXED_METRIC_VALUE = 1.0f;
    private static final long EXECUTOR_TERMINATE_TIMEOUT_SEC = 10L;
    private Server mServer;
    private IClusterOptions mClusterOptions;
    private IDeviceMonitor.DeviceLister mDeviceLister;
    private final Collection<IResourceMetricCollector> mMetricCollectors = new ArrayList<IResourceMetricCollector>();
    private final ReadWriteLock mLabResourceLock = new ReentrantReadWriteLock();
    private LabResource mLabResource = LabResource.newBuilder().build();
    private ScheduledExecutorService mMetricizeExecutor;
    private ExecutorService mCollectionExecutor;
    @Option(name="metricize-cycle-sec", description="The time in seconds between for each metricize cycle.")
    private long mMetricizeCycleSec = 300L;

    public LabResourceDeviceMonitor() {
    }

    @VisibleForTesting
    LabResourceDeviceMonitor(long metricizeCycleSec, IClusterOptions clusterOptions) {
        this.mMetricizeCycleSec = metricizeCycleSec;
        this.mClusterOptions = clusterOptions;
    }

    private IClusterOptions getClusterOptions() {
        return this.mClusterOptions == null ? ClusterHostUtil.getClusterOptions() : this.mClusterOptions;
    }

    private void loadMetricCollectors() {
        List<IResourceMetricCollector> collectors = GlobalConfiguration.getInstance().getResourceMetricCollectors();
        if (collectors != null) {
            this.mMetricCollectors.addAll(collectors);
        }
    }

    @VisibleForTesting
    void setServer(Server server) {
        this.mServer = server;
    }

    @Override
    public void run() {
        if (this.getClusterOptions().isDeviceMonitorDisabled()) {
            LogUtil.CLog.i("LabResourceDeviceMonitor is disabled.");
            return;
        }
        if (this.mServer == null) {
            this.mServer = ((ServerBuilder)((ServerBuilder)ServerBuilder.forPort(8887).addService(this)).executor(Executors.newFixedThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setName("lab-resource-server");
                    return t;
                }
            }))).build();
        }
        try {
            this.mServer.start();
            this.loadMetricCollectors();
            this.startExecutors();
            this.scheduleMetricizeTask();
        }
        catch (IOException | IllegalStateException e) {
            LogUtil.CLog.e(e);
            this.stopExecutors();
        }
    }

    @VisibleForTesting
    void startExecutors() {
        this.mMetricizeExecutor = MoreExecutors.getExitingScheduledExecutorService(new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName("lab-resource-metricize-executor");
                return t;
            }
        }));
        this.mCollectionExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName("lab-resource-collection-executor");
                return t;
            }
        });
    }

    @VisibleForTesting
    void stopExecutors() {
        this.awaitTerminateExecutor(this.mMetricizeExecutor);
        this.awaitTerminateExecutor(this.mCollectionExecutor);
    }

    private void awaitTerminateExecutor(ExecutorService executor) {
        if (executor == null) {
            return;
        }
        executor.shutdownNow();
        try {
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LogUtil.CLog.w("Interrupted when waiting executor terminated.");
        }
    }

    private void setCachedLabResource(LabResource resource) {
        this.mLabResourceLock.writeLock().lock();
        try {
            this.mLabResource = resource;
        }
        finally {
            this.mLabResourceLock.writeLock().unlock();
        }
    }

    protected LabResource getCachedLabResource() {
        this.mLabResourceLock.readLock().lock();
        try {
            LabResource labResource = this.mLabResource;
            return labResource;
        }
        finally {
            this.mLabResourceLock.readLock().unlock();
        }
    }

    private void scheduleMetricizeTask() {
        if (this.mMetricizeExecutor == null) {
            LogUtil.CLog.d("schedule metricize task before the mMetricizeExecutor initialized");
            return;
        }
        this.mMetricizeExecutor.scheduleAtFixedRate(() -> {
            LabResource.Builder builder = LabResource.newBuilder().setHost(this.buildMonitoredHost(this.mMetricCollectors));
            List descriptors = this.mDeviceLister.listDevices().stream().filter(descriptor -> !descriptor.isTemporary()).collect(Collectors.toList());
            for (DeviceDescriptor descriptor2 : descriptors) {
                if (this.mMetricizeExecutor.isShutdown()) break;
                if (ClusterHostUtil.isLocalhostIpPort(descriptor2.getSerial())) continue;
                builder.addDevice(this.buildMonitoredDevice(descriptor2, this.mMetricCollectors));
            }
            this.setCachedLabResource(builder.build());
        }, 0L, this.mMetricizeCycleSec, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.mServer != null && !this.mServer.isShutdown()) {
            this.mServer.shutdownNow();
        }
        this.stopExecutors();
    }

    @Override
    public void setDeviceLister(IDeviceMonitor.DeviceLister lister) {
        this.mDeviceLister = lister;
    }

    @Override
    public void notifyDeviceStateChange(String serial, DeviceAllocationState oldState, DeviceAllocationState newState) {
    }

    @Override
    public void getLabResource(LabResourceRequest request, StreamObserver<LabResource> responseObserver) {
        responseObserver.onNext(this.getCachedLabResource());
        responseObserver.onCompleted();
    }

    @VisibleForTesting
    MonitoredEntity buildMonitoredHost(Collection<IResourceMetricCollector> collectors) {
        MonitoredEntity.Builder builder = MonitoredEntity.newBuilder().putIdentifier(HOST_NAME_KEY, ClusterHostUtil.getHostName()).putIdentifier(LAB_NAME_KEY, this.getClusterOptions().getLabName()).putIdentifier(TEST_HARNESS_KEY, ClusterHostUtil.getTestHarness()).addAttribute(Attribute.newBuilder().setName(HOST_GROUP_KEY).setValue(this.getClusterOptions().getClusterId())).addAttribute(Attribute.newBuilder().setName(HARNESS_VERSION_KEY).setValue(ClusterHostUtil.getTfVersion())).addAllAttribute(this.getClusterOptions().getNextClusterIds().stream().map(pool -> Attribute.newBuilder().setName(POOL_ATTRIBUTE_NAME).setValue((String)pool).build()).collect(Collectors.toList()));
        for (IResourceMetricCollector collector : collectors) {
            Future<Collection> future = null;
            try {
                future = this.mCollectionExecutor.submit(collector::getHostResourceMetrics);
                builder.addAllResource(future.get(collector.getHostMetricizeTimeoutMs(), TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException | NullPointerException | ExecutionException | RejectedExecutionException | TimeoutException e) {
                LogUtil.CLog.w("%s got %s when collecting host metrics.", collector.getClass().getSimpleName(), e.toString());
                if (future == null) continue;
                future.cancel(true);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    MonitoredEntity buildMonitoredDevice(DeviceDescriptor descriptor, Collection<IResourceMetricCollector> collectors) {
        MonitoredEntity.Builder builder = MonitoredEntity.newBuilder().putIdentifier(DEVICE_SERIAL_KEY, descriptor.getSerial()).addAttribute(Attribute.newBuilder().setName(HOST_NAME_KEY).setValue(ClusterHostUtil.getHostName())).addAttribute(Attribute.newBuilder().setName(RUN_TARGET_ATTRIBUTE_NAME).setValue(ClusterHostUtil.getRunTarget(descriptor, this.getClusterOptions().getRunTargetFormat(), this.getClusterOptions().getDeviceTag()))).addResource(Resource.newBuilder().setResourceName(STATUS_RESOURCE_NAME).setTimestamp(Timestamps.fromMillis(Instant.now().toEpochMilli())).addMetric(Metric.newBuilder().setTag(descriptor.getState().name()).setValue(1.0f)));
        if (!descriptor.getDeviceClass().equals(TestDevice.class.getSimpleName())) {
            return builder.build();
        }
        for (IResourceMetricCollector collector : collectors) {
            Future<Collection> future = null;
            try {
                future = this.mCollectionExecutor.submit(() -> collector.getDeviceResourceMetrics(descriptor, GlobalConfiguration.getDeviceManagerInstance()));
                builder.addAllResource(future.get(collector.getDeviceMetricizeTimeoutMs(), TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException | NullPointerException | ExecutionException | RejectedExecutionException | TimeoutException e) {
                LogUtil.CLog.w("%s got %s when collecting device metrics.", collector.getClass().getSimpleName(), e.toString());
                if (future == null) continue;
                future.cancel(true);
            }
        }
        return builder.build();
    }
}

