/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.monitoring.collector;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.monitoring.collector.IResourceMetricCollector;
import com.android.tradefed.monitoring.collector.ResourceMetricUtil;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Metric;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceBatteryResourceMetricCollector
implements IResourceMetricCollector {
    public static final String BATTERY_RESOURCE_NAME = "battery";
    public static final String BATTERY_CMD = "dumpsys battery";
    public static final Pattern BATTERY_PATTERN = Pattern.compile("(?<field>status|health|level|scale|temperature)\\:\\s(?<value>[0-9]+)");
    public static final String TEMPERATURE = "temperature";
    public static final String FIELD_GROUP = "field";
    public static final String VALUE_GROUP = "value";
    public static final float BATTERY_TEMP_DENOMINATOR = 10.0f;
    private static final long CMD_TIMEOUT_MS = 500L;

    @Override
    public Collection<Resource> getDeviceResourceMetrics(DeviceDescriptor descriptor, IDeviceManager deviceManager) {
        Optional<String> response = ResourceMetricUtil.GetCommandResponse(deviceManager, descriptor.getSerial(), BATTERY_CMD, 500L);
        if (!response.isPresent()) {
            return List.of();
        }
        Matcher matcher = BATTERY_PATTERN.matcher(response.get());
        if (!matcher.find()) {
            return List.of();
        }
        Resource.Builder builder = Resource.newBuilder().setResourceName(BATTERY_RESOURCE_NAME).setTimestamp(ResourceMetricUtil.GetCurrentTimestamp());
        do {
            Metric.Builder metricBuilder = Metric.newBuilder();
            metricBuilder.setTag(matcher.group(FIELD_GROUP));
            if (Objects.equals(matcher.group(FIELD_GROUP), TEMPERATURE)) {
                metricBuilder.setValue(ResourceMetricUtil.ConvertedMetricValue(matcher.group(VALUE_GROUP), 10.0f));
            } else {
                metricBuilder.setValue(ResourceMetricUtil.RoundedMetricValue(matcher.group(VALUE_GROUP)));
            }
            builder.addMetric(metricBuilder);
        } while (matcher.find());
        return List.of(builder.build());
    }
}

