/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.monitoring.collector;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.monitoring.collector.IResourceMetricCollector;
import com.android.tradefed.monitoring.collector.ResourceMetricUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Metric;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceInternetAccessibilityResourceMetricCollector
implements IResourceMetricCollector {
    public static final String INTERNET_ACCESSIBILITY_METRIC_NAME = "internet_access";
    public static final String PING_CMD = "ping -c 2 -W 1 google.com";
    public static final String PING6_CMD = "ping6 -c 2 -W 1 google.com";
    public static final Pattern SUCCESS_PATTERN = Pattern.compile(".*min/avg/max/.* = [0-9.]+/(?<avgping>[0-9.]+)/");
    public static final String AVG_PING = "avgping";
    public static final String AVG_PING_TAG = "avgping";
    public static final String AVG_PING6_TAG = "avgping6";
    public static final Float FAILED_VAL = Float.valueOf(1000.0f);
    @Option(name="commandTimeout", description="The timeout in ms for each ping command.")
    private long mCmdTimeoutMs = 2000L;
    @Option(name="deviceMetricizeTimeout", description="The timeout in ms for device metricize.")
    private long mDeviceMetricizeTimeoutMs = 5000L;

    @Override
    public Collection<Resource> getDeviceResourceMetrics(DeviceDescriptor descriptor, IDeviceManager deviceManager) {
        Resource.Builder builder = Resource.newBuilder().setResourceName(INTERNET_ACCESSIBILITY_METRIC_NAME).setTimestamp(ResourceMetricUtil.GetCurrentTimestamp());
        float avgPing = this.getAveragePing(descriptor, deviceManager, PING_CMD);
        Metric.Builder metricBuilder = Metric.newBuilder().setTag("avgping");
        metricBuilder.setValue(avgPing);
        builder.addMetric(metricBuilder);
        float avgPing6 = this.getAveragePing(descriptor, deviceManager, PING6_CMD);
        Metric.Builder metric6Builder = Metric.newBuilder().setTag(AVG_PING6_TAG);
        metric6Builder.setValue(avgPing6);
        builder.addMetric(metric6Builder);
        return List.of(builder.build());
    }

    @VisibleForTesting
    float getAveragePing(DeviceDescriptor descriptor, IDeviceManager deviceManager, String command) {
        Optional<String> response = ResourceMetricUtil.GetCommandResponse(deviceManager, descriptor.getSerial(), command, this.mCmdTimeoutMs);
        if (!response.isPresent()) {
            return FAILED_VAL.floatValue();
        }
        Matcher matcher = SUCCESS_PATTERN.matcher(response.get());
        if (!matcher.find()) {
            return FAILED_VAL.floatValue();
        }
        return ResourceMetricUtil.RoundedMetricValue(matcher.group("avgping"));
    }

    @VisibleForTesting
    long getCmdTimeoutMs() {
        return this.mCmdTimeoutMs;
    }

    @Override
    public long getDeviceMetricizeTimeoutMs() {
        return this.mDeviceMetricizeTimeoutMs;
    }
}

