/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.monitoring.collector;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.monitoring.collector.IResourceMetricCollector;
import com.android.tradefed.monitoring.collector.ResourceMetricUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Metric;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Resource;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceStorageAgeResourceMetricCollector
implements IResourceMetricCollector {
    public static final String STORAGE_AGE_RESOURCE_NAME = "storage_age";
    public static final String STORAGE_AGE_CMD_FORMAT = "logcat -b events -d -t \"%d-%02d-%02d %02d:%02d:00.000\" | grep storaged_emmc_info | tail -1";
    public static final Pattern STORAGE_AGE_PATTERN = Pattern.compile("storaged_emmc_info:\\s\\[.*\\,(?<lifeTimeA>[0-9]{1,2}),(?<lifeTimeB>[0-9]{1,2})\\]");
    public static final String LIFE_A_TAG = "lifeTimeA";
    public static final String LIFE_B_TAG = "lifeTimeB";
    public static final String AGE_TAG = "age";
    private static final long STORAGE_AGE_TIMEOUT_MS = 500L;

    @Override
    public Collection<Resource> getDeviceResourceMetrics(DeviceDescriptor descriptor, IDeviceManager deviceManager) {
        Optional<String> response = ResourceMetricUtil.GetCommandResponse(deviceManager, descriptor.getSerial(), this.buildStorageAgeCommand(Calendar.getInstance()), 500L);
        if (!response.isPresent() || response.get().isEmpty()) {
            LogUtil.CLog.d("Failed to find the storaged logs.");
            return List.of();
        }
        Matcher matcher = STORAGE_AGE_PATTERN.matcher(response.get());
        if (!matcher.find()) {
            return List.of();
        }
        Resource.Builder builder = Resource.newBuilder().setResourceName(STORAGE_AGE_RESOURCE_NAME).setTimestamp(ResourceMetricUtil.GetCurrentTimestamp()).addMetric(Metric.newBuilder().setTag(AGE_TAG).setValue(Math.max(ResourceMetricUtil.RoundedMetricValue(matcher.group(LIFE_A_TAG)), ResourceMetricUtil.RoundedMetricValue(matcher.group(LIFE_B_TAG)))));
        return List.of(builder.build());
    }

    @VisibleForTesting
    String buildStorageAgeCommand(Calendar cal) {
        cal.add(10, -1);
        return String.format(Locale.US, STORAGE_AGE_CMD_FORMAT, cal.get(1), cal.get(2), cal.get(5), cal.get(10), cal.get(12));
    }
}

