/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.monitoring.collector;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.monitoring.collector.IResourceMetricCollector;
import com.android.tradefed.monitoring.collector.ResourceMetricUtil;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Metric;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceWifiResourceMetricCollector
implements IResourceMetricCollector {
    public static final String WIFI_METRIC_NAME = "wifi";
    public static final String WIFI_SIGNAL_CMD = "wpa_cli -i wlan0 signal_poll";
    public static final String WIFI_STATUS_CMD = "wpa_cli -i wlan0 status";
    public static final Pattern WIFI_SIGNAL_PATTERN = Pattern.compile("RSSI=(?<rssi>[\\-0-9]+)\\nLINKSPEED=(?<speed>[0-9]+)\\nNOISE=(?<noise>[\\-0-9]+)\\n");
    public static final Pattern WIFI_STATUS_PATTERN = Pattern.compile("bssid=.*\\nfreq=.*\\nssid=(?<ssid>.*)");
    public static final String RSSI = "rssi";
    public static final String SPEED = "speed";
    public static final String NOISE = "noise";
    public static final String SSID = "ssid";
    private static final long CMD_TIMEOUT_MS = 500L;

    @Override
    public Collection<Resource> getDeviceResourceMetrics(DeviceDescriptor descriptor, IDeviceManager deviceManager) {
        Matcher signalMatcher = this.getWifiCmdResponseMatcher(descriptor, deviceManager, WIFI_SIGNAL_CMD, WIFI_SIGNAL_PATTERN);
        Matcher statusMatcher = this.getWifiCmdResponseMatcher(descriptor, deviceManager, WIFI_STATUS_CMD, WIFI_STATUS_PATTERN);
        if (!signalMatcher.find() || !statusMatcher.find()) {
            return List.of();
        }
        Resource.Builder builder = Resource.newBuilder().setResourceInstance(statusMatcher.group(SSID)).setResourceName(WIFI_METRIC_NAME).setTimestamp(ResourceMetricUtil.GetCurrentTimestamp());
        float speed = ResourceMetricUtil.RoundedMetricValue(signalMatcher.group(SPEED));
        if (speed == 0.0f) {
            return List.of(builder.addMetric(Metric.newBuilder().setTag(SPEED).setValue(speed)).build());
        }
        builder.addMetric(Metric.newBuilder().setTag(SPEED).setValue(speed)).addMetric(Metric.newBuilder().setTag(RSSI).setValue(ResourceMetricUtil.RoundedMetricValue(signalMatcher.group(RSSI)))).addMetric(Metric.newBuilder().setTag(NOISE).setValue(ResourceMetricUtil.RoundedMetricValue(signalMatcher.group(NOISE))));
        return List.of(builder.build());
    }

    private Matcher getWifiCmdResponseMatcher(DeviceDescriptor descriptor, IDeviceManager deviceManager, String cmd, Pattern responsePattern) {
        Optional<String> response = ResourceMetricUtil.GetCommandResponse(deviceManager, descriptor.getSerial(), cmd, 500L);
        if (!response.isPresent()) {
            return responsePattern.matcher("");
        }
        return responsePattern.matcher(response.get());
    }
}

