/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.monitoring.collector;

import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.internal.protobuf.Timestamp;
import com.android.tradefed.internal.protobuf.util.Timestamps;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class ResourceMetricUtil {
    public static Optional<String> GetCommandResponse(IDeviceManager deviceManager, String serial, String cmd, long timeoutMs) {
        CommandResult result = deviceManager.executeCmdOnAvailableDevice(serial, cmd, timeoutMs, TimeUnit.MILLISECONDS);
        if (result == null) {
            LogUtil.CLog.d("Null command result for executing %s on device %s with timeout %d ms", cmd, serial, timeoutMs);
            return Optional.empty();
        }
        if (result.getStatus().equals((Object)CommandStatus.SUCCESS) && result.getStdout() != null) {
            return Optional.of(result.getStdout());
        }
        LogUtil.CLog.d("Failed to execute command %s on device %s: %s", cmd, serial, result.getStderr());
        return Optional.empty();
    }

    public static Timestamp GetCurrentTimestamp() {
        return Timestamps.fromMillis(Instant.now().toEpochMilli());
    }

    public static float RoundedMetricValue(String original) throws NumberFormatException {
        return ResourceMetricUtil.ConvertedMetricValue(original, 0.0f);
    }

    public static float ConvertedMetricValue(String original, float conversionDivisor) throws NumberFormatException {
        float val = Float.parseFloat(original);
        if (conversionDivisor != 0.0f) {
            val /= conversionDivisor;
        }
        return (float)Math.round(val * 100.0f) / 100.0f;
    }
}

