/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.observatory;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.StdoutLogger;
import com.android.tradefed.observatory.DiscoveryExitCode;
import com.android.tradefed.observatory.IDiscoverDependencies;
import com.android.tradefed.observatory.TestDiscoveryException;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.BaseTestSuite;
import com.android.tradefed.testtype.suite.ITestSuite;
import com.android.tradefed.testtype.suite.SuiteTestFilter;
import com.android.tradefed.testtype.suite.TestMappingSuiteRunner;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.keystore.DryRunKeyStore;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TestDiscoveryExecutor {
    private boolean mReportPartialFallback = false;

    IConfigurationFactory getConfigurationFactory() {
        return ConfigurationFactory.getInstance();
    }

    private static boolean hasOutputResultFile() {
        return System.getenv("DISCOVERY_OUTPUT_FILE") != null;
    }

    public static void main(String[] args) {
        DiscoveryExitCode exitCode = DiscoveryExitCode.SUCCESS;
        TestDiscoveryExecutor testDiscoveryExecutor = new TestDiscoveryExecutor();
        try {
            String testModules = testDiscoveryExecutor.discoverDependencies(args);
            if (TestDiscoveryExecutor.hasOutputResultFile()) {
                FileUtil.writeToFile(testModules, new File(System.getenv("DISCOVERY_OUTPUT_FILE")));
            }
            System.out.print(testModules);
        }
        catch (TestDiscoveryException e) {
            System.err.print(e.getMessage());
            exitCode = e.exitCode() != null ? e.exitCode() : DiscoveryExitCode.ERROR;
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
            exitCode = DiscoveryExitCode.ERROR;
        }
        System.exit(exitCode.exitCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String discoverDependencies(String[] args) throws TestDiscoveryException, ConfigurationException {
        IConfiguration config = this.getConfiguration(args);
        if (TestDiscoveryExecutor.hasOutputResultFile()) {
            DdmPreferences.setLogLevel(Log.LogLevel.VERBOSE.getStringValue());
            Log.setLogOutput(LogRegistry.getLogRegistry());
            StdoutLogger logger = new StdoutLogger();
            logger.setLogLevel(Log.LogLevel.VERBOSE);
            LogRegistry.getLogRegistry().registerLogger(logger);
        }
        try {
            List<IRemoteTest> tests = config.getTests();
            if (tests == null || tests.isEmpty()) {
                throw new TestDiscoveryException("Tradefed Observatory discovered no tests from the IConfiguration created from command line args.", null, DiscoveryExitCode.ERROR);
            }
            ArrayList<String> testModules = new ArrayList<String>(this.discoverTestModulesFromTests(tests));
            ArrayList<String> testDependencies = new ArrayList<String>(this.discoverDependencies(config));
            Collections.sort(testModules);
            Collections.sort(testDependencies);
            JsonObject jsonObject = new JsonObject();
            Gson gson = new Gson();
            JsonArray testModulesArray = gson.toJsonTree(testModules).getAsJsonArray();
            JsonArray testDependenciesArray = gson.toJsonTree(testDependencies).getAsJsonArray();
            jsonObject.add("TestModules", testModulesArray);
            jsonObject.add("TestDependencies", testDependenciesArray);
            if (this.mReportPartialFallback) {
                jsonObject.addProperty("PartialFallback", "true");
            }
            String string = jsonObject.toString();
            return string;
        }
        finally {
            if (TestDiscoveryExecutor.hasOutputResultFile()) {
                LogRegistry.getLogRegistry().unregisterLogger();
            }
        }
    }

    private IConfiguration getConfiguration(String[] args) throws ConfigurationException {
        IConfigurationFactory configurationFactory = this.getConfigurationFactory();
        return configurationFactory.createConfigurationFromArgs(args, null, new DryRunKeyStore());
    }

    private Set<String> discoverTestModulesFromTests(List<IRemoteTest> testList) throws IllegalStateException, TestDiscoveryException {
        LinkedHashSet<String> testModules = new LinkedHashSet<String>();
        LinkedHashSet<String> includeFilters = new LinkedHashSet<String>();
        LinkedHashSet<String> excludeFilters = new LinkedHashSet<String>();
        for (IRemoteTest test : testList) {
            Set<String> configs;
            File rootDir;
            boolean throwException;
            String rootDirPath;
            if (!(test instanceof BaseTestSuite)) {
                throw new TestDiscoveryException("Tradefed Observatory can't do test discovery on non suite-based test runner.", null, DiscoveryExitCode.ERROR);
            }
            if (test instanceof TestMappingSuiteRunner) {
                ((TestMappingSuiteRunner)test).loadTestInfos();
            }
            Set<String> suiteIncludeFilters = ((BaseTestSuite)test).getIncludeFilter();
            excludeFilters.addAll(((BaseTestSuite)test).getExcludeFilter());
            MultiMap<String, String> moduleMetadataIncludeFilters = ((BaseTestSuite)test).getModuleMetadataIncludeFilters();
            if (!suiteIncludeFilters.isEmpty()) {
                includeFilters.addAll(suiteIncludeFilters);
                continue;
            }
            if (!moduleMetadataIncludeFilters.isEmpty()) {
                rootDirPath = this.getEnvironment("ROOT_TEST_DISCOVERY_USE_TEST_DIRECTORY");
                throwException = true;
                if (rootDirPath != null && (rootDir = new File(rootDirPath)).exists() && rootDir.isDirectory() && (configs = this.searchConfigsForMetadata(rootDir, moduleMetadataIncludeFilters)) != null) {
                    testModules.addAll(configs);
                    throwException = false;
                    this.mReportPartialFallback = true;
                }
                if (!throwException) continue;
                throw new TestDiscoveryException("Tradefed Observatory can't do test discovery because the existence of metadata include filter option.", null, DiscoveryExitCode.COMPONENT_METADATA);
            }
            if (ITestSuite.MultiDeviceModuleStrategy.ONLY_MULTI_DEVICES.equals((Object)((BaseTestSuite)test).getMultiDeviceStrategy())) {
                rootDirPath = this.getEnvironment("ROOT_TEST_DISCOVERY_USE_TEST_DIRECTORY");
                throwException = true;
                if (rootDirPath != null && (rootDir = new File(rootDirPath)).exists() && rootDir.isDirectory() && (configs = this.searchForMultiDevicesConfig(rootDir)) != null) {
                    testModules.addAll(configs);
                    throwException = false;
                    this.mReportPartialFallback = true;
                }
                if (!throwException) continue;
                throw new TestDiscoveryException("Tradefed Observatory can't do test discovery because the existence of multi-devices option.", null, DiscoveryExitCode.COMPONENT_METADATA);
            }
            if (Strings.isNullOrEmpty(((BaseTestSuite)test).getRunSuiteTag())) continue;
            rootDirPath = this.getEnvironment("ROOT_TEST_DISCOVERY_USE_TEST_DIRECTORY");
            throwException = true;
            if (rootDirPath != null && (rootDir = new File(rootDirPath)).exists() && rootDir.isDirectory() && (configs = this.searchConfigsForSuiteTag(rootDir, ((BaseTestSuite)test).getRunSuiteTag())) != null) {
                testModules.addAll(configs);
                throwException = false;
                this.mReportPartialFallback = true;
            }
            if (!throwException) continue;
            throw new TestDiscoveryException("Tradefed Observatory can't do test discovery because the existence of run-suite-tag option.", null, DiscoveryExitCode.COMPONENT_METADATA);
        }
        if (TestDiscoveryExecutor.hasOutputResultFile()) {
            System.out.println(String.format("include filters: %s", includeFilters));
        }
        testModules.addAll(this.extractTestModulesFromIncludeFilters(includeFilters));
        testModules.removeAll(excludeFilters);
        return testModules;
    }

    private Set<String> extractTestModulesFromIncludeFilters(Set<String> includeFilters) throws IllegalStateException {
        LinkedHashSet<String> testModuleNames = new LinkedHashSet<String>();
        for (String includeFilter : includeFilters) {
            String testModuleName = SuiteTestFilter.createFrom(includeFilter).getBaseName();
            if (testModuleName == null) {
                throw new IllegalStateException(String.format("Unable to parse test module name from include filter %s", includeFilter));
            }
            testModuleNames.add(testModuleName);
        }
        return testModuleNames;
    }

    private Set<String> discoverDependencies(IConfiguration config) {
        HashSet<String> dependencies = new HashSet<String>();
        for (Object o : config.getAllConfigurationObjectsOfType("target_preparer")) {
            if (!(o instanceof IDiscoverDependencies)) continue;
            dependencies.addAll(((IDiscoverDependencies)o).reportDependencies());
        }
        return dependencies;
    }

    private Set<String> searchForMultiDevicesConfig(File rootDir) {
        try {
            Set<File> configFiles = FileUtil.findFilesObject(rootDir, ".*\\.config$");
            if (configFiles.isEmpty()) {
                return null;
            }
            Set shouldRunFiles = configFiles.stream().filter(f -> {
                try {
                    IConfiguration c = this.getConfigurationFactory().createPartialConfigurationFromArgs(new String[]{f.getAbsolutePath()}, new DryRunKeyStore(), ImmutableSet.of("config_desc"), null);
                    return c.getDeviceConfig().size() > 1;
                }
                catch (ConfigurationException e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return shouldRunFiles.stream().map(c -> FileUtil.getBaseName(c.getName())).collect(Collectors.toSet());
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
    }

    private Set<String> searchConfigsForMetadata(File rootDir, MultiMap<String, String> moduleMetadataIncludeFilters) {
        try {
            Set<File> configFiles = FileUtil.findFilesObject(rootDir, ".*\\.config$");
            if (configFiles.isEmpty()) {
                return null;
            }
            Set shouldRunFiles = configFiles.stream().filter(f -> {
                try {
                    IConfiguration c = this.getConfigurationFactory().createPartialConfigurationFromArgs(new String[]{f.getAbsolutePath()}, new DryRunKeyStore(), ImmutableSet.of("config_desc"), null);
                    return new BaseTestSuite().filterByConfigMetadata(c, moduleMetadataIncludeFilters, new MultiMap<String, String>());
                }
                catch (ConfigurationException e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return shouldRunFiles.stream().map(c -> FileUtil.getBaseName(c.getName())).collect(Collectors.toSet());
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
    }

    private Set<String> searchConfigsForSuiteTag(File rootDir, String suiteTag) {
        try {
            Set<File> configFiles = FileUtil.findFilesObject(rootDir, ".*\\.config$");
            if (configFiles.isEmpty()) {
                return null;
            }
            Set shouldRunFiles = configFiles.stream().filter(f -> {
                try {
                    String content = FileUtil.readStringFromFile(f);
                    return content.contains("test-suite-tag") && content.contains(suiteTag);
                }
                catch (IOException e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return shouldRunFiles.stream().map(c -> FileUtil.getBaseName(c.getName())).collect(Collectors.toSet());
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
    }

    protected String getEnvironment(String var) {
        return System.getenv(var);
    }
}

