/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.observatory;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.observatory.ConfigurationCtsParserSettings;
import com.android.tradefed.observatory.ConfigurationTestMappingParserSettings;
import com.android.tradefed.observatory.DiscoveryExitCode;
import com.android.tradefed.observatory.TestDiscoveryException;
import com.android.tradefed.observatory.TestDiscoveryExecutor;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StringEscapeUtils;
import com.android.tradefed.util.SystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestDiscoveryInvoker {
    private final IConfiguration mConfiguration;
    private final String mDefaultConfigName;
    private final File mRootDir;
    private final IRunUtil mRunUtil = new RunUtil();
    private final boolean mHasConfigFallback;
    private final boolean mUseCurrentTradefed;
    private File mTestDir;
    private File mTestMappingZip;
    private IBuildInfo mBuildInfo;
    public static final String TRADEFED_OBSERVATORY_ENTRY_PATH = TestDiscoveryExecutor.class.getName();
    public static final String TEST_DEPENDENCIES_LIST_KEY = "TestDependencies";
    public static final String TEST_MODULES_LIST_KEY = "TestModules";
    public static final String PARTIAL_FALLBACK_KEY = "PartialFallback";
    public static final String TEST_MAPPING_ZIP_FILE = "TF_TEST_MAPPING_ZIP_FILE";
    public static final String ROOT_DIRECTORY_ENV_VARIABLE_KEY = "ROOT_TEST_DISCOVERY_USE_TEST_DIRECTORY";
    public static final String OUTPUT_FILE = "DISCOVERY_OUTPUT_FILE";
    private static final long DISCOVERY_TIMEOUT_MS = 120000L;

    @VisibleForTesting
    IRunUtil getRunUtil() {
        return this.mRunUtil;
    }

    @VisibleForTesting
    String getJava() {
        return SystemUtil.getRunningJavaBinaryPath().getAbsolutePath();
    }

    @VisibleForTesting
    File createOutputFile() throws IOException {
        return FileUtil.createTempFile("discovery-output", ".txt");
    }

    public File getTestDir() {
        return this.mTestDir;
    }

    public void setTestDir(File testDir) {
        this.mTestDir = testDir;
    }

    public void setTestMappingZip(File testMappingZip) {
        this.mTestMappingZip = testMappingZip;
    }

    public void setBuildInfo(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public TestDiscoveryInvoker(IConfiguration config, File rootDir) {
        this(config, null, rootDir);
    }

    public TestDiscoveryInvoker(IConfiguration config, String defaultConfigName, File rootDir) {
        this(config, defaultConfigName, rootDir, false, false);
    }

    public TestDiscoveryInvoker(IConfiguration config, String defaultConfigName, File rootDir, boolean hasConfigFallback, boolean useCurrentTradefed) {
        this.mConfiguration = config;
        this.mDefaultConfigName = defaultConfigName;
        this.mRootDir = rootDir;
        this.mTestDir = null;
        this.mHasConfigFallback = hasConfigFallback;
        this.mUseCurrentTradefed = useCurrentTradefed;
    }

    public Map<String, List<String>> discoverTestDependencies() throws IOException, JSONException, ConfigurationException, TestDiscoveryException {
        File outputFile = this.createOutputFile();
        try {
            CloseableTraceScope ignored = new CloseableTraceScope("discoverTestDependencies");
            try {
                String partialFallback;
                List<String> testDependencies;
                HashMap<String, List<String>> dependencies = new HashMap<String, List<String>>();
                String classPath = this.buildXtsClasspath(this.mRootDir);
                List<String> args = this.buildJavaCmdForXtsDiscovery(classPath);
                Object[] subprocessArgs = args.toArray(new String[args.size()]);
                if (this.mHasConfigFallback) {
                    this.getRunUtil().setEnvVariable(ROOT_DIRECTORY_ENV_VARIABLE_KEY, this.mRootDir.getAbsolutePath());
                }
                this.getRunUtil().setEnvVariable(OUTPUT_FILE, outputFile.getAbsolutePath());
                CommandResult res = this.getRunUtil().runTimedCmd(120000L, (String[])subprocessArgs);
                if (res.getExitCode() != 0 || !res.getStatus().equals((Object)CommandStatus.SUCCESS)) {
                    DiscoveryExitCode exitCode = null;
                    if (res.getExitCode() != null) {
                        for (DiscoveryExitCode code : DiscoveryExitCode.values()) {
                            if (code.exitCode() != res.getExitCode().intValue()) continue;
                            exitCode = code;
                        }
                    }
                    throw new TestDiscoveryException(String.format("Tradefed observatory error, unable to discover test module names. command used: %s error: %s", Joiner.on(" ").join(subprocessArgs), res.getStderr()), null, exitCode);
                }
                String stdout = res.getStdout();
                LogUtil.CLog.i(String.format("Tradefed Observatory returned in stdout: %s", stdout));
                String result = FileUtil.readStringFromFile(outputFile);
                LogUtil.CLog.i("output file content: %s", result);
                try {
                    new JSONObject(result);
                }
                catch (JSONException e) {
                    LogUtil.CLog.w("Output file was incorrect. Try falling back stdout");
                    result = stdout;
                }
                List<String> testModules = this.parseTestDiscoveryOutput(result, TEST_MODULES_LIST_KEY);
                if (!testModules.isEmpty()) {
                    dependencies.put(TEST_MODULES_LIST_KEY, testModules);
                }
                if (!(testDependencies = this.parseTestDiscoveryOutput(result, TEST_DEPENDENCIES_LIST_KEY)).isEmpty()) {
                    dependencies.put(TEST_DEPENDENCIES_LIST_KEY, testDependencies);
                }
                if ((partialFallback = this.parsePartialFallback(result)) != null) {
                    dependencies.put(PARTIAL_FALLBACK_KEY, Arrays.asList(partialFallback));
                }
                HashMap<String, List<String>> hashMap = dependencies;
                ignored.close();
                return hashMap;
            }
            catch (Throwable throwable) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            FileUtil.deleteFile(outputFile);
        }
    }

    public Map<String, List<String>> discoverTestMappingDependencies() throws IOException, JSONException, ConfigurationException, TestDiscoveryException {
        File outputFile = this.createOutputFile();
        try {
            CloseableTraceScope ignored = new CloseableTraceScope("discoverTestMappingDependencies");
            try {
                String partialFallback;
                ArrayList<String> fullCommandLineArgs = new ArrayList<String>(Arrays.asList(QuotationAwareTokenizer.tokenizeLine(this.mConfiguration.getCommandLine())));
                fullCommandLineArgs.remove(0);
                ConfigurationTestMappingParserSettings mappingParserSettings = new ConfigurationTestMappingParserSettings();
                ArgsOptionParser mappingOptionParser = new ArgsOptionParser(mappingParserSettings);
                mappingOptionParser.parseBestEffort(fullCommandLineArgs, true);
                HashMap<String, List<String>> dependencies = new HashMap<String, List<String>>();
                String classPath = this.buildTestMappingClasspath(this.mRootDir);
                List<String> args = this.buildJavaCmdForTestMappingDiscovery(classPath);
                Object[] subprocessArgs = args.toArray(new String[args.size()]);
                if (this.mTestMappingZip != null) {
                    this.getRunUtil().setEnvVariable(TEST_MAPPING_ZIP_FILE, this.mTestMappingZip.getAbsolutePath());
                }
                if (this.mBuildInfo != null) {
                    if (this.mBuildInfo.getFile("test_mappings.zip") != null) {
                        this.getRunUtil().setEnvVariable(TEST_MAPPING_ZIP_FILE, this.mBuildInfo.getFile("test_mappings.zip").getAbsolutePath());
                        this.getRunUtil().setEnvVariable("test_mappings.zip", this.mBuildInfo.getFile("test_mappings.zip").getAbsolutePath());
                    }
                    for (String allowedList : mappingParserSettings.mAllowedTestLists) {
                        if (this.mBuildInfo.getFile(allowedList) == null) continue;
                        this.getRunUtil().setEnvVariable(allowedList, this.mBuildInfo.getFile(allowedList).getAbsolutePath());
                    }
                }
                if (this.mHasConfigFallback) {
                    this.getRunUtil().setEnvVariable(ROOT_DIRECTORY_ENV_VARIABLE_KEY, this.mRootDir.getAbsolutePath());
                }
                this.getRunUtil().setEnvVariable(OUTPUT_FILE, outputFile.getAbsolutePath());
                CommandResult res = this.getRunUtil().runTimedCmd(120000L, (String[])subprocessArgs);
                if (res.getExitCode() != 0 || !res.getStatus().equals((Object)CommandStatus.SUCCESS)) {
                    throw new TestDiscoveryException(String.format("Tradefed observatory error, unable to discover test module names. command used: %s error: %s", Joiner.on(" ").join(subprocessArgs), res.getStderr()), null);
                }
                String stdout = res.getStdout();
                LogUtil.CLog.i(String.format("Tradefed Observatory returned in stdout:\n %s", stdout));
                String result = FileUtil.readStringFromFile(outputFile);
                List<String> testModules = this.parseTestDiscoveryOutput(result, TEST_MODULES_LIST_KEY);
                if (!testModules.isEmpty()) {
                    dependencies.put(TEST_MODULES_LIST_KEY, testModules);
                }
                if ((partialFallback = this.parsePartialFallback(result)) != null) {
                    dependencies.put(PARTIAL_FALLBACK_KEY, Arrays.asList(partialFallback));
                }
                HashMap<String, List<String>> hashMap = dependencies;
                ignored.close();
                return hashMap;
            }
            catch (Throwable throwable) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            FileUtil.deleteFile(outputFile);
        }
    }

    private List<String> buildJavaCmdForTestMappingDiscovery(String classpath) {
        ArrayList<String> fullCommandLineArgs = new ArrayList<String>(Arrays.asList(QuotationAwareTokenizer.tokenizeLine(this.mConfiguration.getCommandLine())));
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getJava());
        args.add("-cp");
        args.add(classpath);
        args.add(TRADEFED_OBSERVATORY_ENTRY_PATH);
        int i = 0;
        while (i < fullCommandLineArgs.size()) {
            if (((String)fullCommandLineArgs.get(i)).equals("--invocation-data")) {
                i += 2;
                continue;
            }
            args.add((String)fullCommandLineArgs.get(i));
            ++i;
        }
        return args;
    }

    private List<String> buildJavaCmdForXtsDiscovery(String classpath) throws ConfigurationException {
        ArrayList<String> fullCommandLineArgs = new ArrayList<String>(Arrays.asList(QuotationAwareTokenizer.tokenizeLine(this.mConfiguration.getCommandLine())));
        fullCommandLineArgs.remove(0);
        ConfigurationCtsParserSettings ctsParserSettings = new ConfigurationCtsParserSettings();
        ArgsOptionParser ctsOptionParser = new ArgsOptionParser(ctsParserSettings);
        ctsOptionParser.parseBestEffort(fullCommandLineArgs, true);
        List<String> ctsParams = ctsParserSettings.mCtsParams;
        String configName = ctsParserSettings.mConfigName;
        if (configName == null) {
            if (this.mDefaultConfigName == null) {
                throw new ConfigurationException(String.format("Failed to extract config-name from parent test command options, unable to build args to invoke tradefed observatory. Parent test command options is: %s", fullCommandLineArgs));
            }
            LogUtil.CLog.i(String.format("No config name provided in the command args, use default config name %s", this.mDefaultConfigName));
            configName = this.mDefaultConfigName;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getJava());
        args.add("-cp");
        args.add(classpath);
        args.add(String.format("-D%s=%s", ctsParserSettings.mRootdirVar, this.mRootDir.getAbsolutePath()));
        args.add(TRADEFED_OBSERVATORY_ENTRY_PATH);
        args.add(configName);
        args.addAll(StringEscapeUtils.paramsToArgs(ctsParams));
        return args;
    }

    private String buildTestMappingClasspath(File workingDir) throws IOException {
        ArrayList<String> classpathList = new ArrayList<String>();
        if (!workingDir.exists()) {
            throw new FileNotFoundException("Couldn't find the build directory");
        }
        if (workingDir.listFiles().length == 0) {
            throw new FileNotFoundException(String.format("Could not find any files under %s", workingDir.getAbsolutePath()));
        }
        for (File toolsFile : workingDir.listFiles()) {
            if (!toolsFile.getName().endsWith(".jar")) continue;
            classpathList.add(toolsFile.getAbsolutePath());
        }
        Collections.sort(classpathList);
        if (this.mUseCurrentTradefed) {
            classpathList.add(this.getCurrentClassPath());
        }
        return Joiner.on(":").join(classpathList);
    }

    private String getCurrentClassPath() {
        return System.getProperty("java.class.path");
    }

    private String buildXtsClasspath(File ctsRoot) throws IOException {
        ArrayList<File> classpathList = new ArrayList<File>();
        if (!ctsRoot.exists()) {
            throw new FileNotFoundException("Couldn't find the build directory: " + ctsRoot);
        }
        if (ctsRoot.list().length != 1) {
            throw new RuntimeException("List of sub directory does not contain only one item current list is:" + Arrays.toString(ctsRoot.list()));
        }
        String mainDirName = ctsRoot.list()[0];
        File jarCtsPath = new File(new File(ctsRoot, mainDirName), "tools");
        if (jarCtsPath.listFiles().length == 0) {
            throw new FileNotFoundException(String.format("Could not find any files under %s", jarCtsPath.getAbsolutePath()));
        }
        for (File toolsFile : jarCtsPath.listFiles()) {
            if (!toolsFile.getName().endsWith(".jar")) continue;
            classpathList.add(toolsFile);
        }
        Collections.sort(classpathList);
        return Joiner.on(":").join(classpathList);
    }

    private List<String> parseTestDiscoveryOutput(String discoveryOutput, String dependencyListKey) throws JSONException {
        JSONObject jsonObject = new JSONObject(discoveryOutput);
        ArrayList<String> testModules = new ArrayList<String>();
        if (jsonObject.has(dependencyListKey)) {
            JSONArray jsonArray = jsonObject.getJSONArray(dependencyListKey);
            for (int i = 0; i < jsonArray.length(); ++i) {
                testModules.add(jsonArray.getString(i));
            }
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_DISCOVERY_MODULE_COUNT, testModules.size());
        if (testModules.isEmpty()) {
            this.mConfiguration.getSkipManager().reportDiscoveryWithNoTests();
        }
        return testModules;
    }

    private String parsePartialFallback(String discoveryOutput) throws JSONException {
        JSONObject jsonObject = new JSONObject(discoveryOutput);
        if (jsonObject.has(PARTIAL_FALLBACK_KEY)) {
            return jsonObject.getString(PARTIAL_FALLBACK_KEY);
        }
        return null;
    }
}

