/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.BasePostProcessor;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.MetricUtility;
import com.google.common.collect.ArrayListMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@OptionClass(alias="aggregate-post-processor")
public class AggregatePostProcessor
extends BasePostProcessor {
    @Option(name="report-percentiles", description="Additional percentiles of each metric to report, in integers in the 0 - 100 range. Can be repeated.")
    private Set<Integer> mPercentiles = new HashSet<Integer>();
    private static final String STATS_KEY_SEPARATOR = "-";
    private HashMap<String, ArrayListMultimap<String, MetricMeasurement.Metric>> mStoredTestMetrics = new HashMap();

    @Override
    public Map<String, MetricMeasurement.Metric.Builder> processTestMetricsAndLogs(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> testMetrics, Map<String, LogFile> testLogs) {
        String fullTestName = testDescription.toString();
        if (!this.mStoredTestMetrics.containsKey(fullTestName)) {
            this.mStoredTestMetrics.put(fullTestName, ArrayListMultimap.create());
        }
        ArrayListMultimap<String, MetricMeasurement.Metric> storedMetricsForThisTest = this.mStoredTestMetrics.get(fullTestName);
        for (Map.Entry<String, MetricMeasurement.Metric> entry : testMetrics.entrySet()) {
            storedMetricsForThisTest.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        HashMap<String, MetricMeasurement.Metric.Builder> aggregateMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (String metricKey : storedMetricsForThisTest.keySet()) {
            List metrics = storedMetricsForThisTest.get((Object)metricKey);
            List measures = metrics.stream().map(MetricMeasurement.Metric::getMeasurements).collect(Collectors.toList());
            List<String> rawValues = measures.stream().map(MetricMeasurement.Measurements::getSingleString).map(m -> {
                List<String> splitVals = Arrays.asList(m.split(",", 0));
                if (splitVals.size() == 1 && splitVals.get(0).isEmpty()) {
                    return Collections.emptyList();
                }
                return splitVals;
            }).flatMap(Collection::stream).map(String::trim).collect(Collectors.toList());
            if (rawValues.isEmpty() || !MetricUtility.isAllDoubleValues(rawValues)) continue;
            this.buildStats(metricKey, rawValues, aggregateMetrics);
        }
        return aggregateMetrics;
    }

    @Override
    public Map<String, MetricMeasurement.Metric.Builder> processRunMetricsAndLogs(HashMap<String, MetricMeasurement.Metric> rawMetrics, Map<String, LogFile> runLogs) {
        HashMap<String, MetricMeasurement.Metric.Builder> aggregateMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (Map.Entry<String, MetricMeasurement.Metric> entry : rawMetrics.entrySet()) {
            String values2 = entry.getValue().getMeasurements().getSingleString();
            List<String> splitVals = Arrays.asList(values2.split(",", 0));
            if (!MetricUtility.isAllDoubleValues(splitVals)) continue;
            this.buildStats(entry.getKey(), splitVals, aggregateMetrics);
        }
        return aggregateMetrics;
    }

    private void buildStats(String metricKey, List<String> values2, Map<String, MetricMeasurement.Metric.Builder> aggregateMetrics) {
        List<Double> doubleValues = values2.stream().map(Double::parseDouble).collect(Collectors.toList());
        Map<String, Double> stats = MetricUtility.getStats(doubleValues, this.mPercentiles);
        for (String statKey : stats.keySet()) {
            MetricMeasurement.Metric.Builder metricBuilder = MetricMeasurement.Metric.newBuilder();
            metricBuilder.getMeasurementsBuilder().setSingleString(String.format("%2.2f", stats.get(statKey)));
            aggregateMetrics.put(String.join((CharSequence)STATS_KEY_SEPARATOR, metricKey, statKey), metricBuilder);
        }
    }
}

