/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.BasePostProcessor;
import com.android.tradefed.result.LogFile;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AveragePostProcessor
extends BasePostProcessor {
    public static final String AVERAGE_KEY_TAG = "_avg";

    @Override
    public Map<String, MetricMeasurement.Metric.Builder> processRunMetricsAndLogs(HashMap<String, MetricMeasurement.Metric> rawMetrics, Map<String, LogFile> runLogs) {
        HashMap<String, MetricMeasurement.Metric.Builder> newMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (String key : rawMetrics.keySet()) {
            MetricMeasurement.NumericValues numValues;
            double avg;
            MetricMeasurement.Metric metric = rawMetrics.get(key);
            MetricMeasurement.Measurements measure = metric.getMeasurements();
            MetricMeasurement.Measurements.MeasurementCase measureCase = measure.getMeasurementCase();
            if (MetricMeasurement.Measurements.MeasurementCase.DOUBLE_VALUES.equals(measureCase)) {
                MetricMeasurement.DoubleValues doubleValues = measure.getDoubleValues();
                if (doubleValues.getDoubleValueList().size() <= 0) continue;
                avg = doubleValues.getDoubleValueList().stream().collect(Collectors.summarizingDouble(Double::doubleValue)).getAverage();
                newMetrics.put(key + AVERAGE_KEY_TAG, this.createAvgMetric(avg, metric));
                continue;
            }
            if (!MetricMeasurement.Measurements.MeasurementCase.NUMERIC_VALUES.equals(measureCase) || (numValues = measure.getNumericValues()).getNumericValueList().size() <= 0) continue;
            avg = numValues.getNumericValueList().stream().collect(Collectors.summarizingLong(Long::longValue)).getAverage();
            newMetrics.put(key + AVERAGE_KEY_TAG, this.createAvgMetric(avg, metric));
        }
        return newMetrics;
    }

    private MetricMeasurement.Metric.Builder createAvgMetric(double avg, MetricMeasurement.Metric originalMetric) {
        MetricMeasurement.Metric.Builder builder = MetricMeasurement.Metric.newBuilder();
        builder.setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleDouble(avg).build());
        builder.setUnit(originalMetric.getUnit());
        return builder;
    }
}

