/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.IPostProcessor;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BasePostProcessor
implements IPostProcessor {
    @Option(name="disable", description="disables the post processor.")
    private boolean mDisable = false;
    private ITestInvocationListener mForwarder;
    private ArrayListMultimap<String, MetricMeasurement.Metric> storedTestMetrics = ArrayListMultimap.create();
    private Map<TestDescription, Map<String, LogFile>> mTestLogs = new LinkedHashMap<TestDescription, Map<String, LogFile>>();
    private Map<String, LogFile> mRunLogs = new HashMap<String, LogFile>();
    private TestDescription mCurrentTest = null;
    private ILogSaver mLogSaver = null;
    private boolean mIsPostProcessing = false;
    private String mRunName;

    @Override
    public abstract Map<String, MetricMeasurement.Metric.Builder> processRunMetricsAndLogs(HashMap<String, MetricMeasurement.Metric> var1, Map<String, LogFile> var2);

    @Override
    public Map<String, MetricMeasurement.Metric.Builder> processTestMetricsAndLogs(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> testMetrics, Map<String, LogFile> testLogs) {
        return new HashMap<String, MetricMeasurement.Metric.Builder>();
    }

    @Override
    public Map<String, MetricMeasurement.Metric.Builder> processAllTestMetricsAndLogs(ListMultimap<String, MetricMeasurement.Metric> allTestMetrics, Map<TestDescription, Map<String, LogFile>> allTestLogs) {
        return new HashMap<String, MetricMeasurement.Metric.Builder>();
    }

    @Override
    public final ITestInvocationListener init(ITestInvocationListener listener) {
        long start = System.currentTimeMillis();
        this.setUp();
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
        this.mForwarder = listener;
        return this;
    }

    @Override
    public final boolean isDisabled() {
        return this.mDisable;
    }

    @Override
    public final void invocationStarted(IInvocationContext context) {
        this.mForwarder.invocationStarted(context);
    }

    @Override
    public final void invocationFailed(Throwable cause) {
        this.mForwarder.invocationFailed(cause);
    }

    @Override
    public final void invocationFailed(FailureDescription failure) {
        this.mForwarder.invocationFailed(failure);
    }

    @Override
    public final void invocationEnded(long elapsedTime) {
        this.mForwarder.invocationEnded(elapsedTime);
    }

    @Override
    public final void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        if (this.mIsPostProcessing) {
            LogUtil.CLog.i("Saving file with data name %s in post processor.", dataName);
            if (this.mLogSaver != null) {
                try {
                    LogFile log = null;
                    log = dataStream instanceof FileInputStreamSource ? this.mLogSaver.saveLogFile(dataName, dataType, ((FileInputStreamSource)dataStream).getFile()) : this.mLogSaver.saveLogData(dataName, dataType, dataStream.createInputStream());
                    this.testLogSaved(dataName, dataType, dataStream, log);
                    this.logAssociation(dataName, log);
                }
                catch (IOException e) {
                    LogUtil.CLog.e("Failed to save log file %s.", dataName);
                    LogUtil.CLog.e(e);
                }
            } else {
                LogUtil.CLog.e("Attempting to save log in post processor when its log saver is not set.");
            }
        }
        this.mForwarder.testLog(dataName, dataType, dataStream);
    }

    @Override
    public final void testModuleStarted(IInvocationContext moduleContext) {
        this.mForwarder.testModuleStarted(moduleContext);
    }

    @Override
    public final void testModuleEnded() {
        this.mForwarder.testModuleEnded();
    }

    @Override
    public final void testRunStarted(String runName, int testCount) {
        this.testRunStarted(runName, testCount, 0, System.currentTimeMillis());
    }

    @Override
    public final void testRunStarted(String runName, int testCount, int attemptNumber) {
        this.testRunStarted(runName, testCount, attemptNumber, System.currentTimeMillis());
    }

    @Override
    public final void testRunStarted(String runName, int testCount, int attemptNumber, long startTime) {
        this.mRunName = runName;
        this.mForwarder.testRunStarted(runName, testCount, attemptNumber, startTime);
    }

    @Override
    public final void testRunFailed(String errorMessage) {
        this.mForwarder.testRunFailed(errorMessage);
    }

    @Override
    public final void testRunFailed(FailureDescription failure) {
        this.mForwarder.testRunFailed(failure);
    }

    @Override
    public final void testRunStopped(long elapsedTime) {
        this.mForwarder.testRunStopped(elapsedTime);
    }

    @Override
    public final void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        this.testRunEnded(elapsedTime, TfMetricProtoUtil.upgradeConvert(runMetrics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        long start = System.currentTimeMillis();
        this.mIsPostProcessing = true;
        try (CloseableTraceScope ignored = new CloseableTraceScope("run_processor_" + this.getClass().getSimpleName());){
            HashMap<String, MetricMeasurement.Metric> rawValues = this.getRawMetricsOnly(runMetrics);
            Map<String, MetricMeasurement.Metric.Builder> postprocessedResults = this.processRunMetricsAndLogs(rawValues, this.mRunLogs);
            this.addProcessedMetricsToExistingMetrics(postprocessedResults, runMetrics);
            Map<String, MetricMeasurement.Metric.Builder> aggregateResults = this.processAllTestMetricsAndLogs(this.storedTestMetrics, this.mTestLogs);
            this.addProcessedMetricsToExistingMetrics(aggregateResults, runMetrics);
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e(e);
        }
        finally {
            this.storedTestMetrics.clear();
            this.mTestLogs.clear();
            this.mRunLogs.clear();
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
        }
        this.mIsPostProcessing = false;
        this.mForwarder.testRunEnded(elapsedTime, runMetrics);
    }

    @Override
    public final void testStarted(TestDescription test) {
        this.testStarted(test, System.currentTimeMillis());
    }

    @Override
    public final void testStarted(TestDescription test, long startTime) {
        this.mCurrentTest = test;
        if (this.mTestLogs.containsKey(test)) {
            this.mTestLogs.get(test).clear();
        } else {
            this.mTestLogs.put(test, new HashMap());
        }
        this.mForwarder.testStarted(test, startTime);
    }

    @Override
    public final void testFailed(TestDescription test, String trace) {
        this.mForwarder.testFailed(test, trace);
    }

    @Override
    public final void testFailed(TestDescription test, FailureDescription failure) {
        this.mForwarder.testFailed(test, failure);
    }

    @Override
    public final void testEnded(TestDescription test, Map<String, String> testMetrics) {
        this.testEnded(test, System.currentTimeMillis(), testMetrics);
    }

    @Override
    public final void testEnded(TestDescription test, long endTime, Map<String, String> testMetrics) {
        this.testEnded(test, endTime, TfMetricProtoUtil.upgradeConvert(testMetrics));
    }

    @Override
    public final void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.testEnded(test, System.currentTimeMillis(), testMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.mIsPostProcessing = true;
        long start = System.currentTimeMillis();
        try {
            HashMap<String, MetricMeasurement.Metric> rawValues = this.getRawMetricsOnly(testMetrics);
            for (Map.Entry<String, MetricMeasurement.Metric> entry : rawValues.entrySet()) {
                this.storedTestMetrics.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            Map<String, MetricMeasurement.Metric.Builder> results = this.processTestMetricsAndLogs(test, rawValues, this.mTestLogs.containsKey(test) ? this.mTestLogs.get(test) : new HashMap<String, LogFile>());
            for (Map.Entry<String, MetricMeasurement.Metric.Builder> newEntry : results.entrySet()) {
                String newKey = newEntry.getKey();
                if (testMetrics.containsKey(newKey)) {
                    LogUtil.CLog.e("Key '%s' is already asssociated with a metric and will not be replaced.", newKey);
                    continue;
                }
                MetricMeasurement.Metric newMetric = newEntry.getValue().setType(this.getMetricType()).build();
                testMetrics.put(newKey, newMetric);
            }
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e(e);
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
        }
        this.mIsPostProcessing = false;
        this.mCurrentTest = null;
        this.mForwarder.testEnded(test, endTime, testMetrics);
    }

    @Override
    public final void testAssumptionFailure(TestDescription test, String trace) {
        this.mForwarder.testAssumptionFailure(test, trace);
    }

    @Override
    public final void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        this.mForwarder.testAssumptionFailure(test, failure);
    }

    @Override
    public final void testIgnored(TestDescription test) {
        this.mForwarder.testIgnored(test);
    }

    public void setUp() {
    }

    @Override
    public final void setLogSaver(ILogSaver logSaver) {
        this.mLogSaver = logSaver;
        if (this.mForwarder instanceof ILogSaverListener) {
            ((ILogSaverListener)this.mForwarder).setLogSaver(logSaver);
        }
    }

    @Override
    public final void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        if (this.mForwarder instanceof ILogSaverListener) {
            ((ILogSaverListener)this.mForwarder).testLogSaved(dataName, dataType, dataStream, logFile);
        }
    }

    @Override
    public final void logAssociation(String dataName, LogFile logFile) {
        if (!this.mIsPostProcessing) {
            if (this.mCurrentTest != null) {
                this.mTestLogs.get(this.mCurrentTest).put(dataName, logFile);
            } else {
                this.mRunLogs.put(dataName, logFile);
            }
        }
        if (this.mForwarder instanceof ILogSaverListener) {
            ((ILogSaverListener)this.mForwarder).logAssociation(dataName, logFile);
        }
    }

    private HashMap<String, MetricMeasurement.Metric> getRawMetricsOnly(HashMap<String, MetricMeasurement.Metric> runMetrics) {
        HashMap<String, MetricMeasurement.Metric> rawMetrics = new HashMap<String, MetricMeasurement.Metric>();
        for (Map.Entry<String, MetricMeasurement.Metric> entry : runMetrics.entrySet()) {
            if (!MetricMeasurement.DataType.RAW.equals(entry.getValue().getType())) continue;
            rawMetrics.put(entry.getKey(), entry.getValue());
        }
        return rawMetrics;
    }

    private void addProcessedMetricsToExistingMetrics(Map<String, MetricMeasurement.Metric.Builder> processed, Map<String, MetricMeasurement.Metric> existing) {
        for (Map.Entry<String, MetricMeasurement.Metric.Builder> newEntry : processed.entrySet()) {
            String newKey = newEntry.getKey();
            if (existing.containsKey(newKey)) {
                LogUtil.CLog.e("Key '%s' is already asssociated with a metric and will not be replaced.", newKey);
                continue;
            }
            MetricMeasurement.Metric newMetric = newEntry.getValue().setType(this.getMetricType()).build();
            existing.put(newKey, newMetric);
        }
    }

    protected MetricMeasurement.DataType getMetricType() {
        return MetricMeasurement.DataType.PROCESSED;
    }

    protected String getRunName() {
        return this.mRunName;
    }
}

