/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.BasePostProcessor;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.MetricUtility;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="metric-file-post-processor")
public class MetricFilePostProcessor
extends BasePostProcessor {
    private static final String AGGREGATE_TEST_SUFFIX = "_aggregate_test_metrics";
    private static final String AGGREGATE_RUN_SUFFIX = "_aggregate_run_metrics";
    @Option(name="enable-per-test-log", description="Set this flag to false to disable writing the per test metrics to a file.")
    private boolean mIsPerTestLogEnabled = true;
    @Option(name="enable-run-log", description="Set this flag to false to disable writing the run metrics to a file.")
    private boolean mIsRunLogEnabled = true;
    @Option(name="aggregate-similar-tests", description="To aggregate the metrics from test cases which differ only by iteration number or having the same test name. Used only in context with the microbenchmark test runner. Set this flag to false to disable aggregating the metrics.")
    private boolean mAggregateSimilarTests = false;
    @Option(name="aggregate-run-metrics", description="Aggregate run metrics which has more than one value.")
    private boolean mAggregateRunMetrics = false;
    @Option(name="test-iteration-separator", description="Separator used in between the test class name and the iteration number.")
    private String mTestIterationSeparator = "$";
    @Option(name="report-percentiles", description="Additional percentiles of each metric to report in integers in the 0 - 100 range. Can be repeated.")
    private Set<Integer> mPercentiles = new HashSet<Integer>();
    private MetricUtility mMetricUtil = new MetricUtility();

    public MetricFilePostProcessor() {
    }

    public MetricFilePostProcessor(MetricUtility metricUtil) {
        this.mMetricUtil = metricUtil;
    }

    @Override
    public Map<String, MetricMeasurement.Metric.Builder> processTestMetricsAndLogs(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> testMetrics, Map<String, LogFile> testLogs) {
        if (this.mAggregateSimilarTests) {
            this.mMetricUtil.storeTestMetrics(testDescription, testMetrics);
        }
        if (this.mIsPerTestLogEnabled) {
            this.writeMetricFile(testMetrics, testDescription.toString());
        }
        return new HashMap<String, MetricMeasurement.Metric.Builder>();
    }

    @Override
    public Map<String, MetricMeasurement.Metric.Builder> processRunMetricsAndLogs(HashMap<String, MetricMeasurement.Metric> rawMetrics, Map<String, LogFile> runLogs) {
        File aggregateTestResultsFile;
        if (this.mIsRunLogEnabled) {
            this.writeMetricFile(rawMetrics, this.getRunName());
            if (this.mAggregateRunMetrics) {
                Map<String, MetricMeasurement.Metric> aggregatedRunMetrics = this.mMetricUtil.aggregateMetrics(rawMetrics);
                this.writeMetricFile(aggregatedRunMetrics, this.getRunName() + AGGREGATE_RUN_SUFFIX);
            }
        }
        if (this.mAggregateSimilarTests && (aggregateTestResultsFile = this.mMetricUtil.aggregateStoredTestMetricsAndWriteToFile(this.getRunName() + AGGREGATE_TEST_SUFFIX)) != null) {
            try (FileInputStreamSource source = new FileInputStreamSource(aggregateTestResultsFile, true);){
                this.testLog(aggregateTestResultsFile.getName(), LogDataType.CB_METRICS_FILE, source);
            }
        }
        return new HashMap<String, MetricMeasurement.Metric.Builder>();
    }

    public void writeMetricFile(Map<String, MetricMeasurement.Metric> metrics, String testId) {
        Map<String, String> compatibleMetrics = TfMetricProtoUtil.compatibleConvert(metrics);
        File metricFile = this.mMetricUtil.writeResultsToFile(testId, testId, compatibleMetrics, null);
        if (metricFile != null) {
            try (FileInputStreamSource source = new FileInputStreamSource(metricFile, true);){
                this.testLog(metricFile.getName(), LogDataType.CB_METRICS_FILE, source);
            }
        }
    }

    @Override
    public void setUp() {
        this.mMetricUtil.setPercentiles(this.mPercentiles);
        this.mMetricUtil.setIterationSeparator(this.mTestIterationSeparator);
    }
}

