/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.retry.MergeStrategy;
import com.android.tradefed.util.IDisableable;
import com.android.tradefed.util.MultiMap;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class CollectingTestListener
implements ITestInvocationListener,
ILogSaverListener,
IDisableable {
    @Option(name="aggregate-metrics", description="attempt to add test metrics values for test runs with the same name.")
    private boolean mIsAggregateMetrics = false;
    @Option(name="disable", description="Whether or not to disable this reporter.")
    private boolean mDisable = false;
    private IInvocationContext mContext;
    private IBuildInfo mBuildInfo;
    private Map<String, IInvocationContext> mModuleContextMap = new HashMap<String, IInvocationContext>();
    private Map<String, List<TestRunResult>> mTestRunResultMap = Collections.synchronizedMap(new LinkedHashMap());
    private IInvocationContext mCurrentModuleContext = null;
    private TestRunResult mCurrentTestRunResult = new TestRunResult();
    private boolean mDefaultRun = true;
    private boolean mRunInProgress = false;
    private MultiMap<String, LogFile> mModuleLogFiles = new MultiMap();
    private MultiMap<String, LogFile> mNonAssociatedLogFiles = new MultiMap();
    private AtomicBoolean mIsCountDirty = new AtomicBoolean(true);
    private AtomicBoolean mIsExpectedCountDirty = new AtomicBoolean(true);
    private int mExpectedCount = 0;
    private final List<TestRunResult> mMergedTestRunResults = new ArrayList<TestRunResult>();
    private int[] mStatusCounts = new int[TestResult.TestStatus.values().length];
    private MergeStrategy mStrategy = MergeStrategy.ONE_TESTCASE_PASS_IS_PASS;

    protected void setIsAggregrateMetrics(boolean aggregate) {
        this.mIsAggregateMetrics = aggregate;
    }

    public void setMergeStrategy(MergeStrategy strategy) {
        this.mStrategy = strategy;
    }

    public IBuildInfo getPrimaryBuildInfo() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getBuildInfos().get(0);
    }

    public IInvocationContext getInvocationContext() {
        return this.mContext;
    }

    @Deprecated
    public IBuildInfo getBuildInfo() {
        return this.mBuildInfo;
    }

    @Deprecated
    @VisibleForTesting
    public void setBuildInfo(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        this.mContext = context;
        this.mBuildInfo = this.getPrimaryBuildInfo();
    }

    @Override
    public void invocationEnded(long elapsedTime) {
    }

    @Override
    public void invocationFailed(Throwable cause) {
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        this.mCurrentModuleContext = moduleContext;
    }

    @Override
    public void testModuleEnded() {
        this.mCurrentModuleContext = null;
    }

    @Override
    public void testRunStarted(String name, int numTests) {
        this.testRunStarted(name, numTests, 0);
    }

    @Override
    public void testRunStarted(String name, int numTests, int attemptNumber) {
        this.testRunStarted(name, numTests, attemptNumber, System.currentTimeMillis());
    }

    @Override
    public void testRunStarted(String name, int numTests, int attemptNumber, long startTime) {
        List<TestRunResult> results;
        this.setCountDirty();
        this.mIsExpectedCountDirty.set(true);
        if (this.mCurrentModuleContext != null) {
            this.mModuleContextMap.put(name, this.mCurrentModuleContext);
        }
        if (!this.mTestRunResultMap.containsKey(name)) {
            this.mTestRunResultMap.put(name, new LinkedList());
        }
        if (attemptNumber < (results = this.mTestRunResultMap.get(name)).size()) {
            if (results.get(attemptNumber) == null) {
                throw new RuntimeException("Test run results should never be null in internal structure.");
            }
        } else if (attemptNumber == results.size()) {
            TestRunResult result = this.getNewRunResult();
            results.add(result);
        } else {
            int size;
            for (int i = size = results.size(); i < attemptNumber; ++i) {
                TestRunResult result = this.getNewRunResult();
                result.testRunStarted(name, numTests, startTime);
                String errorMessage = String.format("Run attempt %s of %s did not exists, but got attempt %s. This is a placeholder for the missing attempt.", i, name, attemptNumber);
                result.testRunFailed(errorMessage);
                result.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
                results.add(result);
            }
            TestRunResult newResult = this.getNewRunResult();
            results.add(newResult);
        }
        this.mCurrentTestRunResult = results.get(attemptNumber);
        this.mCurrentTestRunResult.testRunStarted(name, numTests, startTime);
        this.mRunInProgress = true;
    }

    private TestRunResult getNewRunResult() {
        TestRunResult result = new TestRunResult();
        if (this.mDefaultRun) {
            result = this.mCurrentTestRunResult;
            this.mDefaultRun = false;
        }
        result.setAggregateMetrics(this.mIsAggregateMetrics);
        return result;
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testRunEnded(elapsedTime, runMetrics);
        this.mRunInProgress = false;
    }

    @Override
    public void testRunFailed(String errorMessage) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testRunFailed(errorMessage);
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testRunFailed(failure);
    }

    @Override
    public void testRunStopped(long elapsedTime) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testRunStopped(elapsedTime);
    }

    @Override
    public void testStarted(TestDescription test) {
        this.testStarted(test, System.currentTimeMillis());
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testStarted(test, startTime);
    }

    @Override
    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.testEnded(test, System.currentTimeMillis(), testMetrics);
    }

    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testEnded(test, endTime, testMetrics);
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testFailed(test, trace);
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testFailed(test, failure);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, String trace) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testAssumptionFailure(test, trace);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testAssumptionFailure(test, failure);
    }

    @Override
    public void testIgnored(TestDescription test) {
        this.setCountDirty();
        this.mCurrentTestRunResult.testIgnored(test);
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        if (this.mRunInProgress) {
            this.mCurrentTestRunResult.testLogSaved(dataName, logFile);
        } else if (this.mCurrentModuleContext != null) {
            this.mModuleLogFiles.put(dataName, logFile);
        } else {
            this.mNonAssociatedLogFiles.put(dataName, logFile);
        }
    }

    public TestRunResult getCurrentRunResults() {
        return this.mCurrentTestRunResult;
    }

    public int getNumTotalTests() {
        this.computeMergedResults();
        int total = 0;
        for (TestResult.TestStatus s : TestResult.TestStatus.values()) {
            total += this.mStatusCounts[s.ordinal()];
        }
        return total;
    }

    public synchronized int getExpectedTests() {
        if (!this.mIsExpectedCountDirty.compareAndSet(true, false)) {
            return this.mExpectedCount;
        }
        this.computeMergedResults();
        this.mExpectedCount = 0;
        for (TestRunResult result : this.getMergedTestRunResults()) {
            this.mExpectedCount += result.getExpectedTestCount();
        }
        return this.mExpectedCount;
    }

    public int getNumTestsInState(TestResult.TestStatus status) {
        this.computeMergedResults();
        return this.mStatusCounts[status.ordinal()];
    }

    public boolean hasFailedTests() {
        return this.getNumAllFailedTests() > 0;
    }

    public int getNumAllFailedTestRuns() {
        int count = 0;
        for (TestRunResult result : this.getMergedTestRunResults()) {
            if (!result.isRunFailure()) continue;
            ++count;
        }
        return count;
    }

    public int getNumAllFailedTests() {
        return this.getNumTestsInState(TestResult.TestStatus.FAILURE);
    }

    public List<TestRunResult> getMergedTestRunResults() {
        this.computeMergedResults();
        return new ArrayList<TestRunResult>(this.mMergedTestRunResults);
    }

    @Deprecated
    public Collection<TestRunResult> getRunResults() {
        return this.getMergedTestRunResults();
    }

    private synchronized void computeMergedResults() {
        if (!this.mIsCountDirty.compareAndSet(true, false)) {
            return;
        }
        this.mMergedTestRunResults.clear();
        if (this.mTestRunResultMap.isEmpty() && this.mCurrentTestRunResult.isRunFailure()) {
            LogUtil.CLog.e("Early failure resulting in no testRunStart. Results might be inconsistent:\n%s", this.mCurrentTestRunResult.getRunFailureMessage());
            this.mMergedTestRunResults.add(this.mCurrentTestRunResult);
        } else {
            for (Map.Entry<String, List<TestRunResult>> results : this.mTestRunResultMap.entrySet()) {
                TestRunResult res = TestRunResult.merge(results.getValue(), this.mStrategy);
                if (res == null) {
                    LogUtil.CLog.w("No results for %s", results.getKey());
                    continue;
                }
                this.mMergedTestRunResults.add(res);
            }
        }
        for (TestResult.TestStatus s : TestResult.TestStatus.values()) {
            this.mStatusCounts[s.ordinal()] = 0;
        }
        for (TestRunResult result : this.mMergedTestRunResults) {
            for (TestResult.TestStatus s : TestResult.TestStatus.values()) {
                int n = s.ordinal();
                this.mStatusCounts[n] = this.mStatusCounts[n] + result.getNumTestsInState(s);
            }
        }
    }

    private void setCountDirty() {
        this.mIsCountDirty.set(true);
    }

    public Collection<String> getTestRunNames() {
        return new ArrayList<String>(this.mTestRunResultMap.keySet());
    }

    public List<TestRunResult> getTestRunAttempts(String testRunName) {
        return this.mTestRunResultMap.get(testRunName);
    }

    public List<TestRunResult> getTestRunForAttempts(int attempt) {
        ArrayList<TestRunResult> allResultForAttempts = new ArrayList<TestRunResult>();
        for (Map.Entry<String, List<TestRunResult>> runInfo : this.mTestRunResultMap.entrySet()) {
            if (attempt >= runInfo.getValue().size()) continue;
            TestRunResult attemptRes = runInfo.getValue().get(attempt);
            allResultForAttempts.add(attemptRes);
        }
        return allResultForAttempts;
    }

    public boolean hasTestRunResultsForName(String testRunName) {
        return this.mTestRunResultMap.containsKey(testRunName);
    }

    public int getTestRunAttemptCount(String testRunName) {
        List<TestRunResult> results = this.mTestRunResultMap.get(testRunName);
        if (results == null) {
            return 0;
        }
        return results.size();
    }

    public TestRunResult getTestRunAtAttempt(String testRunName, int attempt) {
        List<TestRunResult> results = this.mTestRunResultMap.get(testRunName);
        if (results == null || attempt < 0 || attempt >= results.size()) {
            return null;
        }
        return results.get(attempt);
    }

    public IInvocationContext getModuleContextForRunResult(String testRunName) {
        return this.mModuleContextMap.get(testRunName);
    }

    public MultiMap<String, LogFile> getModuleLogFiles() {
        return new MultiMap<String, LogFile>(this.mModuleLogFiles);
    }

    public MultiMap<String, LogFile> getNonAssociatedLogFiles() {
        return new MultiMap<String, LogFile>(this.mNonAssociatedLogFiles);
    }

    protected final synchronized void clearResultsForName(String testRunName) {
        this.setCountDirty();
        this.mTestRunResultMap.remove(testRunName);
    }

    protected final synchronized void clearModuleLogFiles() {
        this.mModuleLogFiles = new MultiMap();
    }

    @Override
    public boolean isDisabled() {
        return this.mDisable;
    }

    @Override
    public void setDisable(boolean isDisabled) {
        this.mDisable = isDisabled;
    }
}

