/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.result.CountingTestResultListener;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestResultListener;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="console-result-reporter")
public class ConsoleResultReporter
extends TestResultListener
implements ILogSaverListener,
ITestInvocationListener {
    private static final SimpleDateFormat sTimeStampFormat = new SimpleDateFormat("HH:mm:ss");
    @Option(name="suppress-passed-tests", description="For functional tests, ommit summary for passing tests, only print failed and ignored ones")
    private boolean mSuppressPassedTest = false;
    @Option(name="display-failure-summary", description="Display all the failures at the very end for easier visualization.")
    private boolean mDisplayFailureSummary = true;
    @Option(name="display-invocation-attributes", description="Display all the invocation attributes at the very end for easier visualization.")
    private boolean mDisplayInvocationAttributes = false;
    private final PrintStream mStream;
    private Set<LogFile> mLoggedFiles = new LinkedHashSet<LogFile>();
    private Map<TestDescription, TestResult> mFailures = new LinkedHashMap<TestDescription, TestResult>();
    private String mTestTag;
    private String mRunInProgress;
    private CountingTestResultListener mResultCountListener = new CountingTestResultListener();
    private IInvocationContext mContext;

    public ConsoleResultReporter() {
        this(System.out);
    }

    ConsoleResultReporter(PrintStream outputStream) {
        this.mStream = outputStream;
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        this.mTestTag = context.getTestTag();
        this.mContext = context;
    }

    @Override
    public void testResult(TestDescription test, TestResult result) {
        this.mResultCountListener.testResult(test, result);
        if (this.mSuppressPassedTest && TestResult.TestStatus.PASSED.equals((Object)result.getStatus())) {
            return;
        }
        if (this.mDisplayFailureSummary && TestResult.TestStatus.FAILURE.equals((Object)result.getStatus())) {
            this.mFailures.put(test, result);
        }
        this.print(ConsoleResultReporter.getTestSummary(this.mTestTag, test, result));
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        super.testRunStarted(runName, testCount);
        this.mRunInProgress = runName;
    }

    @Override
    public void testRunFailed(String errorMessage) {
        this.print(String.format("%s: run failed: %s\n", this.mRunInProgress, errorMessage));
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        this.print(String.format("%s: run failed: %s\n", this.mRunInProgress, failure));
    }

    @Override
    public void testRunEnded(long elapsedTimeMillis, Map<String, String> metrics) {
        super.testRunEnded(elapsedTimeMillis, metrics);
        if (metrics != null && !metrics.isEmpty()) {
            String tag = this.mTestTag != null ? this.mTestTag : "unknown";
            String runName = this.mRunInProgress != null ? this.mRunInProgress : "unknown";
            StringBuilder sb = new StringBuilder(tag);
            sb.append(": ");
            sb.append(runName);
            sb.append(": ");
            ArrayList<String> metricKeys = new ArrayList<String>(metrics.keySet());
            Collections.sort(metricKeys);
            for (String metricKey : metricKeys) {
                sb.append(String.format("%s=%s\n", metricKey, metrics.get(metricKey)));
            }
            this.print(sb.toString());
        }
        this.mRunInProgress = null;
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        int[] results = this.mResultCountListener.getResultCounts();
        StringBuilder sb = new StringBuilder();
        sb.append("========== Result Summary ==========");
        sb.append(String.format("\nResults summary for test-tag '%s': ", this.mTestTag));
        sb.append(this.mResultCountListener.getTotalTests());
        sb.append(" Tests [");
        sb.append(results[TestResult.TestStatus.PASSED.ordinal()]);
        sb.append(" Passed");
        if (results[TestResult.TestStatus.FAILURE.ordinal()] > 0) {
            sb.append(" ");
            sb.append(results[TestResult.TestStatus.FAILURE.ordinal()]);
            sb.append(" Failed");
        }
        if (results[TestResult.TestStatus.IGNORED.ordinal()] > 0) {
            sb.append(" ");
            sb.append(results[TestResult.TestStatus.IGNORED.ordinal()]);
            sb.append(" Ignored");
        }
        if (results[TestResult.TestStatus.ASSUMPTION_FAILURE.ordinal()] > 0) {
            sb.append(" ");
            sb.append(results[TestResult.TestStatus.ASSUMPTION_FAILURE.ordinal()]);
            sb.append(" Assumption failures");
        }
        if (results[TestResult.TestStatus.INCOMPLETE.ordinal()] > 0) {
            sb.append(" ");
            sb.append(results[TestResult.TestStatus.INCOMPLETE.ordinal()]);
            sb.append(" Incomplete");
        }
        sb.append("] \r\n");
        this.print(sb.toString());
        if (this.mDisplayInvocationAttributes && !this.mContext.getAttributes().isEmpty()) {
            StringBuilder metricPrint = new StringBuilder();
            metricPrint.append(" Metrics:\n");
            for (String key : this.mContext.getAttributes().keySet()) {
                metricPrint.append("   " + key + "=" + this.mContext.getAttributes().get(key).toString() + "\n");
            }
            this.print(metricPrint.toString());
        }
        if (this.mDisplayFailureSummary) {
            for (Map.Entry entry : this.mFailures.entrySet()) {
                this.print(ConsoleResultReporter.getTestSummary(this.mTestTag, (TestDescription)entry.getKey(), (TestResult)entry.getValue()));
            }
        }
        for (LogFile logFile : this.mLoggedFiles) {
            this.printLog(logFile);
        }
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        this.mLoggedFiles.add(logFile);
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        this.mLoggedFiles.add(logFile);
    }

    private void printLog(LogFile logFile) {
        if (this.mSuppressPassedTest && !this.mResultCountListener.hasFailedTests()) {
            return;
        }
        String logDesc = logFile.getUrl() == null ? logFile.getPath() : logFile.getUrl();
        this.print("Log: " + logDesc + "\r\n");
    }

    static String getTestSummary(String testTag, TestDescription testId, TestResult testResult) {
        Map<String, String> metrics;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s: %s: %s (%dms)\n", new Object[]{testTag, testId.toString(), testResult.getStatus(), testResult.getEndTime() - testResult.getStartTime()}));
        String stack = testResult.getStackTrace();
        if (stack != null && !stack.isEmpty()) {
            String[] lines;
            sb.append("  stack=\n");
            for (String line : lines = stack.split("\\r?\\n")) {
                sb.append(String.format("    %s\n", line));
            }
        }
        if ((metrics = testResult.getMetrics()) != null && !metrics.isEmpty()) {
            ArrayList<String> metricKeys = new ArrayList<String>(metrics.keySet());
            Collections.sort(metricKeys);
            for (String metricKey : metricKeys) {
                sb.append(String.format("    %s: %s\n", metricKey, metrics.get(metricKey)));
            }
        }
        return sb.toString();
    }

    private void print(String msg) {
        this.mStream.print(sTimeStampFormat.format(new Date()) + " " + msg);
    }
}

