/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestResultListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CountingTestResultListener
extends TestResultListener {
    private Map<TestDescription, TestResult.TestStatus> mResults = new ConcurrentHashMap<TestDescription, TestResult.TestStatus>();

    @Override
    public void testResult(TestDescription test, TestResult result) {
        this.mResults.put(test, result.getStatus());
    }

    public int[] getResultCounts() {
        int[] results = new int[TestResult.TestStatus.values().length];
        Collection<TestResult.TestStatus> data = this.mResults.values();
        for (TestResult.TestStatus status : data) {
            int n = status.ordinal();
            results[n] = results[n] + 1;
        }
        return results;
    }

    public int getTotalTests() {
        return this.mResults.size();
    }

    public boolean hasFailedTests() {
        int[] results = this.getResultCounts();
        return results[TestResult.TestStatus.INCOMPLETE.ordinal()] > 0 || results[TestResult.TestStatus.ASSUMPTION_FAILURE.ordinal()] > 0 || results[TestResult.TestStatus.FAILURE.ordinal()] > 0;
    }
}

