/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeviceFileReporter {
    private final Map<String, LogDataType> mFilePatterns = new LinkedHashMap<String, LogDataType>();
    private final ITestInvocationListener mListener;
    private final ITestDevice mDevice;
    private boolean mSkipRepeatFiles = true;
    private Set<String> mReportedFiles = new HashSet<String>();
    private boolean mInferDataTypes = true;
    private LogDataType mDefaultFileType = LogDataType.UNKNOWN;
    private static final Map<String, LogDataType> DATA_TYPE_REVERSE_MAP = new HashMap<String, LogDataType>();

    public DeviceFileReporter(ITestDevice device, ITestInvocationListener listener) {
        if (device == null || listener == null) {
            throw new NullPointerException();
        }
        this.mDevice = device;
        this.mListener = listener;
    }

    public void addPatterns(String ... patterns) {
        this.addPatterns(Arrays.asList(patterns));
    }

    public void addPatterns(List<String> patterns) {
        for (String pat : patterns) {
            this.mFilePatterns.put(pat, this.mDefaultFileType);
        }
    }

    public void addPatterns(Map<String, LogDataType> patterns) {
        this.mFilePatterns.putAll(patterns);
    }

    public void setDefaultLogDataType(LogDataType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.mDefaultFileType = type;
    }

    public void setSkipRepeatFiles(boolean skip) {
        this.mSkipRepeatFiles = skip;
    }

    public void setInferUnknownDataTypes(boolean infer) {
        this.mInferDataTypes = infer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> run() throws DeviceNotAvailableException {
        LinkedList<String> filenames = new LinkedList<String>();
        LogUtil.CLog.d(String.format("Analyzing %d patterns.", this.mFilePatterns.size()));
        for (Map.Entry<String, LogDataType> pat : this.mFilePatterns.entrySet()) {
            String searchCmd = String.format("ls %s", pat.getKey());
            String fileList = this.mDevice.executeShellCommand(searchCmd);
            if (fileList.contains(": No such file or directory")) continue;
            for (String line : fileList.split("\r?\n")) {
                if ((line = line.trim()).isEmpty()) continue;
                for (String filename : line.split("\\s+")) {
                    if (this.mSkipRepeatFiles && this.mReportedFiles.contains(filename)) {
                        LogUtil.CLog.v("Skipping already-reported file %s", filename);
                        continue;
                    }
                    File file2 = null;
                    InputStreamSource iss = null;
                    try {
                        LogUtil.CLog.d("Trying to pull file '%s' from device %s", filename, this.mDevice.getSerialNumber());
                        file2 = this.mDevice.pullFile(filename);
                        iss = this.createIssForFile(file2);
                        LogDataType type = this.getDataType(filename, pat.getValue());
                        LogUtil.CLog.d("Local file %s has size %d and type %s", file2, file2.length(), type.getFileExt());
                        this.mListener.testLog(filename, type, iss);
                        filenames.add(filename);
                        this.mReportedFiles.add(filename);
                    }
                    catch (Throwable throwable) {
                        StreamUtil.cancel(iss);
                        iss = null;
                        FileUtil.deleteFile(file2);
                        throw throwable;
                    }
                    StreamUtil.cancel(iss);
                    iss = null;
                    FileUtil.deleteFile(file2);
                }
            }
        }
        return filenames;
    }

    LogDataType getDataType(String filename, LogDataType defaultType) {
        if (!this.mInferDataTypes) {
            return defaultType;
        }
        if (!LogDataType.UNKNOWN.equals((Object)defaultType)) {
            return defaultType;
        }
        LogUtil.CLog.d("Running type inference for file %s with default type %s", new Object[]{filename, defaultType});
        String ext = FileUtil.getExtension(filename);
        LogUtil.CLog.v("Found raw extension \"%s\"", ext);
        if (ext == null) {
            return defaultType;
        }
        if (DATA_TYPE_REVERSE_MAP.containsKey(ext = ext.toLowerCase())) {
            LogDataType newType = DATA_TYPE_REVERSE_MAP.get(ext);
            LogUtil.CLog.d("Inferred data type %s", new Object[]{newType});
            return newType;
        }
        LogUtil.CLog.v("Failed to find a reverse map for extension \"%s\"", ext);
        return defaultType;
    }

    InputStreamSource createIssForFile(File file2) {
        return new FileInputStreamSource(file2);
    }

    static {
        for (LogDataType type : LogDataType.values()) {
            String ext = "." + type.getFileExt();
            if (DATA_TYPE_REVERSE_MAP.containsKey(ext)) continue;
            DATA_TYPE_REVERSE_MAP.put(ext, type);
        }
    }
}

