/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class EventsLoggerListener
implements ILogSaverListener {
    private File mLog;
    private TestResult.TestStatus mTestCaseStatus = null;

    public EventsLoggerListener(String name) {
        try {
            this.mLog = FileUtil.createTempFile(name, ".txt");
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            this.mLog = null;
        }
    }

    public File getLoggedEvents() {
        return this.mLog;
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        this.writeToFile("[invocation started]\n");
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        this.writeToFile(String.format("[invocation failed: %s|%s|%s]\n", failure.getFailureStatus(), failure.getErrorIdentifier(), failure));
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        this.writeToFile("[invocation ended]\n");
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        this.writeToFile(String.format("  [module %s started]\n", moduleContext.getAttributes().getUniqueMap().get("module-id")));
    }

    @Override
    public void testModuleEnded() {
        this.writeToFile("  [module ended]\n");
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        this.testRunStarted(runName, testCount, 0, System.currentTimeMillis());
    }

    @Override
    public void testRunStarted(String runName, int testCount, int attemptNumber) {
        this.testRunStarted(runName, testCount, attemptNumber, System.currentTimeMillis());
    }

    @Override
    public void testRunStarted(String runName, int testCount, int attemptNumber, long startTime) {
        this.writeToFile(String.format("    [run %s (testCount: %s,attempt: %s) started]\n", runName, testCount, attemptNumber));
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        this.writeToFile(String.format("        [run failed with %s|%s|%s]\n", failure.getErrorMessage(), failure.getFailureStatus(), failure.getErrorIdentifier()));
    }

    @Override
    public void testRunFailed(String errorMessage) {
        this.writeToFile(String.format("        [run failed with %s]\n", errorMessage));
    }

    @Override
    public void testRunEnded(long elapsedTimeMillis, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        this.writeToFile("    [run ended]\n");
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        this.mTestCaseStatus = TestResult.TestStatus.PASSED;
    }

    @Override
    public void testIgnored(TestDescription test) {
        this.mTestCaseStatus = TestResult.TestStatus.IGNORED;
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        this.mTestCaseStatus = TestResult.TestStatus.FAILURE;
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        this.mTestCaseStatus = TestResult.TestStatus.FAILURE;
    }

    @Override
    public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        this.mTestCaseStatus = TestResult.TestStatus.ASSUMPTION_FAILURE;
    }

    @Override
    public void testAssumptionFailure(TestDescription test, String trace) {
        this.mTestCaseStatus = TestResult.TestStatus.ASSUMPTION_FAILURE;
    }

    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.writeToFile(String.format("      - test: %s (status=%s)\n", new Object[]{test, this.mTestCaseStatus}));
        this.mTestCaseStatus = null;
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        String extra = "";
        if (this.mTestCaseStatus != null) {
            extra = "test";
        }
        this.writeToFile(String.format("[   %s log: %s | path: %s]\n", extra, dataName, logFile.getPath()));
    }

    private void writeToFile(String text) {
        if (this.mLog == null || !this.mLog.exists()) {
            return;
        }
        try {
            FileUtil.writeToFile(text, this.mLog, true);
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }
}

