/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ActionInProgress;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import javax.annotation.Nullable;

public class FailureDescription {
    private String mErrorMessage;
    @Nullable
    private TestRecordProto.FailureStatus mFailureStatus = TestRecordProto.FailureStatus.UNSET;
    @Nullable
    private ActionInProgress mActionInProgress = ActionInProgress.UNSET;
    @Nullable
    private String mDebugHelpMessage = null;
    @Nullable
    private Throwable mCause = null;
    private boolean mRetriable = true;
    private boolean mRunFailureReRunAll = true;
    @Nullable
    private ErrorIdentifier mErrorId = null;
    @Nullable
    private String mOrigin = null;

    FailureDescription() {
    }

    public FailureDescription setFailureStatus(TestRecordProto.FailureStatus status) {
        this.mFailureStatus = status;
        if (this.mErrorId != null && this.mFailureStatus != this.mErrorId.status()) {
            LogUtil.CLog.w("Failure: %s, status set to %s, not aligned with errorId: %s (%s)", this, this.mFailureStatus, this.mErrorId, this.mErrorId.status());
        }
        return this;
    }

    @Nullable
    public TestRecordProto.FailureStatus getFailureStatus() {
        if (TestRecordProto.FailureStatus.UNSET.equals(this.mFailureStatus)) {
            return null;
        }
        return this.mFailureStatus;
    }

    public FailureDescription setActionInProgress(ActionInProgress action) {
        this.mActionInProgress = action;
        return this;
    }

    @Nullable
    public ActionInProgress getActionInProgress() {
        return this.mActionInProgress;
    }

    public FailureDescription setDebugHelpMessage(String message2) {
        this.mDebugHelpMessage = message2;
        return this;
    }

    @Nullable
    public String getDebugHelpMessage() {
        return this.mDebugHelpMessage;
    }

    public FailureDescription setCause(Throwable cause) {
        this.mCause = cause;
        return this;
    }

    @Nullable
    public Throwable getCause() {
        return this.mCause;
    }

    public FailureDescription setRetriable(boolean retriable) {
        this.mRetriable = retriable;
        return this;
    }

    public boolean isRetriable() {
        return this.mRetriable;
    }

    public FailureDescription setFullRerun(boolean fullRerun) {
        this.mRunFailureReRunAll = fullRerun;
        return this;
    }

    public boolean rerunFull() {
        return this.mRunFailureReRunAll;
    }

    public FailureDescription setErrorIdentifier(ErrorIdentifier errorId) {
        this.mErrorId = errorId;
        if (this.getFailureStatus() == null && errorId != null) {
            this.mFailureStatus = errorId.status();
        }
        return this;
    }

    public ErrorIdentifier getErrorIdentifier() {
        return this.mErrorId;
    }

    public FailureDescription setOrigin(String origin) {
        this.mOrigin = origin;
        return this;
    }

    public String getOrigin() {
        return this.mOrigin;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getFormattedErrorMessage() {
        StringBuilder s = new StringBuilder();
        if (this.mErrorId != null) {
            s.append("[");
            s.append(this.mErrorId.name());
            s.append("|");
            s.append(this.mErrorId.code());
            s.append("|");
            s.append(this.mErrorId.status());
            s.append("] ");
        }
        s.append(this.toString());
        return s.toString();
    }

    public String toString() {
        return this.mErrorMessage;
    }

    public static FailureDescription create(String errorMessage) {
        return FailureDescription.create(errorMessage, TestRecordProto.FailureStatus.UNSET);
    }

    public static FailureDescription create(String errorMessage, @Nullable TestRecordProto.FailureStatus status) {
        FailureDescription info = new FailureDescription();
        info.mErrorMessage = errorMessage;
        info.mFailureStatus = status;
        return info;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mActionInProgress == null ? 0 : this.mActionInProgress.hashCode());
        result = 31 * result + (this.mDebugHelpMessage == null ? 0 : this.mDebugHelpMessage.hashCode());
        result = 31 * result + (this.mErrorMessage == null ? 0 : this.mErrorMessage.hashCode());
        result = 31 * result + (this.mFailureStatus == null ? 0 : this.mFailureStatus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FailureDescription other = (FailureDescription)obj;
        if (this.mActionInProgress != other.mActionInProgress) {
            return false;
        }
        if (this.mDebugHelpMessage == null ? other.mDebugHelpMessage != null : !this.mDebugHelpMessage.equals(other.mDebugHelpMessage)) {
            return false;
        }
        if (this.mErrorMessage == null ? other.mErrorMessage != null : !this.mErrorMessage.equals(other.mErrorMessage)) {
            return false;
        }
        return this.mFailureStatus == other.mFailureStatus;
    }
}

